(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[6387],{34932:(e,t,n)=>{"use strict";n.d(t,{Z:()=>o});var a=n(94015),s=n.n(a),r=n(23645),i=n.n(r)()(s());i.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/student/fee/index.vue"],names:[],mappings:"AAk2BA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <div class="page-titles">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                    <h3 class="text-themecolor">{{trans(\'finance.fee_detail\')}} <small v-if="student_record.student">{{getStudentName(student_record.student)}}  ({{student_record.academic_session.name}})</small>\n                    </h3>\n                </div>\n                <div class="col-12 col-sm-6">\n                    <div class="action-buttons pull-right">\n                        <router-link to="/student/list" class="btn btn-info btn-sm"><i class="fas fa-list"></i> <span class="d-none d-sm-inline">{{trans(\'student.student\')}}</span></router-link>\n                        <div class="btn-group">\n                            <button type="button" class="btn btn-info btn-sm dropdown-toggle no-caret " role="menu" id="moreOption" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-tooltip="trans(\'general.more_option\')">\n                                <i class="fas fa-ellipsis-h"></i> <span class="d-none d-sm-inline"></span>\n                            </button>\n                            <div :class="[\'dropdown-menu\',getConfig(\'direction\') == \'ltr\' ? \'dropdown-menu-right\' : \'\']" aria-labelledby="moreOption">\n                                <button class="dropdown-item custom-dropdown" @click="$router.push(\'/student/\'+student_record.student.uuid)"><i class="fas fa-arrow-circle-right"></i> {{trans(\'student.view_detail\')}}</button>\n                                <button class="dropdown-item custom-dropdown" v-if="hasPermission(\'set-fee\')" @click="$router.push(\'/student/\'+student_record.student.uuid+\'/fee/\'+student_record.id+\'/set\')"><i class="fas fa-file"></i> {{trans(\'student.set_fee\')}}</button>\n                                <button class="dropdown-item custom-dropdown" @click="print"><i class="fas fa-print"></i> {{trans(\'general.print\')}}</button>\n                                <button class="dropdown-item custom-dropdown" @click="pdf"><i class="fas fa-file-pdf"></i> {{trans(\'general.generate_pdf\')}}</button>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="container-fluid">\n            <div class="row">\n                <div class="col-12">\n                    <div class="card">\n                        <div class="card-body py-4">\n                            <student-summary :student-record="student_record" class="border-bottom"></student-summary>\n                        </div>\n                        <div class="card-body">\n                            <div class="row justify-content-end px-4" v-if="hasPermission(\'customize-fee-date\')">\n                                <div class="col-12 col-sm-3">\n                                    <div class="form-group">\n                                        <datepicker v-model="feePayment.date" :bootstrapStyling="true" :placeholder="trans(\'student.date_of_payment\')"></datepicker>\n                                    </div>\n                                </div>\n                            </div>\n                            <template v-for="fee_allocation_group in student_record.fee_allocation.fee_allocation_groups">\n                                <h4 class="card-title m-l-20">{{fee_allocation_group.fee_group.name}}</h4>\n                                <div class="table-responsive p-3">\n                                    <table class="table table-sm">\n                                        <thead>\n                                            <tr>\n                                                <th>{{trans(\'finance.fee_installment_title\')}}</th>\n                                                <th>{{trans(\'finance.fee_installment_due_date\')}}</th>\n                                                <th v-for="fee_head in fee_allocation_group.fee_group.fee_heads" v-text="fee_head.name"></th>\n                                                <th>\n                                                    <span v-if="fee_allocation_group.fee_group.options.has_transport">{{trans(\'transport.circle\')}}</span>\n                                                </th>\n                                                <th>\n                                                    <span v-if="fee_allocation_group.fee_group.options.has_transport">{{trans(\'transport.fee\')}}</span>\n                                                </th>\n                                                <th>{{trans(\'finance.late_fee\')}}</th>\n                                                <th>{{trans(\'finance.installment_total\')}}</th>\n                                                <th>{{trans(\'finance.other\')}}</th>\n                                                <th>{{trans(\'finance.paid\')}}</th>\n                                                <th>{{trans(\'finance.balance\')}}</th>\n                                                <th v-if="hasPermission(\'make-fee-payment\')">{{trans(\'finance.pay_fee\')}}</th>\n                                                <th v-else>{{trans(\'finance.fee_status\')}}</th>\n                                            </tr>\n                                        </thead>\n                                        <tbody>\n                                            <tr v-for="fee_installment in fee_allocation_group.fee_installments">\n                                                <td>{{fee_installment.title}}</td>\n                                                <td>{{getInstallmentDueDate(fee_installment)}}\n                                                    <template v-if="isInstallmentOverdue(fee_installment)">\n                                                        <br />\n                                                        <span class="label label-danger">{{trans(\'finance.fee_overdue_day\', {day: isInstallmentOverdue(fee_installment)})}}</span>\n                                                    </template>\n                                                </td>\n                                                <td v-for="fee_head in fee_allocation_group.fee_group.fee_heads">\n                                                    <span v-if="checkInstallmentConcession(fee_installment, fee_head.id)" style="text-decoration: line-through;">{{getInstallmentFeeAmountWithoutConcession(fee_installment, fee_head.id)}}</span>\n                                                    {{getInstallmentFeeAmount(fee_installment, fee_head.id)}}\n                                                </td>\n                                                <td>\n                                                    <span v-if="fee_allocation_group.fee_group.options.has_transport">{{getTransportCircleName(fee_installment)}}</span>\n                                                </td>\n                                                <td>\n                                                    <span v-if="fee_allocation_group.fee_group.options.has_transport">{{getTransportFeeAmount(fee_installment)}}</span>\n                                                </td>\n                                                <td>{{getLateFeeAmount(fee_installment)}}</td>\n                                                <td>{{getInstallmentTotalAmount(fee_installment)}}</td>\n                                                <td>{{getInstallmentOtherAmount(fee_installment)}}</td>\n                                                <td>{{getInstallmentPaidAmount(fee_installment)}}</td>\n                                                <td>{{getInstallmentBalanceAmount(fee_installment)}}</td>\n                                                <td v-if="hasPermission(\'make-fee-payment\')">\n                                                    <span v-if="getInstallmentStatus(fee_installment) == \'unpaid\'">\n                                                        <button type="button" class="btn btn-info btn-sm" @click="showInstallmentDetail(fee_allocation_group,fee_installment)">{{trans(\'finance.pay_fee\')}}</button>\n                                                    </span>\n                                                    <span v-else-if="getInstallmentStatus(fee_installment) == \'cancelled\'">\n                                                        <span class="label label-danger">{{trans(\'finance.fee_status_cancelled\')}}</span>\n                                                    </span>\n                                                    <span v-else>\n                                                        <div class="btn-group">\n                                                            <template v-if="getInstallmentStatus(fee_installment) == \'paid\'">\n                                                                <button class="btn btn-sm btn-success">{{trans(\'student.fee_status_paid\')}}</button>\n                                                                <button type="button" class="btn btn-sm btn-success dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n                                                                    <span class="sr-only">Toggle Dropdown</span>\n                                                                </button>\n                                                            </template>\n                                                            <template v-if="getInstallmentStatus(fee_installment) == \'partially_paid\'">\n                                                                <button class="btn btn-sm btn-warning" @click="showInstallmentDetail(fee_allocation_group,fee_installment)">{{trans(\'student.fee_status_partially_paid\')}}</button>\n                                                                <button type="button" class="btn btn-sm btn-warning dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n                                                                    <span class="sr-only">Toggle Dropdown</span>\n                                                                </button>\n                                                            </template>\n\n                                                            <div class="dropdown-menu">\n                                                                <button class="dropdown-item custom-dropdown-menu" @click.prevent="setTransaction(fee_installment)" v-if="getInstallmentPaid(fee_installment)">\n                                                                    <i class="fas fa-arrow-circle-right"></i> {{trans(\'finance.receipt_detail\')}}\n                                                                </button>\n                                                                <button class="dropdown-item custom-dropdown-menu" :key="fee_installment.id" v-confirm="{ok: confirmEmptyReceiptDelete(fee_installment)}" v-else-if="!getInstallmentPaid(fee_installment) && hasPermission(\'cancel-fee-payment\')">\n                                                                    <i class="fas fa-arrow-circle-right"></i> {{trans(\'student.cancel_fee_payment\')}}\n                                                                </button>\n                                                            </div>\n                                                        </div>\n                                                    </span>\n                                                </td>\n                                                <td v-else>\n                                                    <span v-if="getInstallmentStatus(fee_installment) == \'unpaid\'">{{trans(\'student.fee_status_unpaid\')}}</span>\n                                                    <span v-else>{{trans(\'student.fee_status_paid\')}}</span>\n                                                </td>\n                                            </tr>\n\n                                            <tr>\n                                                <th colspan="2">{{trans(\'general.total\')}}</th>\n                                                <th v-for="fee_head in fee_allocation_group.fee_group.fee_heads">\n                                                    {{getTotalFee(fee_allocation_group, fee_head.id)}}\n                                                </th>\n                                                <th></th>\n                                                <th>\n                                                    <span v-if="fee_allocation_group.fee_group.options.has_transport">{{getTransportFeeTotal(fee_allocation_group)}}</span>\n                                                </th>\n                                                <th>{{getLateFeeTotal(fee_allocation_group)}}</th>\n                                                <th>{{getInstallmentGrandTotal(fee_allocation_group)}}</th>\n                                                <th>{{getInstallmentGrandOther(fee_allocation_group)}}</th>\n                                                <th>{{getInstallmentPaidGrandTotal(fee_allocation_group)}}</th>\n                                                <th>{{getInstallmentBalanceGrandTotal(fee_allocation_group)}}</th>\n                                                <th v-if="hasPermission(\'make-fee-payment\')"></th>\n                                                <th v-else></th>\n                                            </tr>\n                                        </tbody>\n                                    </table>\n                                </div>\n                            </template>\n\n\n                            <div class="table-responsive p-3">\n                                <table class="table table">\n                                    <thead>\n                                        <tr>\n                                            <th>{{trans(\'finance.installment_total\')}}</th>\n                                            <th>{{trans(\'finance.other\')}}</th>\n                                            <th>{{trans(\'finance.paid\')}}</th>\n                                            <th>{{trans(\'finance.balance\')}}</th>\n                                        </tr>\n                                    </thead>\n                                    <tbody>\n                                        <tr>\n                                            <td>{{finalTotal}}</td>\n                                            <td>{{finalOther}}</td>\n                                            <td>{{finalPaid}}</td>\n                                            <td>{{finalBalance}}</td>\n                                        </tr>\n                                    </tbody>\n                                </table>\n                            </div>\n\n                            <div class="row justify-content-md-center" v-if="resetFeeOption && hasPermission(\'set-fee\')">\n                                <div class="col-4">\n                                    <button class="btn btn-danger btn-block" :key="student_record.id" v-confirm="{ok: confirmResetFee(student_record)}" v-tooltip="trans(\'student.reset_fee\')">{{trans(\'student.reset_fee\')}}</button>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n\n        <fee-payment-form v-if="feePaymentForm && hasNotAnyRole([\'parent\',\'student\']) && hasPermission(\'make-fee-payment\')" :uuid="uuid" :id="record_id" :fee-payment="feePayment" @completed="paymentMade" @closeFeePaymentForm="feePaymentForm = false"></fee-payment-form>\n        <fee-payment-parent-form v-if="feePaymentForm && hasAnyRole([\'parent\',\'student\']) && hasPermission(\'make-fee-payment\')" :uuid="uuid" :id="record_id" :fee-payment="feePayment" @completed="paymentMade" @closeFeePaymentForm="feePaymentForm = false"></fee-payment-parent-form>\n\n        <transition name="modal" v-if="feePaymentShow">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'finance.fee_payment\')}}\n                                <span class="float-right pointer" @click="feePaymentShow = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <div style="max-height:600px;">\n                                    <fee-detail :uuid="uuid" :rid="record_id" :id="student_fee_record_id" @completed="getRecord"></fee-detail>\n                                    <div class="clearfix"></div>\n                                </div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n    </div>\n</template>\n\n<script>\n    import studentSummary from \'./../summary\'\n    import feePaymentForm from \'./payment\'\n    import feePaymentParentForm from \'./payment-parent\'\n    import feeDetail from \'./fee-detail\'\n\n    export default {\n        components : {studentSummary,feePaymentForm,feePaymentParentForm,feeDetail},\n        data() {\n            return {\n                uuid:this.$route.params.uuid,\n                record_id:this.$route.params.record_id,\n                student_record: {\n                    fee_allocation: {\n                        fee_allocation_groups: []\n                    }\n                },\n                feePayment: {\n                    fee_group_name: \'\',\n                    fee_payment_installment_id: \'\',\n                    student_fee_record_id: \'\',\n                    date: helper.today(),\n                    installments: [],\n                    amount: 0\n                },\n                fee: {\n                    groups: []\n                },\n                feePaymentForm: false,\n                feePaymentShow: false\n            };\n        },\n        mounted(){\n            if(!helper.hasPermission(\'list-student-fee\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getRecord();\n            helper.showDemoNotification([\'student\']);\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            hasAnyRole(roles){\n                return helper.hasAnyRole(roles);\n            },\n            hasNotAnyRole(roles){\n                return helper.hasNotAnyRole(roles);\n            },\n            getConfig(config){\n                return helper.getConfig(config);\n            },\n            getStudentName(student){\n                return helper.getStudentName(student);\n            },\n            getRecord(){\n                let loader = this.$loading.show();\n                this.feePaymentForm = false;\n                this.feePaymentShow = false;\n                axios.get(\'/api/student/\'+this.uuid+\'/fee/\'+this.record_id)\n                    .then(response => {\n                        this.student_record = response.student_record;\n\n                        if (! this.student_record.student_fee_records.length) {\n                            this.$router.push(\'/student/\'+this.uuid); \n                        }\n\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        if (this.hasAnyRole([\'student\',\'parent\'])) {\n                            this.$router.push(\'/student/list\')\n                        } else {\n                           this.$router.push(\'/student/\'+this.uuid+\'/fee/\'+this.record_id+\'/create\'); \n                        }\n                    });\n            },\n            calculate(){\n                this.fee = {\n                    groups: []\n                };\n                this.student_record.fee_allocation.fee_allocation_groups.forEach(fee_allocation_group => {\n                    let installments = [];\n                    let heads = [];\n                    let foots = [];\n                    heads.push(i18n.finance.fee_installment_title);\n                    heads.push(i18n.finance.fee_installment_due_date);\n\n                    fee_allocation_group.fee_group.fee_heads.forEach(fee_head => {\n                        heads.push(fee_head.name);\n                    });\n\n                    if (fee_allocation_group.fee_group.options.has_transport) {\n                        heads.push(i18n.transport.circle);\n                        heads.push(i18n.transport.fee);\n                    }\n\n                    foots.push(i18n.finance.total);\n                    foots.push(\'\');\n\n                    heads.push(i18n.finance.late_fee);\n                    heads.push(i18n.finance.installment_total);\n                    heads.push(i18n.finance.other);\n                    heads.push(i18n.finance.paid);\n                    heads.push(i18n.finance.balance);\n                    heads.push(i18n.finance.fee_status);\n\n                    fee_allocation_group.fee_installments.forEach(fee_installment => {\n                        let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n                        \n                        let installment_data = [];\n                        installment_data.push({\n                            text: fee_installment.title\n                        });\n                        installment_data.push({\n                            text: this.showDate(student_fee_record.due_date || fee_installment.due_date)\n                        });\n\n                        fee_allocation_group.fee_group.fee_heads.forEach(fee_head => {\n                            installment_data.push({\n                                text: this.getInstallmentFeeAmount(fee_installment, fee_head.id),\n                                actual: this.getInstallmentFeeAmountWithoutConcession(fee_installment, fee_head.id),\n                                is_concession: this.checkInstallmentConcession(fee_installment, fee_head.id) ? true : false\n                            });\n                        });\n\n                        if (fee_allocation_group.fee_group.options.has_transport) {\n                            installment_data.push({\n                                text: this.getTransportCircleName(fee_installment)\n                            });\n                            installment_data.push({\n                                text: this.getTransportFeeAmount(fee_installment)\n                            });\n                        }\n\n                        installment_data.push({\n                            text: this.getLateFeeAmount(fee_installment)\n                        });\n\n                        installment_data.push({\n                            text: this.getInstallmentTotalAmount(fee_installment)\n                        })\n\n                        installment_data.push({\n                            text: this.getInstallmentOtherAmount(fee_installment)\n                        })\n\n                        installment_data.push({\n                            text: this.getInstallmentPaidAmount(fee_installment)\n                        })\n\n                        installment_data.push({\n                            text: this.getInstallmentBalanceAmount(fee_installment)\n                        })\n\n                        installment_data.push({\n                            text: this.getInstallmentPrintStatus(fee_installment)\n                        })\n\n                        installments.push({\n                            data: installment_data\n                        });\n                    });\n\n                    fee_allocation_group.fee_group.fee_heads.forEach(fee_head => {\n                        foots.push(this.getTotalFee(fee_allocation_group, fee_head.id));\n                    });\n                    \n                    if (fee_allocation_group.fee_group.options.has_transport) {\n                        foots.push(\'\');\n                        foots.push(this.getTransportFeeTotal(fee_allocation_group));\n                    }\n                    \n                    foots.push(this.getLateFeeTotal(fee_allocation_group));\n                    foots.push(this.getInstallmentGrandTotal(fee_allocation_group));\n                    foots.push(this.getInstallmentGrandOther(fee_allocation_group));\n                    foots.push(this.getInstallmentPaidGrandTotal(fee_allocation_group));\n                    foots.push(this.getInstallmentBalanceGrandTotal(fee_allocation_group));\n                    foots.push(\'\');\n\n                    let group = {\n                        name: fee_allocation_group.fee_group.name,\n                        heads: heads,\n                        installments: installments,\n                        foots: foots,\n                    }\n                    this.fee.groups.push(group);\n                });\n            },\n            formatCurrency(amount){\n                return helper.formatCurrency(amount);\n            },\n            isInstallmentOverdue(fee_installment){\n                let installment = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n\n                if (helper.today() > (installment.due_date || fee_installment.due_date) && installment.status != \'paid\') {\n                    return helper.getDateDiff(installment.due_date || fee_installment.due_date);\n                }\n\n                return 0;\n            },\n            getStatus(fee_installment) {\n                let installment = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n                if (installment.status == \'paid\') {\n                    return \'<span class="label label-success">\'+i18n.student.fee_status_paid+\'</span>\';\n                } else if(installment.status == \'partially_paid\') {\n                    return \'<span class="label label-warning">\'+i18n.student.fee_status_partially_paid+\'</span>\';\n                } else if(installment.status == \'cancelled\') {\n                    return \'<span class="label label-danger">\'+i18n.student.fee_status_cancelled+\'</span>\';\n                } else {\n                    return \'<span class="label label-danger">\'+i18n.student.fee_status_unpaid+\'</span>\';\n                }\n            },\n            getInstallmentDueDate(fee_installment){\n                let installment = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n\n                return helper.formatDate(installment.due_date || fee_installment.due_date);\n            },\n            getInstallmentStatus(fee_installment){\n                let installment = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n\n                return installment.status;\n            },\n            getInstallmentFee(fee_installment, fee_head_id){\n                let amount = this.getInstallmentFeeWithoutConcession(fee_installment, fee_head_id);\n                return this.getInstallmentFeeWithConcession(amount, fee_installment, fee_head_id);\n            },\n            getInstallmentFeeWithoutConcession(fee_installment, fee_head_id){\n                let installment_detail = fee_installment.fee_installment_details.find(o => o.fee_head_id == fee_head_id);\n\n                if (typeof installment_detail == \'undefined\')\n                    return 0;\n\n                let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n                let student_optional_fee_record = student_fee_record.student_optional_fee_records.findIndex(o => o.fee_head_id == fee_head_id);\n\n                return (student_optional_fee_record < 0) ? installment_detail.amount : 0;\n            },\n            checkInstallmentConcession(fee_installment, fee_head_id){\n                let installment_detail = fee_installment.fee_installment_details.find(o => o.fee_head_id == fee_head_id);\n\n                let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n\n                let fee_concession_index = (student_fee_record.fee_concession) ? student_fee_record.fee_concession.fee_concession_details.findIndex(o => o.fee_head_id == fee_head_id) : -1;\n\n                return (fee_concession_index >= 0) ? true : false;\n            },\n            getInstallmentFeeWithConcession(amount, fee_installment, fee_head_id){\n                let installment_detail = fee_installment.fee_installment_details.find(o => o.fee_head_id == fee_head_id);\n\n                let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n\n                let fee_concession_index = (student_fee_record.fee_concession) ? student_fee_record.fee_concession.fee_concession_details.findIndex(o => o.fee_head_id == fee_head_id) : -1;\n\n                if (fee_concession_index >= 0) {\n                    let fee_concession = student_fee_record.fee_concession.fee_concession_details[fee_concession_index];\n\n                    let fee_concession_amount = fee_concession.type == \'percent\' ? (amount * (fee_concession.amount/100)) : fee_concession.amount;\n\n                    return ((amount - fee_concession_amount) >= 0) ? Math.ceil(amount - fee_concession_amount) : 0;\n                }\n\n                return Math.ceil(amount);\n            },\n            getInstallmentFeeAmountWithoutConcession(fee_installment, fee_head_id){\n                let amount = this.getInstallmentFeeWithoutConcession(fee_installment, fee_head_id);\n\n                return helper.formatCurrency(amount);\n            },\n            getInstallmentFeeAmount(fee_installment, fee_head_id){\n                let amount = this.getInstallmentFee(fee_installment, fee_head_id);\n                return helper.formatCurrency(amount);\n            },\n            getInstallmentTotalWithoutLateFee(fee_installment){\n                let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id)\n\n                let total = 0;\n                fee_installment.fee_installment_details.forEach(installment_detail => {\n                    total += this.getInstallmentFee(fee_installment, installment_detail.fee_head_id);\n                });\n\n                let transport_fee = this.getTransportFee(fee_installment);\n\n                total += ((Number.isInteger(transport_fee)) ? transport_fee : 0);\n\n                return total;\n            },\n            getInstallmentTotal(fee_installment){\n                let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id)\n                \n                let total = this.getInstallmentTotalWithoutLateFee(fee_installment);\n\n                if (total || student_fee_record.status != \'unpaid\') {\n                    let late_fee = this.getLateFee(fee_installment);\n                    total += ((Number.isInteger(late_fee)) ? late_fee : 0);\n                }\n\n                return total;\n            },\n            getInstallmentTotalAmount(fee_installment){\n                let amount = this.getInstallmentTotal(fee_installment);\n                return helper.formatCurrency(amount);\n            },\n            getInstallmentOther(fee_installment){\n                let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n\n                let other = 0;\n                student_fee_record.transactions.forEach(transaction => {\n                    if (! transaction.is_cancelled) {\n                        if (transaction.options.additional_fee_charge && transaction.options.additional_fee_charge.amount) {\n                            other += transaction.options.additional_fee_charge.amount;\n                        }\n                        if (transaction.options.additional_fee_discount && transaction.options.additional_fee_discount.amount) {\n                            other -= transaction.options.additional_fee_discount.amount;\n                        }\n                    }\n                });\n\n                return other;\n            },\n            getInstallmentOtherAmount(fee_installment){\n                let amount = this.getInstallmentOther(fee_installment);\n                return helper.formatCurrency(amount);\n            },\n            getInstallmentPaid(fee_installment){\n                let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n\n                let paid = 0;\n                student_fee_record.transactions.forEach(transaction => {\n                    if (! transaction.is_cancelled)\n                        paid += transaction.amount;\n                });\n\n                return paid;\n            },\n            getInstallmentPaidAmount(fee_installment){\n                let amount = this.getInstallmentPaid(fee_installment);\n                return helper.formatCurrency(amount);\n            },\n            getInstallmentBalance(fee_installment){\n                let total = this.getInstallmentTotal(fee_installment);\n                let other = this.getInstallmentOther(fee_installment);\n                let paid = this.getInstallmentPaid(fee_installment);\n                return total + other - paid;\n            },\n            getInstallmentBalanceAmount(fee_installment){\n                let amount = this.getInstallmentBalance(fee_installment);\n                return helper.formatCurrency(amount);\n            },\n            getTransportCircleName(fee_installment){\n                let installment = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n                return installment.transport_circle ? installment.transport_circle.name : \'-\';\n            },\n            getTransportFee(fee_installment){\n                let installment = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n\n                if (! installment.transport_circle_id || ! fee_installment.transport_fee_id)\n                    return \'-\';\n\n                let transport_fee = fee_installment.transport_fee.transport_fee_details.find(o => o.transport_circle_id == installment.transport_circle_id);\n                return transport_fee.amount;\n            },\n            getTransportFeeAmount(fee_installment){\n                let amount = this.getTransportFee(fee_installment);\n                return (Number.isInteger(amount)) ? helper.formatCurrency(amount) : \'-\';\n            },\n            getLateFeeAmount(fee_installment){\n                let amount = this.getLateFee(fee_installment);\n                return (Number.isInteger(amount)) ? helper.formatCurrency(amount) : \'-\';\n            },\n            getLateFee(fee_installment){\n                let installment_total = this.getInstallmentTotalWithoutLateFee(fee_installment);\n\n                if (! installment_total)\n                    return \'-\';\n\n                let date = helper.toDate(this.feePayment.date);\n\n                let installment = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n\n                if (installment.status == \'paid\') {\n                    return installment.late_fee_charged;\n                }\n\n                if ((installment.late_fee_applicable == null && !fee_installment.late_fee_applicable) || installment.late_fee_applicable == 0)\n                    return \'-\';\n\n                if (date <= (installment.due_date || fee_installment.due_date))\n                    return \'-\';\n\n                let late_day = helper.getDateDiff((installment.due_date || fee_installment.due_date), date);\n\n                let per_period = Math.floor(late_day / (installment.late_fee_frequency || fee_installment.late_fee_frequency));\n                return (installment.late_fee || fee_installment.late_fee) * per_period;\n            },\n            showInstallmentDetail(fee_allocation_group, fee_installment){\n                this.feePayment.installments = [];\n                this.feePayment.fee_group_name = fee_allocation_group.fee_group.name;\n                let installments = fee_allocation_group.fee_installments.filter(o => o.due_date <= fee_installment.due_date);\n\n                let total = 0;\n                installments.forEach(installment => {\n                    let student_installment = this.student_record.student_fee_records.find(o => o.fee_installment_id == installment.id);\n                    if (student_installment.status == \'unpaid\' || student_installment.status == \'partially_paid\') {\n\n                        let installment_fee = this.getInstallmentTotalWithoutLateFee(installment);\n                        let other = this.getInstallmentOther(installment);\n                        let late_fee = this.getLateFee(installment);\n                        let paid = this.getInstallmentPaid(installment);\n                        installment_fee += other;\n\n                        let installment_balance = (installment_fee > paid) ? (installment_fee - paid) : 0\n                        if (installment_fee) {\n                            late_fee = ((Number.isInteger(late_fee)) ? late_fee : 0)\n                        }\n                        let late_fee_balance = (!installment_balance && late_fee) ? (late_fee - (paid - installment_fee)) : late_fee;\n\n                        let installment_total = installment_fee;\n                        if (installment_fee) {\n                            late_fee = ((Number.isInteger(late_fee)) ? late_fee : 0)\n                            installment_total += late_fee;\n                        }\n\n                        let balance = installment_total - paid;\n                        total += balance;\n\n                        this.feePayment.installments.push({\n                            fee_installment_id:  student_installment.fee_installment_id,\n                            title: installment.title,\n                            installment_fee: installment_fee,\n                            installment_balance: installment_balance,\n                            late_fee_balance: (Number.isInteger(late_fee_balance)) ? late_fee_balance : 0,\n                            late_fee: late_fee,\n                            paid: paid,\n                            total: balance\n                        })\n                    }\n                });\n                this.feePayment.amount = total;\n                this.feePayment.fee_payment_installment_id = fee_installment.id;\n                this.feePaymentForm = true;\n            },\n            getTotalFee(fee_allocation_group, fee_head_id){\n                let total = 0;\n                fee_allocation_group.fee_installments.forEach(fee_installment => {\n                    total += this.getInstallmentFee(fee_installment, fee_head_id);\n                });\n                return helper.formatCurrency(total);\n            },\n            getTransportFeeTotal(fee_allocation_group){\n                let total = 0;\n                fee_allocation_group.fee_installments.forEach(fee_installment => {\n                    let fee = this.getTransportFee(fee_installment);\n                    total += ((Number.isInteger(fee)) ? fee : 0);\n                });\n                return total ? this.formatCurrency(total) : \'-\';\n            },\n            getLateFeeTotal(fee_allocation_group){\n                let total = 0;\n                fee_allocation_group.fee_installments.forEach(fee_installment => {\n                    let fee = this.getLateFee(fee_installment);\n                    total += ((Number.isInteger(fee)) ? fee : 0);\n                });\n                return total ? this.formatCurrency(total) : \'-\';\n            },\n            getInstallmentGrandTotal(fee_allocation_group){\n                let amount = this.getInstallmentGrandTotalAmount(fee_allocation_group);\n                return (Number.isInteger(amount)) ? helper.formatCurrency(amount) : \'-\';\n            },\n            getInstallmentGrandTotalAmount(fee_allocation_group){\n                let total = 0;\n                fee_allocation_group.fee_installments.forEach(fee_installment => {\n                    total += this.getInstallmentTotal(fee_installment);\n                });\n                return total;\n            },\n            getInstallmentGrandOther(fee_allocation_group){\n                let amount = this.getInstallmentGrandOtherAmount(fee_allocation_group);\n                return (Number.isInteger(amount)) ? helper.formatCurrency(amount) : \'-\';\n            },\n            getInstallmentGrandOtherAmount(fee_allocation_group){\n                let other = 0;\n                fee_allocation_group.fee_installments.forEach(fee_installment => {\n                    other += this.getInstallmentOther(fee_installment);\n                });\n                return other;\n            },\n            getInstallmentPaidGrandTotal(fee_allocation_group){\n                let amount = this.getInstallmentPaidGrandTotalAmount(fee_allocation_group);\n                return (Number.isInteger(amount)) ? helper.formatCurrency(amount) : \'-\';\n            },\n            getInstallmentPaidGrandTotalAmount(fee_allocation_group){\n                let total = 0;\n                fee_allocation_group.fee_installments.forEach(fee_installment => {\n                    total += this.getInstallmentPaid(fee_installment);\n                });\n                return total;\n            },\n            getInstallmentBalanceGrandTotal(fee_allocation_group){\n                let amount = this.getInstallmentBalanceGrandTotalAmount(fee_allocation_group);\n                return (Number.isInteger(amount)) ? helper.formatCurrency(amount) : \'-\';\n            },\n            getInstallmentBalanceGrandTotalAmount(fee_allocation_group){\n                let total = 0;\n                fee_allocation_group.fee_installments.forEach(fee_installment => {\n                    total += this.getInstallmentBalance(fee_installment);\n                });\n                return total;\n            },\n            paymentMade(){\n                this.getRecord();\n            },\n            showDate(date){\n                return helper.formatDate(date);\n            },\n            getInstallmentPrintStatus(fee_installment){\n                let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n\n                if (student_fee_record.status == \'paid\')\n                    return i18n.student.fee_status_paid;\n                else if(student_fee_record.status == \'partially_paid\')\n                    return i18n.student.fee_status_partially_paid;\n                else if(student_fee_record.status == \'cancelled\')\n                    return i18n.student.fee_status_cancelled;\n                else if(student_fee_record.status == \'unpaid\')\n                    return i18n.student.fee_status_unpaid;\n            },\n            setTransaction(fee_installment) {\n                let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n                this.student_fee_record_id = student_fee_record.id;\n                this.feePaymentShow = true;\n            },\n            print(){\n                let loader = this.$loading.show();\n                this.calculate();\n                axios.post(\'/api/student/\'+this.uuid+\'/fee/\'+this.record_id+\'/print\',{fee: this.fee})\n                    .then(response => {\n                        let print = window.open("/print");\n                        loader.hide();\n                        print.document.write(response);\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            pdf(){\n                let loader = this.$loading.show();\n                this.calculate();\n                axios.post(\'/api/student/\'+this.uuid+\'/fee/\'+this.record_id+\'/pdf\',{fee: this.fee})\n                    .then(response => {\n                        loader.hide();\n                        window.open(\'/download/report/\'+response+\'?token=\'+this.authToken);\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            confirmEmptyReceiptDelete(fee_installment){\n                return dialog => this.deleteEmptyReceipt(fee_installment);\n            },\n            deleteEmptyReceipt(fee_installment){\n                let loader = this.$loading.show();\n                let student_fee_record = this.student_record.student_fee_records.find(o => o.fee_installment_id == fee_installment.id);\n                axios.post(\'/api/student/\'+this.uuid+\'/fee/\'+this.record_id+\'/\'+student_fee_record.id+\'/cancel\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.getRecord();\n                        loader.hide();\n                    }).catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            confirmResetFee(student_record){\n                return dialog => this.resetFee(student_record);\n            },\n            resetFee(student_record){\n                let loader = this.$loading.show();\n                axios.patch(\'/api/student/\'+this.uuid+\'/fee/\'+this.record_id+\'/reset\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.getRecord();\n                        loader.hide();\n                    }).catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            }\n        },\n        filters: {\n          moment(date) {\n            return helper.formatDate(date);\n          },\n          momentDateTime(date) {\n            return helper.formatDateTime(date);\n          }\n        },\n        computed: {\n            authToken(){\n                return helper.getAuthToken();\n            },\n            resetFeeOption(){\n                if (! this.student_record.id)\n                    return false;\n\n                return this.student_record.student_fee_records.every(student_fee_record => {\n                    return student_fee_record.status == \'unpaid\';\n                });\n            },\n            finalTotal() {\n                let total = 0;\n                this.student_record.fee_allocation.fee_allocation_groups.forEach(fee_allocation_group => {\n                    total += this.getInstallmentGrandTotalAmount(fee_allocation_group);\n                });\n                return helper.formatCurrency(total);\n            },\n            finalOther() {\n                let total = 0;\n                this.student_record.fee_allocation.fee_allocation_groups.forEach(fee_allocation_group => {\n                    total += this.getInstallmentGrandOtherAmount(fee_allocation_group);\n                });\n                return helper.formatCurrency(total);\n            },\n            finalPaid() {\n                let total = 0;\n                this.student_record.fee_allocation.fee_allocation_groups.forEach(fee_allocation_group => {\n                    total += this.getInstallmentPaidGrandTotalAmount(fee_allocation_group);\n                });\n                return helper.formatCurrency(total);\n            },\n            finalBalance() {\n                let total = 0;\n                this.student_record.fee_allocation.fee_allocation_groups.forEach(fee_allocation_group => {\n                    total += this.getInstallmentBalanceGrandTotalAmount(fee_allocation_group);\n                });\n                return helper.formatCurrency(total);\n            }\n        },\n        watch: {\n            \'$route.params.uuid\': function (uuid) {\n                this.uuid = uuid;\n                this.record_id = this.$route.params.record_id;\n                this.getRecord()\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const o=i},179:(e,t,n)=>{"use strict";n.d(t,{Z:()=>o});var a=n(94015),s=n.n(a),r=n(23645),i=n.n(r)()(s());i.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/student/fee/payment-parent.vue"],names:[],mappings:"AA8cA,8BACA,YACA",sourcesContent:['<template>\n    <transition name="modal">\n        <div class="modal-mask">\n            <div class="modal-wrapper">\n                <div class="modal-container modal-lg">\n                    <div class="modal-header">\n                        <slot name="header">\n                            {{trans(\'finance.fee_payment\')}}\n                            <span class="float-right pointer" @click="$emit(\'closeFeePaymentForm\')">x</span>\n                        </slot>\n                    </div>\n                    <div class="modal-body">\n                        <slot name="body">\n                            <h4>{{feePayment.fee_group_name}} <span class="pull-right">{{feePayment.date | moment}}</span></h4>\n                            <div style="max-height:600px;">\n                                <form @submit.prevent="submit" @keydown="feePaymentForm.errors.clear($event.target.name)">\n                                    <div class="table-responsive p-2">\n                                        <table class="table table-bordered">\n                                            <thead>\n                                                <tr>\n                                                    <th>{{trans(\'finance.fee_installment\')}}</th>\n                                                    <th class="text-right">{{trans(\'finance.installment_total\')}}</th>\n                                                    <th class="text-right">{{trans(\'finance.late_fee\')}}</th>\n                                                    <th class="text-right">{{trans(\'general.total\')}}</th>\n                                                </tr>\n                                            </thead>\n                                            <tbody>\n                                                <tr v-for="installment in feePaymentForm.installments">\n                                                    <td v-text="installment.title"></td>\n                                                    <td class="text-right" v-text="installment.installment_balance"></td>\n                                                    <td class="text-right">\n                                                        {{installment.late_fee_balance}}\n                                                    </td>\n                                                    <td class="text-right" v-text="getInstallmentTotal(installment)"></td>\n                                                </tr>\n                                            </tbody>\n                                            <tfoot>\n                                                <tr>\n                                                    <th>{{trans(\'general.total\')}}</th>\n                                                    <th colspan="2"></th>\n                                                    <th class="text-right">{{formatCurrency(getGrandTotal)}}</th>\n                                                </tr>\n                                            </tfoot>\n                                        </table>\n                                    </div>\n                                    <div>\n                                        <h4 class="card-title">{{trans(\'finance.choose_payment_gateway\')}}</h4>\n                                        <div class="radio radio-success" v-if="getConfig(\'razorpay\') && razorpay_loaded">\n                                            <input type="radio" name="payment_gateway" id="razorpay" value="razorpay" @change="setPaymentGateway(\'razorpay\')">\n                                            <label for="razorpay"> \n                                                Razorpay \n                                            </label>\n                                        </div>\n                                        <div class="radio radio-success" v-if="getConfig(\'billdesk\')">\n                                            <input type="radio" name="payment_gateway" id="billdesk" value="billdesk" @change="setPaymentGateway(\'billdesk\')">\n                                            <label for="billdesk"> Billdesk </label>\n                                        </div>\n                                        <div class="radio radio-success" v-if="getConfig(\'stripe\')">\n                                            <input type="radio" name="payment_gateway" id="stripe" value="stripe" @change="setPaymentGateway(\'stripe\')">\n                                            <label for="stripe"> Stripe </label>\n                                        </div>\n                                        <div class="radio radio-success" v-if="getConfig(\'paystack\')">\n                                            <input type="radio" name="payment_gateway" id="paystack" value="paystack" @change="setPaymentGateway(\'paystack\')">\n                                            <label for="paystack"> Paystack </label>\n                                        </div>\n                                        <div class="radio radio-success" v-if="getConfig(\'paypal\')">\n                                            <input type="radio" name="payment_gateway" id="paypal" value="paypal" @change="setPaymentGateway(\'paypal\')">\n                                            <label for="paypal"> Paypal </label>\n                                        </div>\n\n                                        <p>{{handlingFeeAmount}}</p>\n                                        <p>{{totalAmount}}</p>\n\n                                        <template v-if="payment_gateway == \'billdesk\'">\n                                            <button type="button" class="btn btn-info" @click="callBillDesk">{{trans(\'general.proceed\')}}</button>\n                                        </template>\n\n                                        <template v-if="payment_gateway == \'razorpay\'">\n                                            <button type="button" class="btn btn-info" @click="callRazorpay">{{trans(\'general.proceed\')}}</button>\n                                        </template>\n\n                                        <template v-if="payment_gateway == \'paystack\'">\n                                            <button type="button" class="btn btn-info" @click="payWithPaystack">{{trans(\'general.proceed\')}}</button>\n                                        </template>\n\n                                        <template v-if="payment_gateway == \'paypal\'">\n                                            <button type="button" class="btn btn-info" @click="callPaypal" v-if="paypalButton">{{trans(\'general.proceed\')}}</button>\n                                        </template>\n\n                                        <template v-if="payment_gateway == \'stripe\'">\n                                            <div class="row m-t-40">\n                                                <div class="col-12">\n                                                    <div class="form-group">\n                                                        <input class="form-control" type="number" maxlength="16" value="" v-model="stripe.card_number" :placeholder="trans(\'finance.card_number\')">\n                                                    </div>\n                                                </div>\n                                                <div class="col-3">\n                                                    <div class="form-group">\n                                                        <input class="form-control" type="number" value="" v-model="stripe.month" :placeholder="trans(\'finance.card_expiry_month\')">\n                                                    </div>\n                                                </div>\n                                                <div class="col-4">\n                                                    <div class="form-group">\n                                                        <input class="form-control" type="number" value="" v-model="stripe.year" :placeholder="trans(\'finance.card_expiry_year\')">\n                                                    </div>\n                                                </div>\n                                                <div class="col-1">\n                                                </div>\n                                                <div class="col-4">\n                                                    <div class="form-group">\n                                                        <input class="form-control" type="number" value="" v-model="stripe.cvc" :placeholder="trans(\'finance.card_cvc\')">\n                                                    </div>\n                                                </div>\n                                            </div>\n                                            <button type="button" @click="stripeCheckout" class="btn btn-info waves-effect waves-light pull-right" v-if="stripeButton"><span>{{trans(\'general.proceed\')}}</span></button>\n                                        </template>\n                                    </div>\n                                </form>\n                            </div>\n                        </slot>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </transition>\n</template>\n\n<script>\n    export default {\n        components: {},\n        props: [\'id\',\'uuid\',\'feePayment\'],\n        data() {\n            return {\n                default_currency: helper.getConfig(\'default_currency\'),\n                payment_gateway: \'\',\n                razorpay_loaded: 0,\n                stripe_loaded: 0,\n                total: 0,\n                stripe: {\n                    card_number: \'\',\n                    month: \'\',\n                    year: \'\',\n                    cvc: \'\'\n                },\n                stripeButton: true,\n                paypalButton: true,\n                feePaymentForm: new Form({\n                    amount: 0,\n                    installment_id: \'\',\n                    date: \'\',\n                    installments: []\n                })\n            }\n        },\n        mounted(){\n            this.loadFeePayment(this.feePayment);\n\n            if ((this.default_currency.name == \'INR\' || !helper.getConfig(\'mode\')) && this.getConfig(\'razorpay\')) {\n                this.injectRazorpay();\n            }\n        },\n        methods: {\n            getConfig(config){\n                return helper.getConfig(config);\n            },\n            loadFeePayment(feePayment){\n                this.feePaymentForm.amount = feePayment.amount;\n                this.feePaymentForm.installment_id = feePayment.fee_payment_installment_id;\n                this.feePaymentForm.date = feePayment.date;\n                this.feePaymentForm.installments = [];\n                this.total = 0;\n                feePayment.installments.forEach(installment => {\n                    this.feePaymentForm.installments.push({\n                        fee_installment_id: installment.fee_installment_id,\n                        title: installment.title,\n                        installment_balance: installment.installment_balance,\n                        late_fee_balance: installment.late_fee_balance\n                    });\n                })\n            },\n            getInstallmentTotal(installment){\n                return (installment.installment_balance + parseInt(installment.late_fee_balance));\n            },\n            formatCurrency(amount){\n                return helper.formatCurrency(amount);\n            },\n            setPaymentGateway(gateway){\n                this.payment_gateway = gateway;\n            },\n            stripeCheckout(){\n                let loader = this.$loading.show();\n                this.stripeButton = false;\n                Stripe.setPublishableKey(this.getConfig(\'stripe_publishable_key\'));\n                Stripe.card.createToken({\n                    number: this.stripe.card_number,\n                    cvc: this.stripe.cvc,\n                    exp_month: this.stripe.month,\n                    exp_year: this.stripe.year\n                }, this.stripeResponseHandler);\n                loader.hide();\n            },\n            stripeResponseHandler(status, response) {\n                if(status == 200){\n                    let loader = this.$loading.show();\n                    axios.post(\'/api/student/\'+this.uuid+\'/payment/\'+this.id+\'/stripe\',{\n                            stripeToken: response.id,\n                            amount: this.total * 100,\n                            fee: this.feePaymentForm.amount,\n                            handling_fee: this.handlingFee,\n                            fee_installment_id: this.feePaymentForm.installment_id,\n                            installments: this.feePaymentForm.installments\n                        })\n                        .then(response => {\n                            loader.hide();\n                            toastr.success(response.message);\n                            this.$emit(\'completed\');\n                            this.stripeButton = true;\n                        })\n                        .catch(error => {\n                            loader.hide();\n                            helper.showErrorMsg(error);\n                            this.stripeButton = true;\n                        })\n                } else {\n                    toastr.error(response.error.message);\n                    this.stripeButton = true;\n                }\n            },\n            injectRazorpay() {\n                let vm = this;\n                var result = $.Deferred(),\n                script = document.createElement("script");\n\n                script.async = "async";\n                script.type = "text/javascript";\n                script.src = \'https://checkout.razorpay.com/v1/checkout.js\';\n                script.onload = script.onreadystatechange = function(_, isAbort) {\n                    if (!script.readyState || /loaded|complete/.test(script.readyState)) {\n                        if (isAbort)\n                            result.reject();\n                        else \n                            result.resolve();\n                    }\n                    vm.razorpay_loaded = 1;\n                };\n\n                script.onerror = function() {\n                    result.reject();\n                };\n\n                document.head.appendChild(script);\n\n                return result.promise();\n            },\n            callRazorpay(){\n                let vm = this;\n                var options = {\n                    key: this.getConfig(\'razorpay_key\'),\n                    protocol: \'https\',\n                    hostname: \'api.razorpay.com\',\n                    amount: this.total * 100,\n                    name: helper.getConfig(\'institute_name\'),\n                    description: i18n.finance.fee_payment,\n                    image: this.getLogo,\n                    prefill: {\n                        email: "",\n                        contact: "",\n                        name: ""\n                    },\n                    notes:{\n                        student_record_id: this.id,\n                        fee: this.feePaymentForm.amount,\n                        handling_fee: this.handlingFee\n                    },\n                    handler: function (transaction, response){\n                        vm.completeRazorpay(transaction.razorpay_payment_id)\n                    }\n                };\n\n                window.rzpay = new Razorpay(options);\n                rzpay.open();\n            },\n            completeRazorpay(transaction_id){\n                let loader = this.$loading.show();\n                axios.post(\'/api/student/\'+this.uuid+\'/payment/\'+this.id+\'/rzp\',{\n                        transaction_id: transaction_id,\n                        installments: this.feePaymentForm.installments,\n                        fee_installment_id: this.feePaymentForm.installment_id\n                    })\n                    .then(response => {\n                        loader.hide();\n                        toastr.success(response.message);\n                        this.$emit(\'completed\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            callBillDesk() {\n                let loader = this.$loading.show();\n\n                axios.post(\'student/\'+this.uuid+\'/payment/\'+this.id+\'/billdesk\', {\n                    amount: this.feePaymentForm.amount,\n                    installment_id: this.feePaymentForm.installment_id,\n                    installments: this.feePaymentForm.installments\n                })\n                .then(response => {\n                    loader.hide();\n\n                    bdPayment.initialize({\n                        msg : response.msg,\n                        callbackUrl: response.url,\n                        options : {\n                            enableChildWindowPosting : true,\n                            enablePaymentRetry : true,\n                            retry_attempt_count: 3\n                        }\n                    }); \n                })\n                .catch(error => {\n                    loader.hide();\n                    helper.showErrorMsg(error);\n                })\n            },\n            callPaypal(){\n                this.paypalButton = false;\n                let loader = this.$loading.show();\n                axios.post(\'/api/student/\'+this.uuid+\'/payment/\'+this.id+\'/paypal\',{\n                        amount: this.total,\n                        fee: this.feePaymentForm.amount,\n                        handling_fee: this.handlingFee,\n                        fee_installment_id: this.feePaymentForm.installment_id,\n                        installments: this.feePaymentForm.installments\n                    })\n                    .then(response => {\n                        loader.hide();\n                        window.location = response;\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        this.paypalButton = true\n                        helper.showErrorMsg(error);\n                    })\n                ;\n            },\n            payWithPaystack(){\n                if (helper.getConfig(\'default_currency\').name != \'NGN\' && helper.getConfig(\'default_currency\').name != \'GHS\') {\n                    toastr.error(i18n.configuration.currency_not_supported);\n                    return;\n                }\n\n                let vm = this;\n                var handler = PaystackPop.setup({\n                    key: this.getConfig(\'paystack_public_key\'),\n                    email: helper.getAuthUser(\'email\'),\n                    amount: this.total * 100,\n                    currency: helper.getConfig(\'default_currency\').name,\n                    ref: \'\'+Math.floor((Math.random() * 1000000000) + 1),\n                    metadata: {\n                        custom_fields: [\n                            {\n                                display_name: \'Student ID\',\n                                variable_name: "student_record_id",\n                                value: this.id\n                            },\n                            {\n                                display_name: \'Amount\',\n                                variable_name: "fee",\n                                value: this.feePaymentForm.amount\n                            },\n                            {\n                                display_name: \'Handling Fee\',\n                                variable_name: "handling_fee",\n                                value: this.handlingFee\n                            }\n                        ]\n                    },\n                    callback: function(response){\n                        vm.completePaystack(response.reference)\n                    },\n                    onClose: function(){\n                        \n                    }\n                });\n                handler.openIframe();\n            },\n            completePaystack(transaction_id){\n                let loader = this.$loading.show();\n                axios.post(\'/api/student/\'+this.uuid+\'/payment/\'+this.id+\'/paystack\',{\n                        transaction_id: transaction_id,\n                        installments: this.feePaymentForm.installments,\n                        fee_installment_id: this.feePaymentForm.installment_id\n                    })\n                    .then(response => {\n                        loader.hide();\n                        toastr.success(response.message);\n                        this.$emit(\'completed\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            }\n        },\n        computed: {\n            getLogo(){\n                return helper.getLogo();\n            },\n            handlingFee(){\n                let handling_fee = 0;\n\n                if (!this.payment_gateway)\n                    return handling_fee;\n\n                if (! helper.getConfig(this.payment_gateway+\'_charge_handling_fee\'))\n                    return handling_fee;\n\n                if(helper.getConfig(this.payment_gateway+\'_fixed_handling_fee\'))\n                    handling_fee = helper.getConfig(this.payment_gateway+\'_handling_fee\');\n                else {\n                    let percentage = helper.getConfig(this.payment_gateway+\'_handling_fee\');\n                    handling_fee = this.feePaymentForm.amount * (percentage / 100);\n                }\n\n                return helper.formatNumber(handling_fee);\n            },\n            handlingFeeAmount(){\n                if (! helper.getConfig(this.payment_gateway+\'_charge_handling_fee\'))\n                    return;\n\n                return i18n.finance.handling_fee+\' \'+helper.formatCurrency(this.handlingFee);\n            },\n            totalAmount(){\n                return i18n.finance.payable_amount+\' \'+helper.formatCurrency(this.total);\n            },\n            getGrandTotal(){\n                let total = 0;\n                total = total;\n\n                if(!Array.isArray(this.feePaymentForm.installments))\n                    return total;\n\n                this.feePaymentForm.installments.forEach(installment => {\n                    total += (installment.installment_balance + parseInt(installment.late_fee_balance));\n                })  \n                total = (total) ? (total + this.handlingFee) : total;\n                this.total = total; \n                return total;\n            }\n        },\n        filters: {\n          moment(date) {\n            return helper.formatDate(date);\n          },\n          momentDateTime(date) {\n            return helper.formatDateTime(date);\n          }\n        }\n    }\n<\/script>\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const o=i},7255:(e,t,n)=>{"use strict";n.r(t),n.d(t,{default:()=>v});var a=n(7167);const s={components:{},props:["id","uuid","feePayment"],data:function(){return{feePaymentForm:new Form({amount:0,additional_fee_discount:0,additional_fee_charge:0,additional_fee_charge_label:"",additional_fee_discount_label:"",installments:[],installment_id:"",account_id:"",payment_method_id:"",date:"",instrument_date:"",instrument_number:"",instrument_clearing_date:"",instrument_bank_detail:"",reference_number:"",remarks:""}),total:0,selected_account:null,accounts:[],payment_methods:[],selected_payment_method:null,payment_method_details:[],payment_method_detail:{}}},mounted:function(){this.loadFeePayment(this.feePayment),this.getPreRequisite()},methods:{hasPermission:function(e){return helper.hasPermission(e)},loadFeePayment:function(e){var t=this;this.feePaymentForm.date=e.date,this.feePaymentForm.installment_id=e.fee_payment_installment_id,this.feePaymentForm.amount=e.amount,this.total=0,this.feePaymentForm.installments=[],e.installments.forEach((function(e){t.feePaymentForm.installments.push({fee_installment_id:e.fee_installment_id,title:e.title,installment_balance:e.installment_balance,late_fee_balance:e.late_fee_balance})}))},getInstallmentTotal:function(e){return e.installment_balance+parseInt(e.late_fee_balance)},getPreRequisite:function(){var e=this,t=this.$loading.show();axios.get("/api/student/fee/pre-requisite").then((function(n){e.accounts=n.accounts,e.payment_methods=n.payment_methods,e.payment_method_details=n.payment_method_details,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},getPaymentMethodDetail:function(e){return helper.getPaymentMethodDetail(this.payment_method_detail,e)},onAccountSelect:function(e){this.feePaymentForm.account_id=e.id},onPaymentMethodSelect:function(e){this.feePaymentForm.payment_method_id=e.id,this.payment_method_detail=this.payment_method_details.find((function(t){return t.id==e.id}))},onPaymentMethodRemove:function(e){this.feePaymentForm.payment_method_id="",this.payment_method_detail=null},formatCurrency:function(e){return helper.formatCurrency(e)},submit:function(){var e=this,t=this.$loading.show();this.feePaymentForm.post("/api/student/"+this.uuid+"/payment/"+this.id).then((function(n){toastr.success(n.message),e.$emit("completed"),e.selected_account=null,e.selected_payment_method=null,e.feePaymentForm.installments=[],t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))}},computed:{getGrandTotal:function(){var e=0;return Array.isArray(this.feePaymentForm.installments)?(this.feePaymentForm.installments.forEach((function(t){e+=t.installment_balance+parseInt(t.late_fee_balance)})),e+ +this.feePaymentForm.additional_fee_charge-+this.feePaymentForm.additional_fee_discount):e}},watch:{feePayment:function(e){this.loadFeePayment(e)},getGrandTotal:function(e){this.feePaymentForm.amount=e}},filters:{moment:function(e){return helper.formatDate(e)},momentDateTime:function(e){return helper.formatDateTime(e)}}};var r=n(51900);const i=(0,r.Z)(s,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[e._t("header",(function(){return[e._v("\n                        "+e._s(e.trans("finance.fee_payment"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(t){return e.$emit("closeFeePaymentForm")}}},[e._v("x")])]}))],2),e._v(" "),n("div",{staticClass:"modal-body"},[e._t("body",(function(){return[n("h4",[e._v(e._s(e.feePayment.fee_group_name)+" "),n("span",{staticClass:"pull-right"},[e._v(e._s(e._f("moment")(e.feePayment.date)))])]),e._v(" "),n("div",{staticStyle:{"max-height":"600px"}},[n("form",{on:{submit:function(t){return t.preventDefault(),e.submit.apply(null,arguments)},keydown:function(t){return e.feePaymentForm.errors.clear(t.target.name)}}},[n("div",{staticClass:"table-responsive p-2"},[n("table",{staticClass:"table table-bordered"},[n("thead",[n("tr",[n("th",[e._v(e._s(e.trans("finance.fee_installment")))]),e._v(" "),n("th",{staticClass:"text-right"},[e._v(e._s(e.trans("finance.installment_total")))]),e._v(" "),n("th",{staticClass:"text-right"},[e._v(e._s(e.trans("finance.late_fee")))]),e._v(" "),n("th",{staticClass:"text-right"},[e._v(e._s(e.trans("general.total")))])])]),e._v(" "),n("tbody",e._l(e.feePaymentForm.installments,(function(t){return n("tr",[n("td",{domProps:{textContent:e._s(t.title)}}),e._v(" "),n("td",{staticClass:"text-right",domProps:{textContent:e._s(t.installment_balance)}}),e._v(" "),n("td",{staticClass:"text-right"},[e.hasPermission("customize-late-fee")?[n("input",{directives:[{name:"model",rawName:"v-model",value:t.late_fee_balance,expression:"installment.late_fee_balance"}],staticClass:"invoice-input",attrs:{type:"text"},domProps:{value:t.late_fee_balance},on:{input:function(n){n.target.composing||e.$set(t,"late_fee_balance",n.target.value)}}})]:[e._v("\n                                                        "+e._s(t.late_fee_balance)+"\n                                                    ")]],2),e._v(" "),n("td",{staticClass:"text-right",domProps:{textContent:e._s(e.getInstallmentTotal(t))}})])})),0),e._v(" "),n("tfoot",[n("tr",[n("td",[e._v(e._s(e.trans("student.additional_fee_charge")))]),e._v(" "),n("td",{attrs:{colspan:"2"}},[n("div",{staticClass:"form-group"},[n("input",{directives:[{name:"model",rawName:"v-model",value:e.feePaymentForm.additional_fee_charge_label,expression:"feePaymentForm.additional_fee_charge_label"}],staticClass:"invoice-input-left",attrs:{type:"text",name:"additional_fee_charge_label",placeholder:e.trans("student.fee_label")},domProps:{value:e.feePaymentForm.additional_fee_charge_label},on:{input:function(t){t.target.composing||e.$set(e.feePaymentForm,"additional_fee_charge_label",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"additional_fee_charge_label"}})],1)]),e._v(" "),n("td",{staticClass:"text-right"},[n("div",{staticClass:"form-group"},[n("input",{directives:[{name:"model",rawName:"v-model",value:e.feePaymentForm.additional_fee_charge,expression:"feePaymentForm.additional_fee_charge"}],staticClass:"invoice-input",attrs:{type:"text",name:"additional_fee_charge",placeholder:e.trans("student.additional_fee_charge")},domProps:{value:e.feePaymentForm.additional_fee_charge},on:{input:function(t){t.target.composing||e.$set(e.feePaymentForm,"additional_fee_charge",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"additional_fee_charge"}})],1)])]),e._v(" "),n("tr",[n("td",[e._v(e._s(e.trans("student.additional_fee_discount")))]),e._v(" "),n("td",{attrs:{colspan:"2"}},[n("div",{staticClass:"form-group"},[n("input",{directives:[{name:"model",rawName:"v-model",value:e.feePaymentForm.additional_fee_discount_label,expression:"feePaymentForm.additional_fee_discount_label"}],staticClass:"invoice-input-left",attrs:{type:"text",name:"additional_fee_discount_label",placeholder:e.trans("student.fee_label")},domProps:{value:e.feePaymentForm.additional_fee_discount_label},on:{input:function(t){t.target.composing||e.$set(e.feePaymentForm,"additional_fee_discount_label",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"additional_fee_discount_label"}})],1)]),e._v(" "),n("td",{staticClass:"text-right"},[n("div",{staticClass:"form-group"},[n("input",{directives:[{name:"model",rawName:"v-model",value:e.feePaymentForm.additional_fee_discount,expression:"feePaymentForm.additional_fee_discount"}],staticClass:"invoice-input",attrs:{type:"text",name:"additional_fee_discount",placeholder:e.trans("student.additional_fee_discount")},domProps:{value:e.feePaymentForm.additional_fee_discount},on:{input:function(t){t.target.composing||e.$set(e.feePaymentForm,"additional_fee_discount",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"additional_fee_discount"}})],1)])]),e._v(" "),n("tr",[n("th",[e._v(e._s(e.trans("general.total")))]),e._v(" "),n("th",{attrs:{colspan:"2"}}),e._v(" "),n("th",{staticClass:"text-right"},[e._v(e._s(e.formatCurrency(e.getGrandTotal)))])]),e._v(" "),e.hasPermission("make-partial-fee-payment")?n("tr",[n("th",[e._v(e._s(e.trans("finance.amount")))]),e._v(" "),n("th",{attrs:{colspan:"2"}}),e._v(" "),n("th",{staticClass:"text-right"},[n("input",{directives:[{name:"model",rawName:"v-model",value:e.feePaymentForm.amount,expression:"feePaymentForm.amount"}],staticClass:"invoice-input",attrs:{type:"text",name:"amount",placeholder:e.trans("finance.amount")},domProps:{value:e.feePaymentForm.amount},on:{input:function(t){t.target.composing||e.$set(e.feePaymentForm,"amount",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"amount"}})],1)]):e._e()])])]),e._v(" "),n("div",{staticClass:"row"},[e.feePaymentForm.amount?[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.account")))]),e._v(" "),n("v-select",{attrs:{label:"name",name:"account_id",id:"account_id",options:e.accounts,placeholder:e.trans("account.select_account")},on:{select:e.onAccountSelect,close:function(t){return e.feePaymentForm.errors.clear("account_id")},remove:function(t){e.feePaymentForm.account_id=""}},model:{value:e.selected_account,callback:function(t){e.selected_account=t},expression:"selected_account"}},[e.accounts.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                                        "+e._s(e.trans("general.no_option_found"))+"\n                                                    ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"account_id"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.payment_method")))]),e._v(" "),n("v-select",{attrs:{label:"name",name:"payment_method_id",id:"payment_method_id",options:e.payment_methods,placeholder:e.trans("payment_method.select_payment_method")},on:{select:e.onPaymentMethodSelect,close:function(t){return e.feePaymentForm.errors.clear("payment_method_id")},remove:e.onPaymentMethodRemove},model:{value:e.selected_payment_method,callback:function(t){e.selected_payment_method=t},expression:"selected_payment_method"}},[e.payment_methods.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                                        "+e._s(e.trans("general.no_option_found"))+"\n                                                    ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"payment_method_id"}})],1)])]:e._e(),e._v(" "),e.getPaymentMethodDetail("instrument_number")?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.instrument_number")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.feePaymentForm.instrument_number,expression:"feePaymentForm.instrument_number"}],staticClass:"form-control",attrs:{type:"text",name:"instrument_number",placeholder:e.trans("finance.instrument_number")},domProps:{value:e.feePaymentForm.instrument_number},on:{input:function(t){t.target.composing||e.$set(e.feePaymentForm,"instrument_number",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"instrument_number"}})],1)]):e._e(),e._v(" "),e.getPaymentMethodDetail("instrument_date")?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.instrument_date")))]),e._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("finance.instrument_date")},on:{selected:function(t){return e.feePaymentForm.errors.clear("instrument_date")}},model:{value:e.feePaymentForm.instrument_date,callback:function(t){e.$set(e.feePaymentForm,"instrument_date",t)},expression:"feePaymentForm.instrument_date"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"instrument_date"}})],1)]):e._e(),e._v(" "),e.getPaymentMethodDetail("instrument_bank_detail")?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.instrument_bank_detail")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.feePaymentForm.instrument_bank_detail,expression:"feePaymentForm.instrument_bank_detail"}],staticClass:"form-control",attrs:{type:"text",name:"instrument_bank_detail",placeholder:e.trans("finance.instrument_bank_detail")},domProps:{value:e.feePaymentForm.instrument_bank_detail},on:{input:function(t){t.target.composing||e.$set(e.feePaymentForm,"instrument_bank_detail",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"instrument_bank_detail"}})],1)]):e._e(),e._v(" "),e.getPaymentMethodDetail("instrument_clearing_date")?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.instrument_clearing_date")))]),e._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("finance.instrument_clearing_date")},on:{selected:function(t){return e.feePaymentForm.errors.clear("instrument_clearing_date")}},model:{value:e.feePaymentForm.instrument_clearing_date,callback:function(t){e.$set(e.feePaymentForm,"instrument_clearing_date",t)},expression:"feePaymentForm.instrument_clearing_date"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"instrument_clearing_date"}})],1)]):e._e(),e._v(" "),e.getPaymentMethodDetail("reference_number")?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.reference_number")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.feePaymentForm.reference_number,expression:"feePaymentForm.reference_number"}],staticClass:"form-control",attrs:{type:"text",name:"reference_number",placeholder:e.trans("finance.reference_number")},domProps:{value:e.feePaymentForm.reference_number},on:{input:function(t){t.target.composing||e.$set(e.feePaymentForm,"reference_number",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"reference_number"}})],1)]):e._e(),e._v(" "),n("div",{staticClass:"col-12 col-sm-12"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.fee_payment_remarks")))]),e._v(" "),n("autosize-textarea",{attrs:{rows:"2",name:"remarks",placeholder:e.trans("finance.fee_payment_remarks")},model:{value:e.feePaymentForm.remarks,callback:function(t){e.$set(e.feePaymentForm,"remarks",t)},expression:"feePaymentForm.remarks"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feePaymentForm,"prop-name":"remarks"}})],1)])],2),e._v(" "),n("button",{staticClass:"btn btn-info waves-effect waves-light pull-right",attrs:{type:"submit"}},[e._v(e._s(e.trans("general.save")))])])]),e._v(" "),n("div",{staticClass:"clearfix"})]}))],2)])])])])}),[],!1,null,null,null).exports;const o={components:{},props:["id","uuid","feePayment"],data:function(){return{default_currency:helper.getConfig("default_currency"),payment_gateway:"",razorpay_loaded:0,stripe_loaded:0,total:0,stripe:{card_number:"",month:"",year:"",cvc:""},stripeButton:!0,paypalButton:!0,feePaymentForm:new Form({amount:0,installment_id:"",date:"",installments:[]})}},mounted:function(){this.loadFeePayment(this.feePayment),"INR"!=this.default_currency.name&&helper.getConfig("mode")||!this.getConfig("razorpay")||this.injectRazorpay()},methods:{getConfig:function(e){return helper.getConfig(e)},loadFeePayment:function(e){var t=this;this.feePaymentForm.amount=e.amount,this.feePaymentForm.installment_id=e.fee_payment_installment_id,this.feePaymentForm.date=e.date,this.feePaymentForm.installments=[],this.total=0,e.installments.forEach((function(e){t.feePaymentForm.installments.push({fee_installment_id:e.fee_installment_id,title:e.title,installment_balance:e.installment_balance,late_fee_balance:e.late_fee_balance})}))},getInstallmentTotal:function(e){return e.installment_balance+parseInt(e.late_fee_balance)},formatCurrency:function(e){return helper.formatCurrency(e)},setPaymentGateway:function(e){this.payment_gateway=e},stripeCheckout:function(){var e=this.$loading.show();this.stripeButton=!1,Stripe.setPublishableKey(this.getConfig("stripe_publishable_key")),Stripe.card.createToken({number:this.stripe.card_number,cvc:this.stripe.cvc,exp_month:this.stripe.month,exp_year:this.stripe.year},this.stripeResponseHandler),e.hide()},stripeResponseHandler:function(e,t){var n=this;if(200==e){var a=this.$loading.show();axios.post("/api/student/"+this.uuid+"/payment/"+this.id+"/stripe",{stripeToken:t.id,amount:100*this.total,fee:this.feePaymentForm.amount,handling_fee:this.handlingFee,fee_installment_id:this.feePaymentForm.installment_id,installments:this.feePaymentForm.installments}).then((function(e){a.hide(),toastr.success(e.message),n.$emit("completed"),n.stripeButton=!0})).catch((function(e){a.hide(),helper.showErrorMsg(e),n.stripeButton=!0}))}else toastr.error(t.error.message),this.stripeButton=!0},injectRazorpay:function(){var e=this,t=$.Deferred(),n=document.createElement("script");return n.async="async",n.type="text/javascript",n.src="https://checkout.razorpay.com/v1/checkout.js",n.onload=n.onreadystatechange=function(a,s){n.readyState&&!/loaded|complete/.test(n.readyState)||(s?t.reject():t.resolve()),e.razorpay_loaded=1},n.onerror=function(){t.reject()},document.head.appendChild(n),t.promise()},callRazorpay:function(){var e=this,t={key:this.getConfig("razorpay_key"),protocol:"https",hostname:"api.razorpay.com",amount:100*this.total,name:helper.getConfig("institute_name"),description:i18n.finance.fee_payment,image:this.getLogo,prefill:{email:"",contact:"",name:""},notes:{student_record_id:this.id,fee:this.feePaymentForm.amount,handling_fee:this.handlingFee},handler:function(t,n){e.completeRazorpay(t.razorpay_payment_id)}};window.rzpay=new Razorpay(t),rzpay.open()},completeRazorpay:function(e){var t=this,n=this.$loading.show();axios.post("/api/student/"+this.uuid+"/payment/"+this.id+"/rzp",{transaction_id:e,installments:this.feePaymentForm.installments,fee_installment_id:this.feePaymentForm.installment_id}).then((function(e){n.hide(),toastr.success(e.message),t.$emit("completed")})).catch((function(e){n.hide(),helper.showErrorMsg(e)}))},callBillDesk:function(){var e=this.$loading.show();axios.post("student/"+this.uuid+"/payment/"+this.id+"/billdesk",{amount:this.feePaymentForm.amount,installment_id:this.feePaymentForm.installment_id,installments:this.feePaymentForm.installments}).then((function(t){e.hide(),bdPayment.initialize({msg:t.msg,callbackUrl:t.url,options:{enableChildWindowPosting:!0,enablePaymentRetry:!0,retry_attempt_count:3}})})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},callPaypal:function(){var e=this;this.paypalButton=!1;var t=this.$loading.show();axios.post("/api/student/"+this.uuid+"/payment/"+this.id+"/paypal",{amount:this.total,fee:this.feePaymentForm.amount,handling_fee:this.handlingFee,fee_installment_id:this.feePaymentForm.installment_id,installments:this.feePaymentForm.installments}).then((function(e){t.hide(),window.location=e})).catch((function(n){t.hide(),e.paypalButton=!0,helper.showErrorMsg(n)}))},payWithPaystack:function(){if("NGN"==helper.getConfig("default_currency").name||"GHS"==helper.getConfig("default_currency").name){var e=this;PaystackPop.setup({key:this.getConfig("paystack_public_key"),email:helper.getAuthUser("email"),amount:100*this.total,currency:helper.getConfig("default_currency").name,ref:""+Math.floor(1e9*Math.random()+1),metadata:{custom_fields:[{display_name:"Student ID",variable_name:"student_record_id",value:this.id},{display_name:"Amount",variable_name:"fee",value:this.feePaymentForm.amount},{display_name:"Handling Fee",variable_name:"handling_fee",value:this.handlingFee}]},callback:function(t){e.completePaystack(t.reference)},onClose:function(){}}).openIframe()}else toastr.error(i18n.configuration.currency_not_supported)},completePaystack:function(e){var t=this,n=this.$loading.show();axios.post("/api/student/"+this.uuid+"/payment/"+this.id+"/paystack",{transaction_id:e,installments:this.feePaymentForm.installments,fee_installment_id:this.feePaymentForm.installment_id}).then((function(e){n.hide(),toastr.success(e.message),t.$emit("completed")})).catch((function(e){n.hide(),helper.showErrorMsg(e)}))}},computed:{getLogo:function(){return helper.getLogo()},handlingFee:function(){var e=0;if(!this.payment_gateway)return e;if(!helper.getConfig(this.payment_gateway+"_charge_handling_fee"))return e;if(helper.getConfig(this.payment_gateway+"_fixed_handling_fee"))e=helper.getConfig(this.payment_gateway+"_handling_fee");else{var t=helper.getConfig(this.payment_gateway+"_handling_fee");e=this.feePaymentForm.amount*(t/100)}return helper.formatNumber(e)},handlingFeeAmount:function(){if(helper.getConfig(this.payment_gateway+"_charge_handling_fee"))return i18n.finance.handling_fee+" "+helper.formatCurrency(this.handlingFee)},totalAmount:function(){return i18n.finance.payable_amount+" "+helper.formatCurrency(this.total)},getGrandTotal:function(){var e=0;return e=e,Array.isArray(this.feePaymentForm.installments)?(this.feePaymentForm.installments.forEach((function(t){e+=t.installment_balance+parseInt(t.late_fee_balance)})),e=e?e+this.handlingFee:e,this.total=e,e):e}},filters:{moment:function(e){return helper.formatDate(e)},momentDateTime:function(e){return helper.formatDateTime(e)}}};var l=n(93379),d=n.n(l),_=n(179),c={insert:"head",singleton:!1};d()(_.Z,c);_.Z.locals;const m=(0,r.Z)(o,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[e._t("header",(function(){return[e._v("\n                        "+e._s(e.trans("finance.fee_payment"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(t){return e.$emit("closeFeePaymentForm")}}},[e._v("x")])]}))],2),e._v(" "),n("div",{staticClass:"modal-body"},[e._t("body",(function(){return[n("h4",[e._v(e._s(e.feePayment.fee_group_name)+" "),n("span",{staticClass:"pull-right"},[e._v(e._s(e._f("moment")(e.feePayment.date)))])]),e._v(" "),n("div",{staticStyle:{"max-height":"600px"}},[n("form",{on:{submit:function(t){return t.preventDefault(),e.submit.apply(null,arguments)},keydown:function(t){return e.feePaymentForm.errors.clear(t.target.name)}}},[n("div",{staticClass:"table-responsive p-2"},[n("table",{staticClass:"table table-bordered"},[n("thead",[n("tr",[n("th",[e._v(e._s(e.trans("finance.fee_installment")))]),e._v(" "),n("th",{staticClass:"text-right"},[e._v(e._s(e.trans("finance.installment_total")))]),e._v(" "),n("th",{staticClass:"text-right"},[e._v(e._s(e.trans("finance.late_fee")))]),e._v(" "),n("th",{staticClass:"text-right"},[e._v(e._s(e.trans("general.total")))])])]),e._v(" "),n("tbody",e._l(e.feePaymentForm.installments,(function(t){return n("tr",[n("td",{domProps:{textContent:e._s(t.title)}}),e._v(" "),n("td",{staticClass:"text-right",domProps:{textContent:e._s(t.installment_balance)}}),e._v(" "),n("td",{staticClass:"text-right"},[e._v("\n                                                    "+e._s(t.late_fee_balance)+"\n                                                ")]),e._v(" "),n("td",{staticClass:"text-right",domProps:{textContent:e._s(e.getInstallmentTotal(t))}})])})),0),e._v(" "),n("tfoot",[n("tr",[n("th",[e._v(e._s(e.trans("general.total")))]),e._v(" "),n("th",{attrs:{colspan:"2"}}),e._v(" "),n("th",{staticClass:"text-right"},[e._v(e._s(e.formatCurrency(e.getGrandTotal)))])])])])]),e._v(" "),n("div",[n("h4",{staticClass:"card-title"},[e._v(e._s(e.trans("finance.choose_payment_gateway")))]),e._v(" "),e.getConfig("razorpay")&&e.razorpay_loaded?n("div",{staticClass:"radio radio-success"},[n("input",{attrs:{type:"radio",name:"payment_gateway",id:"razorpay",value:"razorpay"},on:{change:function(t){return e.setPaymentGateway("razorpay")}}}),e._v(" "),n("label",{attrs:{for:"razorpay"}},[e._v(" \n                                            Razorpay \n                                        ")])]):e._e(),e._v(" "),e.getConfig("billdesk")?n("div",{staticClass:"radio radio-success"},[n("input",{attrs:{type:"radio",name:"payment_gateway",id:"billdesk",value:"billdesk"},on:{change:function(t){return e.setPaymentGateway("billdesk")}}}),e._v(" "),n("label",{attrs:{for:"billdesk"}},[e._v(" Billdesk ")])]):e._e(),e._v(" "),e.getConfig("stripe")?n("div",{staticClass:"radio radio-success"},[n("input",{attrs:{type:"radio",name:"payment_gateway",id:"stripe",value:"stripe"},on:{change:function(t){return e.setPaymentGateway("stripe")}}}),e._v(" "),n("label",{attrs:{for:"stripe"}},[e._v(" Stripe ")])]):e._e(),e._v(" "),e.getConfig("paystack")?n("div",{staticClass:"radio radio-success"},[n("input",{attrs:{type:"radio",name:"payment_gateway",id:"paystack",value:"paystack"},on:{change:function(t){return e.setPaymentGateway("paystack")}}}),e._v(" "),n("label",{attrs:{for:"paystack"}},[e._v(" Paystack ")])]):e._e(),e._v(" "),e.getConfig("paypal")?n("div",{staticClass:"radio radio-success"},[n("input",{attrs:{type:"radio",name:"payment_gateway",id:"paypal",value:"paypal"},on:{change:function(t){return e.setPaymentGateway("paypal")}}}),e._v(" "),n("label",{attrs:{for:"paypal"}},[e._v(" Paypal ")])]):e._e(),e._v(" "),n("p",[e._v(e._s(e.handlingFeeAmount))]),e._v(" "),n("p",[e._v(e._s(e.totalAmount))]),e._v(" "),"billdesk"==e.payment_gateway?[n("button",{staticClass:"btn btn-info",attrs:{type:"button"},on:{click:e.callBillDesk}},[e._v(e._s(e.trans("general.proceed")))])]:e._e(),e._v(" "),"razorpay"==e.payment_gateway?[n("button",{staticClass:"btn btn-info",attrs:{type:"button"},on:{click:e.callRazorpay}},[e._v(e._s(e.trans("general.proceed")))])]:e._e(),e._v(" "),"paystack"==e.payment_gateway?[n("button",{staticClass:"btn btn-info",attrs:{type:"button"},on:{click:e.payWithPaystack}},[e._v(e._s(e.trans("general.proceed")))])]:e._e(),e._v(" "),"paypal"==e.payment_gateway?[e.paypalButton?n("button",{staticClass:"btn btn-info",attrs:{type:"button"},on:{click:e.callPaypal}},[e._v(e._s(e.trans("general.proceed")))]):e._e()]:e._e(),e._v(" "),"stripe"==e.payment_gateway?[n("div",{staticClass:"row m-t-40"},[n("div",{staticClass:"col-12"},[n("div",{staticClass:"form-group"},[n("input",{directives:[{name:"model",rawName:"v-model",value:e.stripe.card_number,expression:"stripe.card_number"}],staticClass:"form-control",attrs:{type:"number",maxlength:"16",value:"",placeholder:e.trans("finance.card_number")},domProps:{value:e.stripe.card_number},on:{input:function(t){t.target.composing||e.$set(e.stripe,"card_number",t.target.value)}}})])]),e._v(" "),n("div",{staticClass:"col-3"},[n("div",{staticClass:"form-group"},[n("input",{directives:[{name:"model",rawName:"v-model",value:e.stripe.month,expression:"stripe.month"}],staticClass:"form-control",attrs:{type:"number",value:"",placeholder:e.trans("finance.card_expiry_month")},domProps:{value:e.stripe.month},on:{input:function(t){t.target.composing||e.$set(e.stripe,"month",t.target.value)}}})])]),e._v(" "),n("div",{staticClass:"col-4"},[n("div",{staticClass:"form-group"},[n("input",{directives:[{name:"model",rawName:"v-model",value:e.stripe.year,expression:"stripe.year"}],staticClass:"form-control",attrs:{type:"number",value:"",placeholder:e.trans("finance.card_expiry_year")},domProps:{value:e.stripe.year},on:{input:function(t){t.target.composing||e.$set(e.stripe,"year",t.target.value)}}})])]),e._v(" "),n("div",{staticClass:"col-1"}),e._v(" "),n("div",{staticClass:"col-4"},[n("div",{staticClass:"form-group"},[n("input",{directives:[{name:"model",rawName:"v-model",value:e.stripe.cvc,expression:"stripe.cvc"}],staticClass:"form-control",attrs:{type:"number",value:"",placeholder:e.trans("finance.card_cvc")},domProps:{value:e.stripe.cvc},on:{input:function(t){t.target.composing||e.$set(e.stripe,"cvc",t.target.value)}}})])])]),e._v(" "),e.stripeButton?n("button",{staticClass:"btn btn-info waves-effect waves-light pull-right",attrs:{type:"button"},on:{click:e.stripeCheckout}},[n("span",[e._v(e._s(e.trans("general.proceed")))])]):e._e()]:e._e()],2)])])]}))],2)])])])])}),[],!1,null,null,null).exports;const u={components:{},props:["id","uuid","rid"],data:function(){return{transactions:[],transaction:{},cancel_fee_payment:!1,cancelPaymentForm:new Form({cancellation_remarks:""})}},mounted:function(){this.getDetail(this.id)},methods:{hasPermission:function(e){return helper.hasPermission(e)},formatCurrency:function(e){return helper.formatCurrency(e)},getDetail:function(e){var t=this,n=this.$loading.show();axios.get("/api/student/"+this.uuid+"/fee/"+this.rid+"/"+e).then((function(e){t.transactions=e.transactions,t.transaction=e.transactions[0],n.hide()})).catch((function(e){n.hide(),helper.showErrorMsg(e)}))},getEmployeeName:function(e){return helper.getEmployeeName(e)},cancelPayment:function(){var e=this,t=this.$loading.show();this.cancelPaymentForm.post("/api/student/"+this.uuid+"/fee/"+this.rid+"/"+this.id+"/"+this.transaction.id+"/cancel").then((function(n){toastr.success(n.message),e.$emit("completed"),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},printReceipt:function(){var e=this.$loading.show();axios.post("/api/student/"+this.uuid+"/fee/"+this.rid+"/"+this.id+"/"+this.transaction.id+"/print").then((function(t){var n=window.open("/print");e.hide(),n.document.write(t)})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}},computed:{transactionGroup:function(){var e=[];return this.transaction.groups.forEach((function(t){e.push((t.prefix||"")+""+t.number)})),e.sort(),e}},filters:{moment:function(e){return helper.formatDate(e)},momentDateTime:function(e){return helper.formatDateTime(e)}},watch:{id:function(e){e&&this.getDetail(e)}}};const f=(0,r.Z)(u,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("div",[e._l(e.transactions,(function(t){return[n("button",{staticClass:"btn btn-info m-r-10",attrs:{type:"button"},on:{click:function(n){e.transaction=t}}},[e._v(e._s((t.prefix||"")+""+t.number))])]})),e._v(" "),n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.trans("finance.print_receipt"),expression:"trans('finance.print_receipt')"}],staticClass:"btn btn-info btn-sm pull-right",attrs:{type:"button"},on:{click:e.printReceipt}},[n("i",{staticClass:"fas fa-print"})]),e._v(" "),e.transaction.id?[n("div",{staticClass:"table-responsive m-t-20"},[n("table",{staticClass:"table table-bordered"},[n("tbody",[n("tr",[n("td",[e._v(e._s(e.trans("finance.receipt_no")))]),e._v(" "),n("td",[e._v(e._s((e.transaction.prefix||"")+""+e.transaction.number)+"\n                                "),e.transactionGroup.length>1?n("span",[e._v("("+e._s(e.transactionGroup.toString())+")")]):e._e()]),e._v(" "),e.transaction.is_online_payment?[n("td",[e._v(e._s(e.trans("finance.payment_method")))]),e._v(" "),n("td",[e._v(e._s(e.trans("finance.online_payment")))])]:[n("td",[e._v(e._s(e.trans("finance.account")))]),e._v(" "),n("td",[e._v(e._s(e.transaction.account?e.transaction.account.name:""))])]],2),e._v(" "),n("tr",[n("td",[e._v(e._s(e.trans("finance.amount")))]),e._v(" "),n("td",[e._v(e._s(e.formatCurrency(e.transaction.amount)))]),e._v(" "),n("td",[e._v(e._s(e.trans("finance.date")))]),e._v(" "),n("td",[e._v(e._s(e._f("moment")(e.transaction.date)))])]),e._v(" "),n("tr",[e.transaction.is_online_payment?[n("td",[e._v(e._s(e.trans("finance.reference_number")))]),e._v(" "),n("td",[e._v(e._s(e.transaction.reference_number))])]:[n("td",[e._v(e._s(e.trans("finance.payment_method")))]),e._v(" "),n("td",[e._v("\n                                    "+e._s(e.transaction.payment_method.name)+"\n                                    "),e.transaction.instrument_number?n("span",[n("br"),e._v(e._s(e.trans("finance.instrument_number"))+": "+e._s(e.transaction.instrument_number))]):e._e(),e._v(" "),e.transaction.instrument_date?n("span",[n("br"),e._v(e._s(e.trans("finance.instrument_date"))+": "),n("span",[e._v(e._s(e._f("moment")(e.transaction.instrument_date)))])]):e._e(),e._v(" "),e.transaction.instrument_clearing_date?n("span",[n("br"),e._v(e._s(e.trans("finance.instrument_clearing_date"))+": "),n("span",[e._v(e._s(e._f("moment")(e.transaction.instrument_clearing_date)))])]):e._e(),e._v(" "),e.transaction.instrument_bank_detail?n("span",[n("br"),e._v(e._s(e.trans("finance.instrument_bank_detail"))+": "+e._s(e.transaction.instrument_bank_detail))]):e._e(),e._v(" "),e.transaction.reference_number?n("span",[n("br"),e._v(e._s(e.trans("finance.reference_number"))+": "+e._s(e.transaction.reference_number))]):e._e()])],e._v(" "),n("td",[e._v(e._s(e.trans("finance.date_of_entry")))]),e._v(" "),n("td",[e._v(e._s(e._f("momentDateTime")(e.transaction.created_at)))])],2),e._v(" "),n("tr",[e.transaction.is_online_payment?e._e():[n("td",[e._v(e._s(e.trans("finance.remarks")))]),e._v(" "),n("td",[e._v(e._s(e.transaction.remarks))]),e._v(" "),n("td",[e._v(e._s(e.trans("finance.entry_by")))]),e._v(" "),n("td",[e._v("\n                                    "+e._s(e.getEmployeeName(e.transaction.user.employee))+"\n                                ")])]],2)])])]),e._v(" "),e.transaction.is_deletable&&e.hasPermission("cancel-fee-payment")?n("button",{staticClass:"btn btn-block btn-danger",attrs:{type:"button"},on:{click:function(t){e.cancel_fee_payment=!0}}},[e._v(e._s(e.trans("student.cancel_fee_payment")))]):e._e(),e._v(" "),e.cancel_fee_payment?[e.transaction.is_deletable?n("form",{staticClass:"m-t-20",on:{submit:function(t){return t.preventDefault(),e.cancelPayment.apply(null,arguments)},keydown:function(t){return e.cancelPaymentForm.errors.clear(t.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12"},[e.transactionGroup.length>1?n("div",{staticClass:"form-group"},[n("div",[e._v(e._s(e.trans("finance.cancel_all_group_fee_payment",{numbers:e.transactionGroup.toString()})))])]):e._e(),e._v(" "),n("div",{staticClass:"form-group"},[n("autosize-textarea",{attrs:{rows:"2",name:"cancellation_remarks",placeholder:e.trans("student.cancellation_remarks")},model:{value:e.cancelPaymentForm.cancellation_remarks,callback:function(t){e.$set(e.cancelPaymentForm,"cancellation_remarks",t)},expression:"cancelPaymentForm.cancellation_remarks"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.cancelPaymentForm,"prop-name":"cancellation_remarks"}})],1),e._v(" "),n("button",{staticClass:"btn btn-danger waves-effect waves-light",attrs:{type:"submit"}},[e._v(e._s(e.trans("general.save")))])])])]):e._e()]:e._e()]:e._e()],2)}),[],!1,null,null,null).exports,p={components:{studentSummary:a.Z,feePaymentForm:i,feePaymentParentForm:m,feeDetail:f},data:function(){return{uuid:this.$route.params.uuid,record_id:this.$route.params.record_id,student_record:{fee_allocation:{fee_allocation_groups:[]}},feePayment:{fee_group_name:"",fee_payment_installment_id:"",student_fee_record_id:"",date:helper.today(),installments:[],amount:0},fee:{groups:[]},feePaymentForm:!1,feePaymentShow:!1}},mounted:function(){helper.hasPermission("list-student-fee")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getRecord(),helper.showDemoNotification(["student"])},methods:{hasPermission:function(e){return helper.hasPermission(e)},hasAnyRole:function(e){return helper.hasAnyRole(e)},hasNotAnyRole:function(e){return helper.hasNotAnyRole(e)},getConfig:function(e){return helper.getConfig(e)},getStudentName:function(e){return helper.getStudentName(e)},getRecord:function(){var e=this,t=this.$loading.show();this.feePaymentForm=!1,this.feePaymentShow=!1,axios.get("/api/student/"+this.uuid+"/fee/"+this.record_id).then((function(n){e.student_record=n.student_record,e.student_record.student_fee_records.length||e.$router.push("/student/"+e.uuid),t.hide()})).catch((function(n){t.hide(),helper.showErrorMsg(n),e.hasAnyRole(["student","parent"])?e.$router.push("/student/list"):e.$router.push("/student/"+e.uuid+"/fee/"+e.record_id+"/create")}))},calculate:function(){var e=this;this.fee={groups:[]},this.student_record.fee_allocation.fee_allocation_groups.forEach((function(t){var n=[],a=[],s=[];a.push(i18n.finance.fee_installment_title),a.push(i18n.finance.fee_installment_due_date),t.fee_group.fee_heads.forEach((function(e){a.push(e.name)})),t.fee_group.options.has_transport&&(a.push(i18n.transport.circle),a.push(i18n.transport.fee)),s.push(i18n.finance.total),s.push(""),a.push(i18n.finance.late_fee),a.push(i18n.finance.installment_total),a.push(i18n.finance.other),a.push(i18n.finance.paid),a.push(i18n.finance.balance),a.push(i18n.finance.fee_status),t.fee_installments.forEach((function(a){var s=e.student_record.student_fee_records.find((function(e){return e.fee_installment_id==a.id})),r=[];r.push({text:a.title}),r.push({text:e.showDate(s.due_date||a.due_date)}),t.fee_group.fee_heads.forEach((function(t){r.push({text:e.getInstallmentFeeAmount(a,t.id),actual:e.getInstallmentFeeAmountWithoutConcession(a,t.id),is_concession:!!e.checkInstallmentConcession(a,t.id)})})),t.fee_group.options.has_transport&&(r.push({text:e.getTransportCircleName(a)}),r.push({text:e.getTransportFeeAmount(a)})),r.push({text:e.getLateFeeAmount(a)}),r.push({text:e.getInstallmentTotalAmount(a)}),r.push({text:e.getInstallmentOtherAmount(a)}),r.push({text:e.getInstallmentPaidAmount(a)}),r.push({text:e.getInstallmentBalanceAmount(a)}),r.push({text:e.getInstallmentPrintStatus(a)}),n.push({data:r})})),t.fee_group.fee_heads.forEach((function(n){s.push(e.getTotalFee(t,n.id))})),t.fee_group.options.has_transport&&(s.push(""),s.push(e.getTransportFeeTotal(t))),s.push(e.getLateFeeTotal(t)),s.push(e.getInstallmentGrandTotal(t)),s.push(e.getInstallmentGrandOther(t)),s.push(e.getInstallmentPaidGrandTotal(t)),s.push(e.getInstallmentBalanceGrandTotal(t)),s.push("");var r={name:t.fee_group.name,heads:a,installments:n,foots:s};e.fee.groups.push(r)}))},formatCurrency:function(e){return helper.formatCurrency(e)},isInstallmentOverdue:function(e){var t=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));return helper.today()>(t.due_date||e.due_date)&&"paid"!=t.status?helper.getDateDiff(t.due_date||e.due_date):0},getStatus:function(e){var t=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));return"paid"==t.status?'<span class="label label-success">'+i18n.student.fee_status_paid+"</span>":"partially_paid"==t.status?'<span class="label label-warning">'+i18n.student.fee_status_partially_paid+"</span>":"cancelled"==t.status?'<span class="label label-danger">'+i18n.student.fee_status_cancelled+"</span>":'<span class="label label-danger">'+i18n.student.fee_status_unpaid+"</span>"},getInstallmentDueDate:function(e){var t=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));return helper.formatDate(t.due_date||e.due_date)},getInstallmentStatus:function(e){return this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id})).status},getInstallmentFee:function(e,t){var n=this.getInstallmentFeeWithoutConcession(e,t);return this.getInstallmentFeeWithConcession(n,e,t)},getInstallmentFeeWithoutConcession:function(e,t){var n=e.fee_installment_details.find((function(e){return e.fee_head_id==t}));return void 0===n?0:this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id})).student_optional_fee_records.findIndex((function(e){return e.fee_head_id==t}))<0?n.amount:0},checkInstallmentConcession:function(e,t){e.fee_installment_details.find((function(e){return e.fee_head_id==t}));var n=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));return(n.fee_concession?n.fee_concession.fee_concession_details.findIndex((function(e){return e.fee_head_id==t})):-1)>=0},getInstallmentFeeWithConcession:function(e,t,n){t.fee_installment_details.find((function(e){return e.fee_head_id==n}));var a=this.student_record.student_fee_records.find((function(e){return e.fee_installment_id==t.id})),s=a.fee_concession?a.fee_concession.fee_concession_details.findIndex((function(e){return e.fee_head_id==n})):-1;if(s>=0){var r=a.fee_concession.fee_concession_details[s],i="percent"==r.type?e*(r.amount/100):r.amount;return e-i>=0?Math.ceil(e-i):0}return Math.ceil(e)},getInstallmentFeeAmountWithoutConcession:function(e,t){var n=this.getInstallmentFeeWithoutConcession(e,t);return helper.formatCurrency(n)},getInstallmentFeeAmount:function(e,t){var n=this.getInstallmentFee(e,t);return helper.formatCurrency(n)},getInstallmentTotalWithoutLateFee:function(e){var t=this,n=(this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id})),0);e.fee_installment_details.forEach((function(a){n+=t.getInstallmentFee(e,a.fee_head_id)}));var a=this.getTransportFee(e);return n+=Number.isInteger(a)?a:0},getInstallmentTotal:function(e){var t=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id})),n=this.getInstallmentTotalWithoutLateFee(e);if(n||"unpaid"!=t.status){var a=this.getLateFee(e);n+=Number.isInteger(a)?a:0}return n},getInstallmentTotalAmount:function(e){var t=this.getInstallmentTotal(e);return helper.formatCurrency(t)},getInstallmentOther:function(e){var t=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id})),n=0;return t.transactions.forEach((function(e){e.is_cancelled||(e.options.additional_fee_charge&&e.options.additional_fee_charge.amount&&(n+=e.options.additional_fee_charge.amount),e.options.additional_fee_discount&&e.options.additional_fee_discount.amount&&(n-=e.options.additional_fee_discount.amount))})),n},getInstallmentOtherAmount:function(e){var t=this.getInstallmentOther(e);return helper.formatCurrency(t)},getInstallmentPaid:function(e){var t=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id})),n=0;return t.transactions.forEach((function(e){e.is_cancelled||(n+=e.amount)})),n},getInstallmentPaidAmount:function(e){var t=this.getInstallmentPaid(e);return helper.formatCurrency(t)},getInstallmentBalance:function(e){return this.getInstallmentTotal(e)+this.getInstallmentOther(e)-this.getInstallmentPaid(e)},getInstallmentBalanceAmount:function(e){var t=this.getInstallmentBalance(e);return helper.formatCurrency(t)},getTransportCircleName:function(e){var t=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));return t.transport_circle?t.transport_circle.name:"-"},getTransportFee:function(e){var t=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));return t.transport_circle_id&&e.transport_fee_id?e.transport_fee.transport_fee_details.find((function(e){return e.transport_circle_id==t.transport_circle_id})).amount:"-"},getTransportFeeAmount:function(e){var t=this.getTransportFee(e);return Number.isInteger(t)?helper.formatCurrency(t):"-"},getLateFeeAmount:function(e){var t=this.getLateFee(e);return Number.isInteger(t)?helper.formatCurrency(t):"-"},getLateFee:function(e){if(!this.getInstallmentTotalWithoutLateFee(e))return"-";var t=helper.toDate(this.feePayment.date),n=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));if("paid"==n.status)return n.late_fee_charged;if(null==n.late_fee_applicable&&!e.late_fee_applicable||0==n.late_fee_applicable)return"-";if(t<=(n.due_date||e.due_date))return"-";var a=helper.getDateDiff(n.due_date||e.due_date,t),s=Math.floor(a/(n.late_fee_frequency||e.late_fee_frequency));return(n.late_fee||e.late_fee)*s},showInstallmentDetail:function(e,t){var n=this;this.feePayment.installments=[],this.feePayment.fee_group_name=e.fee_group.name;var a=e.fee_installments.filter((function(e){return e.due_date<=t.due_date})),s=0;a.forEach((function(e){var t=n.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));if("unpaid"==t.status||"partially_paid"==t.status){var a=n.getInstallmentTotalWithoutLateFee(e),r=n.getInstallmentOther(e),i=n.getLateFee(e),o=n.getInstallmentPaid(e),l=(a+=r)>o?a-o:0;a&&(i=Number.isInteger(i)?i:0);var d=!l&&i?i-(o-a):i,_=a;a&&(_+=i=Number.isInteger(i)?i:0);var c=_-o;s+=c,n.feePayment.installments.push({fee_installment_id:t.fee_installment_id,title:e.title,installment_fee:a,installment_balance:l,late_fee_balance:Number.isInteger(d)?d:0,late_fee:i,paid:o,total:c})}})),this.feePayment.amount=s,this.feePayment.fee_payment_installment_id=t.id,this.feePaymentForm=!0},getTotalFee:function(e,t){var n=this,a=0;return e.fee_installments.forEach((function(e){a+=n.getInstallmentFee(e,t)})),helper.formatCurrency(a)},getTransportFeeTotal:function(e){var t=this,n=0;return e.fee_installments.forEach((function(e){var a=t.getTransportFee(e);n+=Number.isInteger(a)?a:0})),n?this.formatCurrency(n):"-"},getLateFeeTotal:function(e){var t=this,n=0;return e.fee_installments.forEach((function(e){var a=t.getLateFee(e);n+=Number.isInteger(a)?a:0})),n?this.formatCurrency(n):"-"},getInstallmentGrandTotal:function(e){var t=this.getInstallmentGrandTotalAmount(e);return Number.isInteger(t)?helper.formatCurrency(t):"-"},getInstallmentGrandTotalAmount:function(e){var t=this,n=0;return e.fee_installments.forEach((function(e){n+=t.getInstallmentTotal(e)})),n},getInstallmentGrandOther:function(e){var t=this.getInstallmentGrandOtherAmount(e);return Number.isInteger(t)?helper.formatCurrency(t):"-"},getInstallmentGrandOtherAmount:function(e){var t=this,n=0;return e.fee_installments.forEach((function(e){n+=t.getInstallmentOther(e)})),n},getInstallmentPaidGrandTotal:function(e){var t=this.getInstallmentPaidGrandTotalAmount(e);return Number.isInteger(t)?helper.formatCurrency(t):"-"},getInstallmentPaidGrandTotalAmount:function(e){var t=this,n=0;return e.fee_installments.forEach((function(e){n+=t.getInstallmentPaid(e)})),n},getInstallmentBalanceGrandTotal:function(e){var t=this.getInstallmentBalanceGrandTotalAmount(e);return Number.isInteger(t)?helper.formatCurrency(t):"-"},getInstallmentBalanceGrandTotalAmount:function(e){var t=this,n=0;return e.fee_installments.forEach((function(e){n+=t.getInstallmentBalance(e)})),n},paymentMade:function(){this.getRecord()},showDate:function(e){return helper.formatDate(e)},getInstallmentPrintStatus:function(e){var t=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));return"paid"==t.status?i18n.student.fee_status_paid:"partially_paid"==t.status?i18n.student.fee_status_partially_paid:"cancelled"==t.status?i18n.student.fee_status_cancelled:"unpaid"==t.status?i18n.student.fee_status_unpaid:void 0},setTransaction:function(e){var t=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));this.student_fee_record_id=t.id,this.feePaymentShow=!0},print:function(){var e=this.$loading.show();this.calculate(),axios.post("/api/student/"+this.uuid+"/fee/"+this.record_id+"/print",{fee:this.fee}).then((function(t){var n=window.open("/print");e.hide(),n.document.write(t)})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},pdf:function(){var e=this,t=this.$loading.show();this.calculate(),axios.post("/api/student/"+this.uuid+"/fee/"+this.record_id+"/pdf",{fee:this.fee}).then((function(n){t.hide(),window.open("/download/report/"+n+"?token="+e.authToken)})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},confirmEmptyReceiptDelete:function(e){var t=this;return function(n){return t.deleteEmptyReceipt(e)}},deleteEmptyReceipt:function(e){var t=this,n=this.$loading.show(),a=this.student_record.student_fee_records.find((function(t){return t.fee_installment_id==e.id}));axios.post("/api/student/"+this.uuid+"/fee/"+this.record_id+"/"+a.id+"/cancel").then((function(e){toastr.success(e.message),t.getRecord(),n.hide()})).catch((function(e){n.hide(),helper.showErrorMsg(e)}))},confirmResetFee:function(e){var t=this;return function(n){return t.resetFee(e)}},resetFee:function(e){var t=this,n=this.$loading.show();axios.patch("/api/student/"+this.uuid+"/fee/"+this.record_id+"/reset").then((function(e){toastr.success(e.message),t.getRecord(),n.hide()})).catch((function(e){n.hide(),helper.showErrorMsg(e)}))}},filters:{moment:function(e){return helper.formatDate(e)},momentDateTime:function(e){return helper.formatDateTime(e)}},computed:{authToken:function(){return helper.getAuthToken()},resetFeeOption:function(){return!!this.student_record.id&&this.student_record.student_fee_records.every((function(e){return"unpaid"==e.status}))},finalTotal:function(){var e=this,t=0;return this.student_record.fee_allocation.fee_allocation_groups.forEach((function(n){t+=e.getInstallmentGrandTotalAmount(n)})),helper.formatCurrency(t)},finalOther:function(){var e=this,t=0;return this.student_record.fee_allocation.fee_allocation_groups.forEach((function(n){t+=e.getInstallmentGrandOtherAmount(n)})),helper.formatCurrency(t)},finalPaid:function(){var e=this,t=0;return this.student_record.fee_allocation.fee_allocation_groups.forEach((function(n){t+=e.getInstallmentPaidGrandTotalAmount(n)})),helper.formatCurrency(t)},finalBalance:function(){var e=this,t=0;return this.student_record.fee_allocation.fee_allocation_groups.forEach((function(n){t+=e.getInstallmentBalanceGrandTotalAmount(n)})),helper.formatCurrency(t)}},watch:{"$route.params.uuid":function(e){this.uuid=e,this.record_id=this.$route.params.record_id,this.getRecord()}}};var h=n(34932),g={insert:"head",singleton:!1};d()(h.Z,g);h.Z.locals;const v=(0,r.Z)(p,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("div",[n("div",{staticClass:"page-titles"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("finance.fee_detail"))+" "),e.student_record.student?n("small",[e._v(e._s(e.getStudentName(e.student_record.student))+"  ("+e._s(e.student_record.academic_session.name)+")")]):e._e()])]),e._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"action-buttons pull-right"},[n("router-link",{staticClass:"btn btn-info btn-sm",attrs:{to:"/student/list"}},[n("i",{staticClass:"fas fa-list"}),e._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("student.student")))])]),e._v(" "),n("div",{staticClass:"btn-group"},[n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.trans("general.more_option"),expression:"trans('general.more_option')"}],staticClass:"btn btn-info btn-sm dropdown-toggle no-caret ",attrs:{type:"button",role:"menu",id:"moreOption","data-toggle":"dropdown","aria-haspopup":"true","aria-expanded":"false"}},[n("i",{staticClass:"fas fa-ellipsis-h"}),e._v(" "),n("span",{staticClass:"d-none d-sm-inline"})]),e._v(" "),n("div",{class:["dropdown-menu","ltr"==e.getConfig("direction")?"dropdown-menu-right":""],attrs:{"aria-labelledby":"moreOption"}},[n("button",{staticClass:"dropdown-item custom-dropdown",on:{click:function(t){return e.$router.push("/student/"+e.student_record.student.uuid)}}},[n("i",{staticClass:"fas fa-arrow-circle-right"}),e._v(" "+e._s(e.trans("student.view_detail")))]),e._v(" "),e.hasPermission("set-fee")?n("button",{staticClass:"dropdown-item custom-dropdown",on:{click:function(t){return e.$router.push("/student/"+e.student_record.student.uuid+"/fee/"+e.student_record.id+"/set")}}},[n("i",{staticClass:"fas fa-file"}),e._v(" "+e._s(e.trans("student.set_fee")))]):e._e(),e._v(" "),n("button",{staticClass:"dropdown-item custom-dropdown",on:{click:e.print}},[n("i",{staticClass:"fas fa-print"}),e._v(" "+e._s(e.trans("general.print")))]),e._v(" "),n("button",{staticClass:"dropdown-item custom-dropdown",on:{click:e.pdf}},[n("i",{staticClass:"fas fa-file-pdf"}),e._v(" "+e._s(e.trans("general.generate_pdf")))])])])],1)])])]),e._v(" "),n("div",{staticClass:"container-fluid"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12"},[n("div",{staticClass:"card"},[n("div",{staticClass:"card-body py-4"},[n("student-summary",{staticClass:"border-bottom",attrs:{"student-record":e.student_record}})],1),e._v(" "),n("div",{staticClass:"card-body"},[e.hasPermission("customize-fee-date")?n("div",{staticClass:"row justify-content-end px-4"},[n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("student.date_of_payment")},model:{value:e.feePayment.date,callback:function(t){e.$set(e.feePayment,"date",t)},expression:"feePayment.date"}})],1)])]):e._e(),e._v(" "),e._l(e.student_record.fee_allocation.fee_allocation_groups,(function(t){return[n("h4",{staticClass:"card-title m-l-20"},[e._v(e._s(t.fee_group.name))]),e._v(" "),n("div",{staticClass:"table-responsive p-3"},[n("table",{staticClass:"table table-sm"},[n("thead",[n("tr",[n("th",[e._v(e._s(e.trans("finance.fee_installment_title")))]),e._v(" "),n("th",[e._v(e._s(e.trans("finance.fee_installment_due_date")))]),e._v(" "),e._l(t.fee_group.fee_heads,(function(t){return n("th",{domProps:{textContent:e._s(t.name)}})})),e._v(" "),n("th",[t.fee_group.options.has_transport?n("span",[e._v(e._s(e.trans("transport.circle")))]):e._e()]),e._v(" "),n("th",[t.fee_group.options.has_transport?n("span",[e._v(e._s(e.trans("transport.fee")))]):e._e()]),e._v(" "),n("th",[e._v(e._s(e.trans("finance.late_fee")))]),e._v(" "),n("th",[e._v(e._s(e.trans("finance.installment_total")))]),e._v(" "),n("th",[e._v(e._s(e.trans("finance.other")))]),e._v(" "),n("th",[e._v(e._s(e.trans("finance.paid")))]),e._v(" "),n("th",[e._v(e._s(e.trans("finance.balance")))]),e._v(" "),e.hasPermission("make-fee-payment")?n("th",[e._v(e._s(e.trans("finance.pay_fee")))]):n("th",[e._v(e._s(e.trans("finance.fee_status")))])],2)]),e._v(" "),n("tbody",[e._l(t.fee_installments,(function(a){return n("tr",[n("td",[e._v(e._s(a.title))]),e._v(" "),n("td",[e._v(e._s(e.getInstallmentDueDate(a))+"\n                                                "),e.isInstallmentOverdue(a)?[n("br"),e._v(" "),n("span",{staticClass:"label label-danger"},[e._v(e._s(e.trans("finance.fee_overdue_day",{day:e.isInstallmentOverdue(a)})))])]:e._e()],2),e._v(" "),e._l(t.fee_group.fee_heads,(function(t){return n("td",[e.checkInstallmentConcession(a,t.id)?n("span",{staticStyle:{"text-decoration":"line-through"}},[e._v(e._s(e.getInstallmentFeeAmountWithoutConcession(a,t.id)))]):e._e(),e._v("\n                                                "+e._s(e.getInstallmentFeeAmount(a,t.id))+"\n                                            ")])})),e._v(" "),n("td",[t.fee_group.options.has_transport?n("span",[e._v(e._s(e.getTransportCircleName(a)))]):e._e()]),e._v(" "),n("td",[t.fee_group.options.has_transport?n("span",[e._v(e._s(e.getTransportFeeAmount(a)))]):e._e()]),e._v(" "),n("td",[e._v(e._s(e.getLateFeeAmount(a)))]),e._v(" "),n("td",[e._v(e._s(e.getInstallmentTotalAmount(a)))]),e._v(" "),n("td",[e._v(e._s(e.getInstallmentOtherAmount(a)))]),e._v(" "),n("td",[e._v(e._s(e.getInstallmentPaidAmount(a)))]),e._v(" "),n("td",[e._v(e._s(e.getInstallmentBalanceAmount(a)))]),e._v(" "),e.hasPermission("make-fee-payment")?n("td",["unpaid"==e.getInstallmentStatus(a)?n("span",[n("button",{staticClass:"btn btn-info btn-sm",attrs:{type:"button"},on:{click:function(n){return e.showInstallmentDetail(t,a)}}},[e._v(e._s(e.trans("finance.pay_fee")))])]):"cancelled"==e.getInstallmentStatus(a)?n("span",[n("span",{staticClass:"label label-danger"},[e._v(e._s(e.trans("finance.fee_status_cancelled")))])]):n("span",[n("div",{staticClass:"btn-group"},["paid"==e.getInstallmentStatus(a)?[n("button",{staticClass:"btn btn-sm btn-success"},[e._v(e._s(e.trans("student.fee_status_paid")))]),e._v(" "),e._m(0,!0)]:e._e(),e._v(" "),"partially_paid"==e.getInstallmentStatus(a)?[n("button",{staticClass:"btn btn-sm btn-warning",on:{click:function(n){return e.showInstallmentDetail(t,a)}}},[e._v(e._s(e.trans("student.fee_status_partially_paid")))]),e._v(" "),e._m(1,!0)]:e._e(),e._v(" "),n("div",{staticClass:"dropdown-menu"},[e.getInstallmentPaid(a)?n("button",{staticClass:"dropdown-item custom-dropdown-menu",on:{click:function(t){return t.preventDefault(),e.setTransaction(a)}}},[n("i",{staticClass:"fas fa-arrow-circle-right"}),e._v(" "+e._s(e.trans("finance.receipt_detail"))+"\n                                                            ")]):!e.getInstallmentPaid(a)&&e.hasPermission("cancel-fee-payment")?n("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:e.confirmEmptyReceiptDelete(a)},expression:"{ok: confirmEmptyReceiptDelete(fee_installment)}"}],key:a.id,staticClass:"dropdown-item custom-dropdown-menu"},[n("i",{staticClass:"fas fa-arrow-circle-right"}),e._v(" "+e._s(e.trans("student.cancel_fee_payment"))+"\n                                                            ")]):e._e()])],2)])]):n("td",["unpaid"==e.getInstallmentStatus(a)?n("span",[e._v(e._s(e.trans("student.fee_status_unpaid")))]):n("span",[e._v(e._s(e.trans("student.fee_status_paid")))])])],2)})),e._v(" "),n("tr",[n("th",{attrs:{colspan:"2"}},[e._v(e._s(e.trans("general.total")))]),e._v(" "),e._l(t.fee_group.fee_heads,(function(a){return n("th",[e._v("\n                                                "+e._s(e.getTotalFee(t,a.id))+"\n                                            ")])})),e._v(" "),n("th"),e._v(" "),n("th",[t.fee_group.options.has_transport?n("span",[e._v(e._s(e.getTransportFeeTotal(t)))]):e._e()]),e._v(" "),n("th",[e._v(e._s(e.getLateFeeTotal(t)))]),e._v(" "),n("th",[e._v(e._s(e.getInstallmentGrandTotal(t)))]),e._v(" "),n("th",[e._v(e._s(e.getInstallmentGrandOther(t)))]),e._v(" "),n("th",[e._v(e._s(e.getInstallmentPaidGrandTotal(t)))]),e._v(" "),n("th",[e._v(e._s(e.getInstallmentBalanceGrandTotal(t)))]),e._v(" "),(e.hasPermission("make-fee-payment"),n("th"))],2)],2)])])]})),e._v(" "),n("div",{staticClass:"table-responsive p-3"},[n("table",{staticClass:"table table"},[n("thead",[n("tr",[n("th",[e._v(e._s(e.trans("finance.installment_total")))]),e._v(" "),n("th",[e._v(e._s(e.trans("finance.other")))]),e._v(" "),n("th",[e._v(e._s(e.trans("finance.paid")))]),e._v(" "),n("th",[e._v(e._s(e.trans("finance.balance")))])])]),e._v(" "),n("tbody",[n("tr",[n("td",[e._v(e._s(e.finalTotal))]),e._v(" "),n("td",[e._v(e._s(e.finalOther))]),e._v(" "),n("td",[e._v(e._s(e.finalPaid))]),e._v(" "),n("td",[e._v(e._s(e.finalBalance))])])])])]),e._v(" "),e.resetFeeOption&&e.hasPermission("set-fee")?n("div",{staticClass:"row justify-content-md-center"},[n("div",{staticClass:"col-4"},[n("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:e.confirmResetFee(e.student_record)},expression:"{ok: confirmResetFee(student_record)}"},{name:"tooltip",rawName:"v-tooltip",value:e.trans("student.reset_fee"),expression:"trans('student.reset_fee')"}],key:e.student_record.id,staticClass:"btn btn-danger btn-block"},[e._v(e._s(e.trans("student.reset_fee")))])])]):e._e()],2)])])])]),e._v(" "),e.feePaymentForm&&e.hasNotAnyRole(["parent","student"])&&e.hasPermission("make-fee-payment")?n("fee-payment-form",{attrs:{uuid:e.uuid,id:e.record_id,"fee-payment":e.feePayment},on:{completed:e.paymentMade,closeFeePaymentForm:function(t){e.feePaymentForm=!1}}}):e._e(),e._v(" "),e.feePaymentForm&&e.hasAnyRole(["parent","student"])&&e.hasPermission("make-fee-payment")?n("fee-payment-parent-form",{attrs:{uuid:e.uuid,id:e.record_id,"fee-payment":e.feePayment},on:{completed:e.paymentMade,closeFeePaymentForm:function(t){e.feePaymentForm=!1}}}):e._e(),e._v(" "),e.feePaymentShow?n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[e._t("header",(function(){return[e._v("\n                            "+e._s(e.trans("finance.fee_payment"))+"\n                            "),n("span",{staticClass:"float-right pointer",on:{click:function(t){e.feePaymentShow=!1}}},[e._v("x")])]}))],2),e._v(" "),n("div",{staticClass:"modal-body"},[e._t("body",(function(){return[n("div",{staticStyle:{"max-height":"600px"}},[n("fee-detail",{attrs:{uuid:e.uuid,rid:e.record_id,id:e.student_fee_record_id},on:{completed:e.getRecord}}),e._v(" "),n("div",{staticClass:"clearfix"})],1)]}))],2)])])])]):e._e()],1)}),[function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("button",{staticClass:"btn btn-sm btn-success dropdown-toggle dropdown-toggle-split",attrs:{type:"button","data-toggle":"dropdown","aria-haspopup":"true","aria-expanded":"false"}},[n("span",{staticClass:"sr-only"},[e._v("Toggle Dropdown")])])},function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("button",{staticClass:"btn btn-sm btn-warning dropdown-toggle dropdown-toggle-split",attrs:{type:"button","data-toggle":"dropdown","aria-haspopup":"true","aria-expanded":"false"}},[n("span",{staticClass:"sr-only"},[e._v("Toggle Dropdown")])])}],!1,null,null,null).exports},7167:(e,t,n)=>{"use strict";n.d(t,{Z:()=>s});const a={props:["studentRecord"],data:function(){return{student_record:{}}},mounted:function(){},methods:{getStudentName:function(e){return helper.getStudentName(e)},getAdmissionNumber:function(e){return helper.getAdmissionNumber(e)}},filters:{moment:function(e){return helper.formatDate(e)},momentDateTime:function(e){return helper.formatDateTime(e)}},computed:{getImage:function(){return this.student_record.student.student_photo?"/"+this.student_record.student.student_photo:"female"==this.student_record.student.gender?"/images/female.png":"/images/male.png"}},watch:{studentRecord:function(e){this.student_record=e}}};const s=(0,n(51900).Z)(a,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return e.student_record.student?n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group text-center"},[n("img",{staticClass:"img-fluid",staticStyle:{"max-width":"200px"},attrs:{src:e.getImage}})])]),e._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-borderless custom-show-table"},[n("tbody",[n("tr",[n("td",{staticClass:"font-weight-bold"},[e._v(e._s(e.trans("student.name")))]),e._v(" "),n("td",[e._v(e._s(e.getStudentName(e.student_record.student)))])]),e._v(" "),n("tr",[n("td",{staticClass:"font-weight-bold"},[e._v(e._s(e.trans("student.admission_number")))]),e._v(" "),n("td",[e._v(e._s(e.getAdmissionNumber(e.student_record.admission)))])]),e._v(" "),n("tr",[n("td",{staticClass:"font-weight-bold"},[e._v(e._s(e.trans("student.date_of_admission")))]),e._v(" "),n("td",[e._v(e._s(e._f("moment")(e.student_record.admission.date_of_admission)))])]),e._v(" "),n("tr",[n("td",{staticClass:"font-weight-bold"},[e._v(e._s(e.trans("academic.course")))]),e._v(" "),n("td",[e._v(e._s(e.student_record.batch.course.name+" ("+e.student_record.batch.course.course_group.name+")"))])]),e._v(" "),n("tr",[n("td",{staticClass:"font-weight-bold"},[e._v(e._s(e.trans("academic.batch")))]),e._v(" "),n("td",[e._v(e._s(e.student_record.batch.name))])]),e._v(" "),n("tr",[n("td",{staticClass:"font-weight-bold"},[e._v(e._s(e.trans("student.date_of_birth")))]),e._v(" "),n("td",[e._v(e._s(e._f("moment")(e.student_record.student.date_of_birth)))])])])])])]),e._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-borderless custom-show-table"},[n("tbody",[n("tr",[n("td",{staticClass:"font-weight-bold"},[e._v(e._s(e.trans("student.father_name")))]),e._v(" "),n("td",[e._v(e._s(e.student_record.student.parent?e.student_record.student.parent.father_name:""))])]),e._v(" "),n("tr",[n("td",{staticClass:"font-weight-bold"},[e._v(e._s(e.trans("student.mother_name")))]),e._v(" "),n("td",[e._v(e._s(e.student_record.student.parent?e.student_record.student.parent.mother_name:""))])]),e._v(" "),n("tr",[n("td",{staticClass:"font-weight-bold"},[e._v(e._s(e.trans("student.contact_number")))]),e._v(" "),n("td",[e._v(e._s(e.student_record.student.contact_number))])]),e._v(" "),n("tr",[n("td",{staticClass:"font-weight-bold"},[e._v(e._s(e.trans("student.present_address")))]),e._v(" "),n("td",[e._v("\n\t                            "+e._s(e.student_record.student.present_address_line_1)+"\n\t                            "),e.student_record.student.present_address_line_2?n("span",[e._v(", "+e._s(e.student_record.student.present_address_line_2))]):e._e(),e._v(" "),e.student_record.student.present_city?n("span",[n("br"),e._v(" "+e._s(e.student_record.student.present_city))]):e._e(),e._v(" "),e.student_record.student.present_state?n("span",[e._v(", "+e._s(e.student_record.student.present_state))]):e._e(),e._v(" "),e.student_record.student.present_zipcode?n("span",[e._v(", "+e._s(e.student_record.student.present_zipcode))]):e._e(),e._v(" "),e.student_record.student.present_country?n("span",[n("br"),e._v(" "+e._s(e.student_record.student.present_country))]):e._e()])])])])])])]):e._e()}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=index.js.map?id=59fbf2e84b73db5477ae