(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[3262],{35593:(t,e,n)=>{"use strict";n.d(e,{Z:()=>r});var a=n(94015),s=n.n(a),i=n(23645),o=n.n(i)()(s());o.push([t.id,".loading-overlay{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/student/account/create.vue"],names:[],mappings:"AAsCA,iBACA,YACA",sourcesContent:['<template>\n    <transition name="modal">\n        <div class="modal-mask">\n            <div class="modal-wrapper">\n                <div class="modal-container modal-lg">\n                    <div class="modal-header">\n                        <slot name="header">\n                            {{trans(\'student.add_new_account\')}}\n                            <span class="float-right pointer" @click="$emit(\'close\')">x</span>\n                        </slot>\n                    </div>\n                    <div class="modal-body">\n                        <slot name="body">\n                            <account-form :uuid="student.uuid" @completed="complete"></account-form>\n                        </slot>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </transition>\n</template>\n\n<script>\n    import accountForm from \'./form\'\n\n    export default {\n        components: {accountForm},\n        props: [\'student\'],\n        methods:{\n            complete(){\n                this.$emit(\'completed\');\n                this.$emit(\'close\');\n            }\n        }\n    }\n<\/script>\n\n<style>\n    .loading-overlay{\n        z-index: 1060;\n    }\n</style>'],sourceRoot:""}]);const r=o},30941:(t,e,n)=>{"use strict";n.d(e,{Z:()=>r});var a=n(94015),s=n.n(a),i=n(23645),o=n.n(i)()(s());o.push([t.id,".loading-overlay{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/student/account/edit.vue"],names:[],mappings:"AAsCA,iBACA,YACA",sourcesContent:['<template>\n    <transition name="modal">\n        <div class="modal-mask">\n            <div class="modal-wrapper">\n                <div class="modal-container modal-lg">\n                    <div class="modal-header">\n                        <slot name="header">\n                            {{trans(\'student.edit_account\')}}\n                            <span class="float-right pointer" @click="$emit(\'close\')">x</span>\n                        </slot>\n                    </div>\n                    <div class="modal-body">\n                        <slot name="body">\n                            <account-form :uuid="student.uuid" :aid="aid" @completed="complete"></account-form>\n                        </slot>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </transition>\n</template>\n\n<script>\n    import accountForm from \'./form\'\n\n    export default {\n        components: {accountForm},\n        props: [\'student\',\'aid\'],\n        methods: {\n            complete(){\n                this.$emit(\'completed\');\n                this.$emit(\'close\');\n            }\n        }\n    }\n<\/script>\n\n<style>\n    .loading-overlay{\n        z-index: 1060;\n    }\n</style>'],sourceRoot:""}]);const r=o},59188:(t,e,n)=>{"use strict";n.d(e,{Z:()=>r});var a=n(94015),s=n.n(a),i=n(23645),o=n.n(i)()(s());o.push([t.id,".loading-overlay{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/student/document/create.vue"],names:[],mappings:"AAsCA,iBACA,YACA",sourcesContent:['<template>\n    <transition name="modal">\n        <div class="modal-mask">\n            <div class="modal-wrapper">\n                <div class="modal-container modal-lg">\n                    <div class="modal-header">\n                        <slot name="header">\n                            {{trans(\'student.add_new_document\')}}\n                            <span class="float-right pointer" @click="$emit(\'close\')">x</span>\n                        </slot>\n                    </div>\n                    <div class="modal-body">\n                        <slot name="body">\n                            <document-form :uuid="student.uuid" @completed="complete"></document-form>\n                        </slot>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </transition>\n</template>\n\n<script>\n    import documentForm from \'./form\'\n\n    export default {\n        components: {documentForm},\n        props: [\'student\'],\n        methods:{\n            complete(){\n                this.$emit(\'completed\');\n                this.$emit(\'close\');\n            }\n        }\n    }\n<\/script>\n\n<style>\n    .loading-overlay{\n        z-index: 1060;\n    }\n</style>'],sourceRoot:""}]);const r=o},49512:(t,e,n)=>{"use strict";n.d(e,{Z:()=>r});var a=n(94015),s=n.n(a),i=n(23645),o=n.n(i)()(s());o.push([t.id,".loading-overlay{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/student/document/edit.vue"],names:[],mappings:"AAsCA,iBACA,YACA",sourcesContent:['<template>\n    <transition name="modal">\n        <div class="modal-mask">\n            <div class="modal-wrapper">\n                <div class="modal-container modal-lg">\n                    <div class="modal-header">\n                        <slot name="header">\n                            {{trans(\'student.edit_document\')}}\n                            <span class="float-right pointer" @click="$emit(\'close\')">x</span>\n                        </slot>\n                    </div>\n                    <div class="modal-body">\n                        <slot name="body">\n                            <document-form :uuid="student.uuid" :did="did" @completed="complete"></document-form>\n                        </slot>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </transition>\n</template>\n\n<script>\n    import documentForm from \'./form\'\n\n    export default {\n        components: {documentForm},\n        props: [\'student\',\'did\'],\n        methods: {\n            complete(){\n                this.$emit(\'completed\');\n                this.$emit(\'close\');\n            }\n        }\n    }\n<\/script>\n\n<style>\n    .loading-overlay{\n        z-index: 1060;\n    }\n</style>'],sourceRoot:""}]);const r=o},82824:(t,e,n)=>{"use strict";n.d(e,{Z:()=>r});var a=n(94015),s=n.n(a),i=n(23645),o=n.n(i)()(s());o.push([t.id,".loading-overlay{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/student/edit-record.vue"],names:[],mappings:"AAoIA,iBACA,YACA",sourcesContent:['<template>\n    <transition name="modal">\n        <div class="modal-mask">\n            <div class="modal-wrapper">\n                <div class="modal-container modal-lg">\n                    <div class="modal-header">\n                        <slot name="header">\n                            {{trans(\'student.edit_record\')}}\n                            <span class="float-right pointer" @click="$emit(\'close\')">x</span>\n                        </slot>\n                    </div>\n                    <div class="modal-body" style="min-height: 300px;">\n                        <slot name="body">\n                            <form @submit.prevent="submit" @keydown="recordForm.errors.clear($event.target.name)">\n                                <div class="row">\n                                    <div class="col-12 col-sm-6">\n                                        <div class="form-group">\n                                            <label for="">{{trans(\'student.date_of_admission_promotion\')}}</label>\n                                            <datepicker v-model="recordForm.date_of_entry" :bootstrapStyling="true" @selected="recordForm.errors.clear(\'date_of_entry\')" :placeholder="trans(\'student.date_of_admission_promotion\')"></datepicker>\n                                            <show-error :form-name="recordForm" prop-name="date_of_entry"></show-error>\n                                        </div>\n                                    </div>\n                                    <div class="col-12 col-sm-6">\n                                        <div class="form-group">\n                                            <label for="">{{trans(\'academic.batch\')}}</label>\n                                            <v-select label="name" v-model="selected_batch" group-values="batches" group-label="course_group" :group-select="false" name="batch_id" id="batch_id" :options="batches" :placeholder="trans(\'academic.select_batch\')" @select="onBatchSelect" @close="recordForm.errors.clear(\'batch_id\')" @remove="onBatchRemove">\n                                                <div class="multiselect__option" slot="afterList" v-if="!batches.length">\n                                                    {{trans(\'general.no_option_found\')}}\n                                                </div>\n                                            </v-select>\n                                            <show-error :form-name="recordForm" prop-name="batch_id"></show-error>\n                                        </div>\n                                    </div>\n                                    <div class="col-12 col-sm-6">\n                                        <div class="form-group">\n                                            <label for="">{{trans(\'student.admission_number\')}}</label>\n                                            <div class="row">\n                                                <div class="col-12 col-sm-4">\n                                                    <input class="form-control" type="text" v-model="recordForm.prefix" name="prefix" :placeholder="trans(\'student.admission_number_prefix\')">\n                                                </div>\n                                                <div class="col-12 col-sm-8">\n                                                    <input class="form-control" type="text" v-model="recordForm.number" name="number" :placeholder="trans(\'student.admission_number\')">\n                                                </div>\n                                            </div>\n                                            <show-error :form-name="recordForm" prop-name="number"></show-error>\n                                        </div>\n                                    </div>\n                                </div>\n\n                                <div class="card-footer text-right">\n                                    <button type="submit" class="btn btn-info waves-effect waves-light">{{trans(\'general.save\')}}</button>\n                                </div>\n                            </form>\n                        </slot>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </transition>\n</template>\n\n<script>\n    export default {\n        components: {},\n        props: [\'student\',\'record\'],\n        data(){\n            return {\n                recordForm: new Form({\n                    batch_id: \'\',\n                    date_of_entry: \'\',\n                    number: \'\',\n                    prefix: \'\'\n                },false),\n                batches: [],\n                selected_batch: null,\n            }\n        },\n        mounted(){\n            if(!helper.hasPermission(\'edit-student\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n            this.getPreRequisite();\n        },\n        methods: {\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/student/record/pre-requisite\')\n                    .then(response => {\n                        this.batches = response.batches;\n                        this.selected_batch = {id: this.record.batch_id, name: this.record.batch.course.name+\' \'+this.record.batch.name};\n                        this.recordForm.batch_id = this.record.batch_id;\n                        this.recordForm.date_of_entry = this.record.date_of_entry;\n                        this.recordForm.number = this.record.admission.number;\n                        this.recordForm.prefix = this.record.admission.prefix;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            complete(){\n                this.$emit(\'completed\');\n                this.$emit(\'close\');\n            },\n            onBatchSelect(selectedOption){\n                this.recordForm.batch_id = selectedOption.id;\n                loader.hide();\n            },\n            onBatchRemove(removedOption){\n                this.recordForm.batch_id = \'\';\n            },\n            submit(){\n                let loader = this.$loading.show();\n                this.recordForm.patch(\'/api/student/\'+this.student.uuid+\'/record/\'+this.record.id)\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.$emit(\'completed\');\n                        this.$emit(\'close\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n        }\n    }\n<\/script>\n\n<style>\n    .loading-overlay{\n        z-index: 1060;\n    }\n</style>'],sourceRoot:""}]);const r=o},2817:(t,e,n)=>{"use strict";n.d(e,{Z:()=>r});var a=n(94015),s=n.n(a),i=n(23645),o=n.n(i)()(s());o.push([t.id,".avatar{max-height:150px;max-width:150px}","",{version:3,sources:["webpack://./resources/js/views/student/parent/detail.vue"],names:[],mappings:"AA4JA,QACA,gBAAA,CACA,eACA",sourcesContent:['<template>\n\t<div>\n        <div class="row mb-4">\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'general.relation\')" :value="student.parent.first_guardian_relation" :to-uppercase-word="true" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'general.relation\')" :value="student.parent.second_guardian_relation" :to-uppercase-word="true" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.first_guardian_name\')" :value="student.parent.first_guardian_name" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.second_guardian_name\')" :value="student.parent.second_guardian_name" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.first_guardian_date_of_birth\')" :value="student.parent.first_guardian_date_of_birth" type="date" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.second_guardian_date_of_birth\')" :value="student.parent.second_guardian_date_of_birth" type="date" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.first_guardian_qualification\')" :value="student.parent.first_guardian_qualification" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.second_guardian_qualification\')" :value="student.parent.second_guardian_qualification" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.first_guardian_occupation\')" :value="student.parent.first_guardian_occupation" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.second_guardian_occupation\')" :value="student.parent.second_guardian_occupation" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.first_guardian_annual_income\')" :value="student.parent.first_guardian_annual_income" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.second_guardian_annual_income\')" :value="student.parent.second_guardian_annual_income" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.first_guardian_email\')" :value="student.parent.first_guardian_email" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.second_guardian_email\')" :value="student.parent.second_guardian_email" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.first_guardian_contact_number_1\')" :value="student.parent.first_guardian_contact_number_1" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.second_guardian_contact_number_1\')" :value="student.parent.second_guardian_contact_number_1" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.first_guardian_contact_number_2\')" :value="student.parent.first_guardian_contact_number_2" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.second_guardian_contact_number_2\')" :value="student.parent.second_guardian_contact_number_2" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.first_guardian_unique_identification_number\')" :value="student.parent.first_guardian_unique_identification_number" />\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<view-label :label="trans(\'student.second_guardian_unique_identification_number\')" :value="student.parent.second_guardian_unique_identification_number" />\n            </div>\n            <div class="col-12 col-sm-6">\n                <span class="align-items-center student-thumb">\n                    <template v-if="!student.parent.first_guardian_photo">\n                        <img v-if="student.parent.first_guardian_relation == \'father\' || (student.gender == \'female\' && student.parent.first_guardian_relation == \'spouse\')" src="/images/avatar_male.png" class="img-circle avatar">\n                        <img v-else-if="student.parent.first_guardian_relation == \'mother\' || (student.gender == \'male\' && student.parent.first_guardian_relation == \'spouse\')" src="/images/avatar_female.png" class="img-circle avatar">\n                        <img v-else src="/images/avatar_male.png" class="img-circle avatar">\n                    </template>\n                    <template v-else>\n                        <img :src="`/${student.parent.first_guardian_photo}`" class="img-circle avatar">\n                    </template>\n                </span>\n            </div>\n            <div class="col-12 col-sm-6">\n                <span class="align-items-center student-thumb">\n                    <template v-if="!student.parent.second_guardian_photo">\n                        <img v-if="student.parent.second_guardian_relation == \'father\' || (student.gender == \'female\' && student.parent.second_guardian_relation == \'spouse\')" src="/images/avatar_male.png" class="img-circle avatar">\n                        <img v-else-if="student.parent.second_guardian_relation == \'mother\' || (student.gender == \'male\' && student.parent.second_guardian_relation == \'spouse\')" src="/images/avatar_female.png" class="img-circle avatar">\n                        <img v-else src="/images/avatar_male.png" class="img-circle avatar">\n                    </template>\n                    <template v-else>\n                        <img :src="`/${student.parent.second_guardian_photo}`" class="img-circle avatar">\n                    </template>\n                </span>\n            </div>\n\n            \x3c!--<div class="col-12 col-sm-6">\n            \t<upload-image id="first_guardian_photo" :upload-path="`/student/first-guardian/photo/${student.uuid}`" :remove-path="`/student/first-guardian/photo/remove/${student.uuid}`" :image-source="first_guardian_photo" @uploaded="updateFirstGuardian" @removed="updateFirstGuardian"></upload-image>\n            </div>\n            <div class="col-12 col-sm-6">\n            \t<upload-image id="second_guardian_photo" :upload-path="`/student/second-guardian/photo/${student.uuid}`" :remove-path="`/student/second-guardian/photo/remove/${student.uuid}`" :image-source="second_guardian_photo" @uploaded="updateSecondGuardian" @removed="updateSecondGuardian"></upload-image>\n            </div> --\x3e\n        </div>\n\n\t\t<hr v-if="custom_fields.length" />\n\t\t<view-custom-field :fields="custom_fields" :customValues="custom_values"></view-custom-field>\n\t</div>\n</template>\n\n<script>\n\texport default {\n\t\tcomponents: {},\n\t\tprops: {\n\t\t\tstudent: {\n\t\t\t\ttype: Object,\n\t\t\t\tdefault() {\n\t\t\t\t\treturn {\n\t\t\t\t\t\tparent: {}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\tdata() {\n\t\t\treturn {\n                custom_fields: [],\n                custom_values: []\n\t\t\t}\n\t\t},\n\t\tmounted(){\n            if(!helper.hasPermission(\'list-student\') && !helper.hasPermission(\'list-class-teacher-wise-student\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getParents();\n\t\t},\n\t\tmethods: {\n\t\t\tgetParents(){\n\t\t\t\tlet loader = this.$loading.show();\n\t\t\t\taxios.get(\'/api/student/pre-requisite?form_type=student_parent\')\n\t\t\t\t\t.then(response => {\n\t\t\t\t\t\tthis.custom_fields = response.custom_fields;\n\t\t\t\t\t\tthis.get(this.student);\n\t\t\t\t\t\tloader.hide();\n\t\t\t\t\t})\n\t\t\t\t\t.catch(error => {\n\t\t\t\t\t\tloader.hide();\n\t\t\t\t\t\thelper.showErrorMsg(error);\n\t\t\t\t\t})\n\t\t\t},\n\t\t\tget(student){\n\t\t\t\tlet parent = student.parent;\n\t\t        this.custom_values = parent && parent.options && parent.options.hasOwnProperty(\'custom_values\') ? parent.options.custom_values : [];\n\t          }\n\t\t},\n\t\twatch: { \n      \t\tstudent(student) {\n      \t\t\tthis.get(student);\n\t        }\n\t    }\n\t}\n<\/script>\n\n<style>\n\t.avatar {\n\t\tmax-height: 150px;\n\t\tmax-width: 150px;\n\t}\n</style>'],sourceRoot:""}]);const r=o},4146:(t,e,n)=>{"use strict";n.d(e,{Z:()=>r});var a=n(94015),s=n.n(a),i=n(23645),o=n.n(i)()(s());o.push([t.id,".loading-overlay{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/student/qualification/create.vue"],names:[],mappings:"AAsCA,iBACA,YACA",sourcesContent:['<template>\n    <transition name="modal">\n        <div class="modal-mask">\n            <div class="modal-wrapper">\n                <div class="modal-container modal-lg">\n                    <div class="modal-header">\n                        <slot name="header">\n                            {{trans(\'student.add_new_qualification\')}}\n                            <span class="float-right pointer" @click="$emit(\'close\')">x</span>\n                        </slot>\n                    </div>\n                    <div class="modal-body">\n                        <slot name="body">\n                            <qualification-form :uuid="student.uuid" @completed="complete"></qualification-form>\n                        </slot>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </transition>\n</template>\n\n<script>\n    import qualificationForm from \'./form\'\n\n    export default {\n        components: {qualificationForm},\n        props: [\'student\'],\n        methods:{\n            complete(){\n                this.$emit(\'completed\');\n                this.$emit(\'close\');\n            }\n        }\n    }\n<\/script>\n\n<style>\n    .loading-overlay{\n        z-index: 1060;\n    }\n</style>'],sourceRoot:""}]);const r=o},19183:(t,e,n)=>{"use strict";n.d(e,{Z:()=>r});var a=n(94015),s=n.n(a),i=n(23645),o=n.n(i)()(s());o.push([t.id,".loading-overlay{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/student/qualification/edit.vue"],names:[],mappings:"AAsCA,iBACA,YACA",sourcesContent:['<template>\n    <transition name="modal">\n        <div class="modal-mask">\n            <div class="modal-wrapper">\n                <div class="modal-container modal-lg">\n                    <div class="modal-header">\n                        <slot name="header">\n                            {{trans(\'student.edit_qualification\')}}\n                            <span class="float-right pointer" @click="$emit(\'close\')">x</span>\n                        </slot>\n                    </div>\n                    <div class="modal-body">\n                        <slot name="body">\n                            <qualification-form :uuid="student.uuid" :qid="qid" @completed="complete"></qualification-form>\n                        </slot>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </transition>\n</template>\n\n<script>\n    import qualificationForm from \'./form\'\n\n    export default {\n        components: {qualificationForm},\n        props: [\'student\',\'qid\'],\n        methods: {\n            complete(){\n                this.$emit(\'completed\');\n                this.$emit(\'close\');\n            }\n        }\n    }\n<\/script>\n\n<style>\n    .loading-overlay{\n        z-index: 1060;\n    }\n</style>'],sourceRoot:""}]);const r=o},5035:(t,e,n)=>{"use strict";n.d(e,{Z:()=>r});var a=n(94015),s=n.n(a),i=n(23645),o=n.n(i)()(s());o.push([t.id,".img-circle{max-height:150px;max-width:150px}","",{version:3,sources:["webpack://./resources/js/views/student/show.vue"],names:[],mappings:"AAgXA,YACA,gBAAA,CACA,eACA",sourcesContent:['<template>\n    <div>\n        <div class="page-titles" v-if="student.id">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                    <h3 class="text-themecolor">{{trans(\'student.student_detail\')}}\n                        <span class="card-subtitle">{{getStudentName(student)}}</span>\n                    </h3>\n                </div>\n                <div class="col-12 col-sm-6">\n                    <div class="action-buttons pull-right">\n                        <router-link to="/student/card-view" class="btn btn-info btn-sm"><i class="fas fa-list"></i> <span class="d-none d-sm-inline">{{trans(\'student.student\')}}</span></router-link>\n                        <router-link v-if="hasPermission(\'edit-student\')" :to="`/student/${student.uuid}/edit`" class="btn btn-info btn-sm"><i class="fas fa-pencil-alt"></i> <span class="d-none d-sm-inline">{{trans(\'student.edit_student\')}}</span></router-link>\n                        <div class="btn-group" v-if="student.student_records.length">\n                            <button type="button" class="btn btn-info btn-sm dropdown-toggle no-caret " role="menu" id="moreOption" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-tooltip="trans(\'general.more_option\')">\n                                <i class="fas fa-ellipsis-h"></i> <span class="d-none d-sm-inline"></span>\n                            </button>\n                            <div :class="[\'dropdown-menu\',getConfig(\'direction\') == \'ltr\' ? \'dropdown-menu-right\' : \'\']" aria-labelledby="moreOption">\n                                <button v-for="student_record in student.student_records" class="dropdown-item custom-dropdown" @click="$router.push(\'/student/\'+student.uuid+\'/fee/\'+student_record.id)"><i class="fas fa-file"></i> {{student_record.batch.course.name}} {{trans(\'finance.fee_allocation\')}}</button>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="container-fluid">\n            <div class="row">\n                <div class="col-12 col-sm-8 p-0">\n                    <div class="card">\n                        <div class="card-body">\n                            <div id="accordion" class="accordion" v-if="student.id">\n                                <div class="card" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="basic" @click="tab = \'basic\'" data-toggle="collapse" data-target="#collapseBasic" aria-expanded="false" aria-controls="collapseBasic">\n                                       <h5><i class="fas fa-lg fa-graduation-cap fa-fix-w-32"></i> {{trans(\'student.basic_information\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseBasic" class="collapse" aria-labelledby="basic" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <basic-detail :student="student" v-if="tab == \'basic\'"></basic-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="parent" @click="tab = \'parent\'" data-toggle="collapse" data-target="#collapseParent" aria-expanded="false" aria-controls="collapseParent">\n                                        <h5><i class="fas fa-lg fa-users fa-fix-w-32"></i> {{trans(\'student.parent_information\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseParent" class="collapse" aria-labelledby="parent" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <parent-detail :student="student" v-if="tab == \'parent\'"></parent-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="contact" @click="tab = \'contact\'" data-toggle="collapse" data-target="#collapseContact" aria-expanded="false" aria-controls="collapseContact">\n                                        <h5><i class="fas fa-lg fa-address-book fa-fix-w-32"></i> {{trans(\'student.contact_information\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseContact" class="collapse" aria-labelledby="contact" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <contact-detail :student="student" v-if="tab == \'contact\'"></contact-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="document" @click="tab = \'document\'" data-toggle="collapse" data-target="#collapseDocument" aria-expanded="false" aria-controls="collapseDocument">\n                                        <h5><i class="fas fa-lg fa-folder fa-fix-w-32"></i> {{trans(\'student.document_information\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseDocument" class="collapse" aria-labelledby="document" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <document-detail :read-mode="true" :student="student" v-if="tab == \'document\'"></document-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="qualification" @click="tab = \'qualification\'" data-toggle="collapse" data-target="#collapseQualification" aria-expanded="false" aria-controls="collapseQualification">\n                                        <h5><i class="fas fa-lg fa-book fa-fix-w-32"></i> {{trans(\'student.qualification_information\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseQualification" class="collapse" aria-labelledby="qualification" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <qualification-detail :read-mode="true" :student="student" v-if="tab == \'qualification\'"></qualification-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="sibling" @click="tab = \'sibling\'" data-toggle="collapse" data-target="#collapseSibling" aria-expanded="false" aria-controls="collapseSibling">\n                                        <h5><i class="fas fa-lg fa-people-carry fa-fix-w-32"></i> {{trans(\'student.sibling_information\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseSibling" class="collapse" aria-labelledby="sibling" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <sibling-detail :read-mode="true" :student="student" v-if="tab == \'sibling\'"></sibling-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="account" @click="tab = \'account\'" data-toggle="collapse" data-target="#collapseAccount" aria-expanded="false" aria-controls="collapseAccount">\n                                        <h5><i class="fas fa-lg fa-university fa-fix-w-32"></i> {{trans(\'student.account_information\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseAccount" class="collapse" aria-labelledby="account" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <account-detail :read-mode="true" :student="student" v-if="tab == \'account\'"></account-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" v-if="student.student_records.length" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="login" @click="tab = \'login\'" data-toggle="collapse" data-target="#collapseUserLogin" aria-expanded="false" aria-controls="collapseUserLogin">\n                                        <h5><i class="fas fa-lg fa-sign-in-alt fa-fix-w-32"></i> {{trans(\'auth.user_login\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseUserLogin" class="collapse" aria-labelledby="login" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <login-detail :student="student" v-if="tab == \'login\'"></login-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" v-if="student.student_records.length && hasPermission(\'list-student-fee\')" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="fee" @click="tab = \'fee\'" data-toggle="collapse" data-target="#collapseFee" aria-expanded="false" aria-controls="collapseFee">\n                                        <h5><i class="fas fa-lg fa-coins fa-fix-w-32"></i> {{trans(\'student.fee_history\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseFee" class="collapse" aria-labelledby="fee" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <fee-detail :read-mode="true" :student="student" v-if="tab == \'fee\'"></fee-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" v-if="student.student_records.length" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="attendance" @click="tab = \'attendance\'" data-toggle="collapse" data-target="#collapseAttendance" aria-expanded="false" aria-controls="collapseAttendance">\n                                        <h5><i class="fas fa-lg fa-tasks fa-fix-w-32"></i> {{trans(\'student.attendance_history\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseAttendance" class="collapse" aria-labelledby="attendance" data-parent="#accordion">\n                                        <div style="padding: 1.5rem 1.5rem 0 2.5rem;">\n                                            <attendance-detail :student="student" v-if="tab == \'attendance\'"></attendance-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" v-if="student.student_records.length" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="exam" @click="tab = \'exam\'" data-toggle="collapse" data-target="#collapseExam" aria-expanded="false" aria-controls="collapseExam">\n                                        <h5><i class="fas fa-lg fa-file-alt fa-fix-w-32"></i> {{trans(\'exam.exam_report\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseExam" class="collapse" aria-labelledby="exam" data-parent="#accordion">\n                                        <div style="padding: 1.5rem 1.5rem 0 2.5rem;">\n                                            <exam-report :student="student" v-if="tab == \'exam\'"></exam-report>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" v-if="student.student_records.length" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="promotion" @click="tab = \'promotion\'" data-toggle="collapse" data-target="#collapsePromotion" aria-expanded="false" aria-controls="collapsePromotion">\n                                        <h5><i class="fas fa-lg fa-chart-line fa-fix-w-32"></i> {{trans(\'student.promotion_history\')}}</h5>\n                                    </div>\n\n                                    <div id="collapsePromotion" class="collapse" aria-labelledby="promotion" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <promotion-detail :read-mode="true" :student="student" v-if="tab == \'promotion\'"></promotion-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class="card" v-if="student.student_records.length" style="overflow: visible;">\n                                    <div class="card-header collapsed" id="termination" @click="tab = \'termination\'" data-toggle="collapse" data-target="#collapseTermination" aria-expanded="false" aria-controls="collapseTermination">\n                                        <h5><i class="fas fa-lg fa-sign-out-alt fa-fix-w-32"></i> {{trans(\'student.termination_history\')}}</h5>\n                                    </div>\n\n                                    <div id="collapseTermination" class="collapse" aria-labelledby="termination" data-parent="#accordion">\n                                        <div class="card-body">\n                                            <termination-detail :read-mode="true" :student="student" v-if="tab == \'termination\'"></termination-detail>\n                                        </div>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-4 hidden-sm-down p-0 border-left">\n                    <div class="card">\n                        <div class="card-body p-r-20">\n                            <div class="m-3 text-center">\n                                <span>\n                                    <template v-if="!student.student_photo">\n                                        <img v-if="student.gender == \'female\'" src="/images/avatar_female_kid.png" class="img-circle">\n                                        <img v-else src="/images/avatar_male_kid.png" class="img-circle">\n                                    </template>\n                                    <template v-else>\n                                        <img :src="`/${student.student_photo}`" class="img-circle">\n                                    </template>\n                                </span>\n                            </div>\n                            <div class="table-responsive" v-if="student.id">\n                                <table class="table table-sm custom-show-table">\n                                    <tbody>\n                                        <tr>\n                                            <td>{{trans(\'student.name\')}}</td>\n                                            <td>{{getStudentName(student)}}</td>\n                                        </tr>\n                                        <tr>\n                                            <td>{{trans(\'student.father_name\')}}</td>\n                                            <td>{{student.parent ? student.parent.father_name : \'\'}}</td>\n                                        </tr>\n                                        <tr>\n                                            <td>{{trans(\'student.mother_name\')}}</td>\n                                            <td>{{student.parent ? student.parent.mother_name : \'\'}}</td>\n                                        </tr>\n                                        <tr>\n                                            <td>{{trans(\'student.contact_number\')}}</td>\n                                            <td>{{student.contact_number}}</td>\n                                        </tr>\n                                        <tr>\n                                            <td>{{trans(\'student.gender\')}}</td>\n                                            <td>{{trans(\'list.\'+student.gender)}}</td>\n                                        </tr>\n                                        <tr>\n                                            <td>{{trans(\'student.date_of_birth\')}}</td>\n                                            <td>{{student.date_of_birth | moment}}</td>\n                                        </tr>\n                                    </tbody>\n                                </table>\n\n\n                                <table class="table table-sm custom-show-table" v-for="student_record in currentStudentRecords">\n                                    <tbody>\n                                        <tr>\n                                            <td>{{trans(\'academic.batch\')}}</td>\n                                            <td><span v-html="getStatus(student_record)"></span> {{student_record.batch.course.name+\' \'+student_record.batch.name+\' \'+student_record.academic_session.name}}</td>\n                                        </tr>\n                                        <tr>\n                                            <td>{{trans(\'student.date_of_admission\')}}</td>\n                                            <td>{{student_record.admission.date_of_admission | moment}}</td>\n                                        </tr>\n                                        <tr>\n                                            <td>{{trans(\'student.admission_number\')}}</td>\n                                            <td>{{student_record.admission.admission_number}}</td>\n                                        </tr>\n                                        <tr>\n                                            <td>{{trans(\'student.date_of_promotion\')}}</td>\n                                            <td>{{student_record.date_of_entry | moment}}</td>\n                                        </tr>\n                                        <tr v-if="student_record.date_of_exit">\n                                            <td class="text-danger font-weight-bold">{{trans(\'student.date_of_termination\')}}</td>\n                                            <td class="text-danger font-weight-bold">{{student_record.date_of_exit | moment}}</td>\n                                        </tr>\n                                    </tbody>\n                                </table>\n\n                                <table class="table table-sm custom-show-table">\n                                    <tbody>\n                                        <tr>\n                                            <td>{{trans(\'general.created_at\')}}</td>\n                                            <td>{{student.created_at | momentDateTime}}</td>\n                                        </tr>\n                                        <tr>\n                                            <td>{{trans(\'general.updated_at\')}}</td>\n                                            <td>{{student.updated_at | momentDateTime}}</td>\n                                        </tr>\n                                    </tbody>\n                                </table>\n\n\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</template>\n\n<script>\n    import basicDetail from \'./basic/detail\'\n    import parentDetail from \'./parent/detail\'\n    import contactDetail from \'./contact/detail\'\n    import documentDetail from \'./document/index\'\n    import accountDetail from \'./account/index\'\n    import qualificationDetail from \'./qualification/index\'\n    import terminationDetail from \'./termination/detail\'\n    import promotionDetail from \'./promotion/detail\'\n    import feeDetail from \'./fee/detail\'\n    import attendanceDetail from \'./attendance/detail\'\n    import siblingDetail from \'./sibling/index\'\n    import loginDetail from \'./login/detail\'\n    import examReport from \'./exam-report\'\n\n    export default {\n        components : { basicDetail,parentDetail,contactDetail,documentDetail,accountDetail,qualificationDetail,terminationDetail,siblingDetail,promotionDetail,loginDetail,attendanceDetail,examReport,feeDetail },\n        data() {\n            return {\n                uuid:this.$route.params.uuid,\n                student: {},\n                photo: \'\',\n                tab: \'\'\n            }\n        },\n        mounted(){\n            if(!helper.hasPermission(\'list-student\') && !helper.hasPermission(\'list-class-teacher-wise-student\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getStudent();\n            helper.showDemoNotification([\'student\']);\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getConfig(config){\n                return helper.getConfig(config);\n            },\n            getStudent(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/student/\'+this.uuid)\n                    .then(response => {\n                        this.student = response;\n                        this.photo = this.student.student_photo;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/dashboard\');\n                    })\n            },\n            getStudentName(){\n                return helper.getStudentName(this.student);\n            },\n            updatePhoto(val){\n            },\n            getStatus(student_record){\n                if (! student_record)\n                    return \'<span class="badge badge-info lb-sm">\'+i18n.student.student_status_not_admitted+\'</span>\';\n                else if (student_record.date_of_exit)\n                    return \'<span class="badge badge-danger lb-sm">\'+i18n.student.student_status_not_terminated+\'</span>\';\n                else\n                    return \'<span class="badge badge-success lb-sm">\'+i18n.student.student_status_not_studying+\'</span>\';\n            },\n        },\n        computed: {\n            getDefaultAcademicSession(){\n                return helper.getDefaultAcademicSession();\n            },\n            currentStudentRecords() {\n                return this.student.student_records.filter(student_record => {\n                    return student_record.academic_session_id === helper.getDefaultAcademicSession().id\n                })\n            }\n        },\n        filters: {\n          moment(date) {\n            return helper.formatDate(date);\n          },\n          momentDateTime(date) {\n            return helper.formatDateTime(date);\n          }\n        },\n        watch: {\n            \'$route.params.uuid\': function (uuid) {\n                this.uuid = uuid;\n                this.getStudent()\n            }\n        }\n    }\n<\/script>\n\n<style>\n    .img-circle {\n        max-height: 150px;\n        max-width: 150px;\n    }\n</style>'],sourceRoot:""}]);const r=o},49153:(t,e,n)=>{"use strict";n.d(e,{Z:()=>r});var a=n(94015),s=n.n(a),i=n(23645),o=n.n(i)()(s());o.push([t.id,".dg-backdrop,.dg-container{z-index:10000}","",{version:3,sources:["webpack://./resources/js/views/student/sibling/index.vue"],names:[],mappings:"AAiHA,2BACA,aACA",sourcesContent:['<template>\n    <div>\n        <div class="table-responsive" v-if="students.length">\n            <table class="table table-sm">\n                <thead>\n                    <tr>\n                        <th>{{trans(\'student.admission_number_short\')}}</th>\n                        <th>{{trans(\'student.name\')}}</th>\n                        <th>{{trans(\'academic.batch\')}}</th>\n                    </tr>\n                </thead>\n                <tbody>\n                    <tr v-for="student in students">\n                        <td v-html="getAdmissionNumber(student)"></td>\n                        <td v-text="getStudentName(student)"></td>\n                        <td v-text="getBatch(student)"></td>\n                    </tr>\n                </tbody>\n            </table>\n        </div>\n        <template v-if="!readMode">\n            <module-info v-if="!students.length" module="student" title="account_module_title" description="account_module_description" icon="list">\n            </module-info>\n        </template>\n        <template v-else>\n            <div v-if="!students.length" class="font-80pc">{{trans(\'general.no_result_found\')}}</div>\n        </template>\n        <div>&nbsp;</div>\n    </div>\n</template>\n\n<script>\n    export default {\n        props: {\n            student: {\n                type: Object,\n                default() {\n                    return {}\n                }\n            },\n            readMode: {\n                type: Boolean,\n                default: false\n            }\n        },\n        components : {},\n        data() {\n            return {\n                students: []\n            };\n        },\n        mounted(){\n            if(!helper.hasPermission(\'list-student\') && !helper.hasPermission(\'list-class-teacher-wise-student\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getStudentSiblings();\n        },\n        methods: {\n            getStudentSiblings(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/student/\'+this.student.uuid+\'/sibling\')\n                    .then(response => {\n                        this.students = response.students;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            getStudentRecord(student){\n                let length = student.student_records.length;\n                return (length) ? student.student_records[length - 1] : null;\n            },\n            getAdmissionNumber(student){\n                let student_record = this.getStudentRecord(student);\n\n                if (! student_record)\n                    return \'<span class="label label-danger">\'+i18n.student.student_status_not_admitted+\'</span>\';\n\n                return helper.getAdmissionNumber(student_record.admission);\n            },\n            getStudentName(student){\n                return helper.getStudentName(student);\n            },\n            getBatch(student){\n                let student_record = this.getStudentRecord(student);\n\n                if (! student_record)\n                    return \'-\';\n\n                return student_record.batch.course.name+\' \'+student_record.batch.name;\n            }\n        },\n        filters: {\n          momentDateTime(date) {\n            return helper.formatDateTime(date);\n          }\n        },\n        watch: { \n            student(student) {\n                this.getStudentSiblings();\n            }\n        }\n    }\n<\/script>\n\n<style>\n    .dg-backdrop{\n      z-index: 10000;\n    }\n    .dg-container{\n      z-index: 10000;\n    }\n</style>'],sourceRoot:""}]);const r=o},35050:(t,e,n)=>{"use strict";n.d(e,{Z:()=>b});const a={components:{},data:function(){return{accountForm:new Form({name:"",account_number:"",bank_name:"",branch_name:"",bank_identification_code:"",is_primary:!1,description:""}),clearAttachment:!0}},props:["uuid","aid"],mounted:function(){this.aid&&this.getAccount()},methods:{proceed:function(){this.aid?this.updateAccount():this.storeAccount()},storeAccount:function(){var t=this,e=this.$loading.show();this.accountForm.post("/api/student/"+this.uuid+"/account").then((function(n){toastr.success(n.message),t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},getAccount:function(){var t=this,e=this.$loading.show();axios.get("/api/student/"+this.uuid+"/account/"+this.aid).then((function(n){t.accountForm.name=n.name,t.accountForm.account_number=n.account_number,t.accountForm.bank_name=n.bank_name,t.accountForm.branch_name=n.branch_name,t.accountForm.bank_identification_code=n.bank_identification_code,t.accountForm.is_primary=n.options.is_primary,t.accountForm.description=n.description,t.$emit("loaded"),e.hide()})).catch((function(n){e.hide(),t.$router.push("/student/"+t.uuid)}))},updateAccount:function(){var t=this,e=this.$loading.show();this.accountForm.patch("/api/student/"+this.uuid+"/account/"+this.aid).then((function(n){toastr.success(n.message),t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}}};var s=n(51900);const i=(0,s.Z)(a,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[n("form",{on:{submit:function(e){return e.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(e){return t.accountForm.errors.clear(e.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.account_name")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.accountForm.name,expression:"accountForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:t.trans("student.account_name")},domProps:{value:t.accountForm.name},on:{input:function(e){e.target.composing||t.$set(t.accountForm,"name",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.accountForm,"prop-name":"name"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.account_number")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.accountForm.account_number,expression:"accountForm.account_number"}],staticClass:"form-control",attrs:{type:"text",name:"account_number",placeholder:t.trans("student.account_number")},domProps:{value:t.accountForm.account_number},on:{input:function(e){e.target.composing||t.$set(t.accountForm,"account_number",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.accountForm,"prop-name":"account_number"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.bank_name")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.accountForm.bank_name,expression:"accountForm.bank_name"}],staticClass:"form-control",attrs:{type:"text",name:"bank_name",placeholder:t.trans("student.bank_name")},domProps:{value:t.accountForm.bank_name},on:{input:function(e){e.target.composing||t.$set(t.accountForm,"bank_name",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.accountForm,"prop-name":"bank_name"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.branch_name")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.accountForm.branch_name,expression:"accountForm.branch_name"}],staticClass:"form-control",attrs:{type:"text",name:"branch_name",placeholder:t.trans("student.branch_name")},domProps:{value:t.accountForm.branch_name},on:{input:function(e){e.target.composing||t.$set(t.accountForm,"branch_name",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.accountForm,"prop-name":"branch_name"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.bank_identification_code")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.accountForm.bank_identification_code,expression:"accountForm.bank_identification_code"}],staticClass:"form-control",attrs:{type:"text",name:"bank_identification_code",placeholder:t.trans("student.bank_identification_code")},domProps:{value:t.accountForm.bank_identification_code},on:{input:function(e){e.target.composing||t.$set(t.accountForm,"bank_identification_code",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.accountForm,"prop-name":"bank_identification_code"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("switches",{staticClass:"m-l-20",attrs:{theme:"bootstrap",color:"success"},model:{value:t.accountForm.is_primary,callback:function(e){t.$set(t.accountForm,"is_primary",e)},expression:"accountForm.is_primary"}}),t._v(" "+t._s(t.trans("student.is_account_primary"))+"\n                    ")],1)])]),t._v(" "),n("div",{staticClass:"form-group"},[n("autosize-textarea",{attrs:{rows:"2",name:"description",placeholder:t.trans("student.account_description")},model:{value:t.accountForm.description,callback:function(e){t.$set(t.accountForm,"description",e)},expression:"accountForm.description"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.accountForm,"prop-name":"description"}})],1),t._v(" "),n("button",{staticClass:"btn btn-info waves-effect waves-light pull-right",attrs:{type:"submit"}},[t.aid?n("span",[t._v(t._s(t.trans("general.update")))]):n("span",[t._v(t._s(t.trans("general.save")))])])]),t._v(" "),n("div",{staticClass:"clearfix"})])}),[],!1,null,null,null).exports,o={components:{accountForm:i},props:["student"],methods:{complete:function(){this.$emit("completed"),this.$emit("close")}}};var r=n(93379),d=n.n(r),l=n(35593),c={insert:"head",singleton:!1};d()(l.Z,c);l.Z.locals;const u=(0,s.Z)(o,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                        "+t._s(t.trans("student.add_new_account"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("account-form",{attrs:{uuid:t.student.uuid},on:{completed:t.complete}})]}))],2)])])])])}),[],!1,null,null,null).exports;const m={components:{accountForm:i},props:["student","aid"],methods:{complete:function(){this.$emit("completed"),this.$emit("close")}}};var _=n(30941),p={insert:"head",singleton:!1};d()(_.Z,p);_.Z.locals;const v=(0,s.Z)(m,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                        "+t._s(t.trans("student.edit_account"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("account-form",{attrs:{uuid:t.student.uuid,aid:t.aid},on:{completed:t.complete}})]}))],2)])])])])}),[],!1,null,null,null).exports;const f={components:{accountForm:i},props:["student","aid"],mounted:function(){this.aid&&this.getStudentAccount()},data:function(){return{student_account:{}}},methods:{getStudentAccount:function(){var t=this,e=this.$loading.show();axios.get("/api/student/"+this.student.uuid+"/account/"+this.aid).then((function(n){t.student_account=n,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}},filters:{momentDateTime:function(t){return helper.formatDateTime(t)}}};const h=(0,s.Z)(f,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                        "+t._s(t.trans("student.view_account"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm custom-show-table"},[n("tbody",[n("tr",[n("td",[t._v(t._s(t.trans("student.account_name")))]),t._v(" "),n("td",[t._v(t._s(t.student_account.name)+"\n                                            "),t.student_account.options&&t.student_account.options.is_primary?n("span",{staticClass:"label label-info"},[t._v(t._s(t.trans("student.account_primary")))]):t._e()])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.account_number")))]),t._v(" "),n("td",[t._v(t._s(t.student_account.account_number))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.bank_name")))]),t._v(" "),n("td",[t._v(t._s(t.student_account.bank_name))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.branch_name")))]),t._v(" "),n("td",[t._v(t._s(t.student_account.branch_name))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.bank_identification_code")))]),t._v(" "),n("td",[t._v(t._s(t.student_account.bank_identification_code))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.account_description")))]),t._v(" "),n("td",[t._v(t._s(t.student_account.description))])])])])]),t._v(" "),n("p",[n("i",{staticClass:"far fa-clock"}),t._v(" "),n("small",[t._v(t._s(t.trans("general.created_at"))+" "+t._s(t._f("momentDateTime")(t.student_account.created_at)))]),t._v(" "),n("span",{staticClass:"pull-right"},[n("i",{staticClass:"far fa-clock"}),t._v(" "),n("small",[t._v(t._s(t.trans("general.updated_at"))+" "+t._s(t._f("momentDateTime")(t.student_account.updated_at)))])])])]}))],2)])])])])}),[],!1,null,null,null).exports,g={props:{student:{type:Object,default:function(){return{}}},readMode:{type:Boolean,default:!1}},components:{createAccount:u,editAccount:v,showAccount:h},data:function(){return{student_accounts:{total:0,data:[]},showId:null,editId:null,student_account:{},filter:{page_length:helper.getConfig("page_length")},addModal:!1,editModal:!1,showModal:!1}},mounted:function(){(this.readMode&&!helper.hasPermission("list-student")&&!helper.hasPermission("list-class-teacher-wise-student")||!this.readMode&&!helper.hasPermission("edit-student"))&&(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getStudentAccounts()},methods:{getStudentName:function(){return helper.getStudentName(this.student)},showAction:function(t){this.showId=t.id,this.showModal=!0},editAction:function(t){this.editId=t.id,this.editModal=!0},getStudentAccounts:function(t){var e=this,n=this.$loading.show();"number"!=typeof t&&(t=1);var a=helper.getFilterURL(this.filter);axios.get("/api/student/"+this.student.uuid+"/account?page="+t+a).then((function(t){e.student_accounts=t,n.hide()})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))},confirmDelete:function(t){var e=this;return function(n){return e.deleteStudentAccount(t)}},deleteStudentAccount:function(t){var e=this,n=this.$loading.show();axios.delete("/api/student/"+this.student.uuid+"/account/"+t.id).then((function(t){toastr.success(t.message),e.getStudentAccounts(),n.hide()})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))}},filters:{momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{student:function(t){this.getStudentAccounts()}}};const b=(0,s.Z)(g,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[t.readMode?t._e():n("button",{staticClass:"btn btn-sm btn-info pull-right",on:{click:function(e){t.addModal=!0}}},[n("i",{staticClass:"fas fa-plus"}),t._v(" "+t._s(t.trans("student.add_new_account")))]),t._v(" "),t.student_accounts.total?n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm"},[n("thead",[n("tr",[n("th",[t._v(t._s(t.trans("student.account_name")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.account_number")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.bank_name")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.is_account_primary")))]),t._v(" "),n("th",{staticClass:"table-option"},[t._v(t._s(t.trans("general.action")))])])]),t._v(" "),n("tbody",t._l(t.student_accounts.data,(function(e){return n("tr",[n("td",{domProps:{textContent:t._s(e.name)}}),t._v(" "),n("td",{domProps:{textContent:t._s(e.account_number)}}),t._v(" "),n("td",{domProps:{textContent:t._s(e.bank_name)}}),t._v(" "),n("td",[e.options.is_primary?n("i",{staticClass:"fas fa-check"}):n("i",{staticClass:"fas fa-times"})]),t._v(" "),n("td",{staticClass:"table-option"},[n("div",{staticClass:"btn-group"},[n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.view_account"),expression:"trans('student.view_account')"}],staticClass:"btn btn-success btn-sm",on:{click:function(n){return n.preventDefault(),t.showAction(e)}}},[n("i",{staticClass:"fas fa-arrow-circle-right"})]),t._v(" "),t.readMode?t._e():n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.edit_account"),expression:"trans('student.edit_account')"}],staticClass:"btn btn-info btn-sm",on:{click:function(n){return n.preventDefault(),t.editAction(e)}}},[n("i",{staticClass:"fas fa-edit"})]),t._v(" "),t.readMode?t._e():n("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:t.confirmDelete(e)},expression:"{ok: confirmDelete(student_account)}"},{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.delete_account"),expression:"trans('student.delete_account')"}],key:e.id,staticClass:"btn btn-danger btn-sm"},[n("i",{staticClass:"fas fa-trash"})])])])])})),0)])]):t._e(),t._v(" "),t.readMode?[t.student_accounts.total?t._e():n("div",{staticClass:"font-80pc"},[t._v(t._s(t.trans("general.no_result_found")))])]:[t.student_accounts.total?t._e():n("module-info",{attrs:{module:"student",title:"account_module_title",description:"account_module_description",icon:"list"}},[n("div",{attrs:{slot:"btn"},slot:"btn"},[n("button",{staticClass:"btn btn-info btn-md",on:{click:function(e){t.addModal=!0}}},[n("i",{staticClass:"fas fa-plus"}),t._v(" "+t._s(t.trans("general.add_new")))])])])],t._v(" "),n("pagination-record",{attrs:{"page-length":t.filter.page_length,records:t.student_accounts},on:{"update:pageLength":function(e){return t.$set(t.filter,"page_length",e)},"update:page-length":function(e){return t.$set(t.filter,"page_length",e)},updateRecords:t.getStudentAccounts},nativeOn:{change:function(e){return t.getStudentAccounts.apply(null,arguments)}}}),t._v(" "),t.addModal&&!t.readMode?n("create-account",{attrs:{student:t.student},on:{close:function(e){t.addModal=!1},completed:t.getStudentAccounts}}):t._e(),t._v(" "),t.editModal&&!t.readMode?n("edit-account",{attrs:{student:t.student,aid:t.editId},on:{close:function(e){t.editModal=!1},completed:t.getStudentAccounts}}):t._e(),t._v(" "),t.showModal?n("show-account",{attrs:{student:t.student,aid:t.showId},on:{close:function(e){t.showModal=!1}}}):t._e()],2)}),[],!1,null,null,null).exports},85808:(t,e,n)=>{"use strict";n.d(e,{Z:()=>b});const a={components:{},data:function(){return{documentForm:new Form({title:"",student_document_type_id:"",description:"",upload_token:""}),selected_student_document_type:null,student_document_types:[],module_id:"",clearAttachment:!0}},props:["uuid","did"],mounted:function(){this.documentForm.upload_token=this.$uuid.v4(),this.getPreRequisite(),this.did&&this.getDocument()},methods:{proceed:function(){this.did?this.updateDocument():this.storeDocument()},getPreRequisite:function(){var t=this,e=this.$loading.show();axios.get("/api/student/"+this.uuid+"/document/pre-requisite").then((function(n){t.student_document_types=n,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},storeDocument:function(){var t=this,e=this.$loading.show();this.documentForm.post("/api/student/"+this.uuid+"/document").then((function(n){toastr.success(n.message),t.clearAttachment=!t.clearAttachment,t.$emit("completed"),t.documentForm.upload_token=t.$uuid.v4(),t.selected_student_document_type=null,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},getDocument:function(){var t=this,e=this.$loading.show();axios.get("/api/student/"+this.uuid+"/document/"+this.did).then((function(n){t.documentForm.title=n.student_document.title,t.documentForm.student_document_type_id=n.student_document.student_document_type_id,t.selected_student_document_type={id:n.student_document.student_document_type_id,name:n.student_document.student_document_type.name},t.documentForm.description=n.student_document.description,t.documentForm.upload_token=n.student_document.upload_token,t.module_id=n.student_document.id,t.$emit("loaded"),e.hide()})).catch((function(n){e.hide(),t.$router.push("/student/"+t.uuid)}))},updateDocument:function(){var t=this,e=this.$loading.show();this.documentForm.patch("/api/student/"+this.uuid+"/document/"+this.did).then((function(n){toastr.success(n.message),t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},onDocumentTypeSelect:function(t){this.documentForm.student_document_type_id=t.id}}};var s=n(51900);const i=(0,s.Z)(a,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[n("form",{on:{submit:function(e){return e.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(e){return t.documentForm.errors.clear(e.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.document_title")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.documentForm.title,expression:"documentForm.title"}],staticClass:"form-control",attrs:{type:"text",name:"title",placeholder:t.trans("student.document_title")},domProps:{value:t.documentForm.title},on:{input:function(e){e.target.composing||t.$set(t.documentForm,"title",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.documentForm,"prop-name":"title"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.document_type")))]),t._v(" "),n("v-select",{attrs:{label:"name",name:"student_document_type_id",id:"student_document_type_id",options:t.student_document_types,placeholder:t.trans("general.select_one")},on:{select:t.onDocumentTypeSelect,close:function(e){return t.documentForm.errors.clear("student_document_type_id")},remove:function(e){t.documentForm.student_document_type_id=""}},model:{value:t.selected_student_document_type,callback:function(e){t.selected_student_document_type=e},expression:"selected_student_document_type"}},[t.student_document_types.length?t._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[t._v("\n                                "+t._s(t.trans("general.no_option_found"))+"\n                            ")])]),t._v(" "),n("show-error",{attrs:{"form-name":t.documentForm,"prop-name":"student_document_type_id"}})],1)])]),t._v(" "),n("div",{staticClass:"form-group"},[n("autosize-textarea",{attrs:{rows:"2",name:"description",placeholder:t.trans("student.document_description")},model:{value:t.documentForm.description,callback:function(e){t.$set(t.documentForm,"description",e)},expression:"documentForm.description"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.documentForm,"prop-name":"description"}})],1),t._v(" "),n("div",{staticClass:"form-group"},[n("file-upload-input",{attrs:{"button-text":t.trans("general.upload_document"),token:t.documentForm.upload_token,module:"student_document","clear-file":t.clearAttachment,"module-id":t.module_id}})],1),t._v(" "),n("button",{staticClass:"btn btn-info waves-effect waves-light pull-right",attrs:{type:"submit"}},[t.did?n("span",[t._v(t._s(t.trans("general.update")))]):n("span",[t._v(t._s(t.trans("general.save")))])])]),t._v(" "),n("div",{staticClass:"clearfix"})])}),[],!1,null,null,null).exports,o={components:{documentForm:i},props:["student"],methods:{complete:function(){this.$emit("completed"),this.$emit("close")}}};var r=n(93379),d=n.n(r),l=n(59188),c={insert:"head",singleton:!1};d()(l.Z,c);l.Z.locals;const u=(0,s.Z)(o,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                        "+t._s(t.trans("student.add_new_document"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("document-form",{attrs:{uuid:t.student.uuid},on:{completed:t.complete}})]}))],2)])])])])}),[],!1,null,null,null).exports;const m={components:{documentForm:i},props:["student","did"],methods:{complete:function(){this.$emit("completed"),this.$emit("close")}}};var _=n(49512),p={insert:"head",singleton:!1};d()(_.Z,p);_.Z.locals;const v=(0,s.Z)(m,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                        "+t._s(t.trans("student.edit_document"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("document-form",{attrs:{uuid:t.student.uuid,did:t.did},on:{completed:t.complete}})]}))],2)])])])])}),[],!1,null,null,null).exports;const f={components:{documentForm:i},props:["student","did"],mounted:function(){this.did&&this.getStudentDocument()},data:function(){return{student_document:[],documents:[]}},methods:{getStudentDocument:function(){var t=this,e=this.$loading.show();axios.get("/api/student/"+this.student.uuid+"/document/"+this.did).then((function(n){t.student_document=n.student_document,t.documents=n.documents,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}},computed:{authToken:function(){return helper.getAuthToken()}},filters:{momentDateTime:function(t){return helper.formatDateTime(t)}}};const h=(0,s.Z)(f,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                        "+t._s(t.trans("student.view_document"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[t.student_document.student_document_type?n("h4",{staticClass:"card-title"},[t._v(t._s(t.student_document.title)+" ("+t._s(t.student_document.student_document_type.name)+")")]):t._e(),t._v(" "),n("div",{staticClass:"m-t-20",domProps:{innerHTML:t._s(t.student_document.description)}}),t._v(" "),t.documents.length?n("div",[n("ul",{staticClass:"m-t-10 upload-file-list"},t._l(t.documents,(function(e){return n("li",{staticClass:"upload-file-list-item"},[n("a",{staticClass:"no-link-color",attrs:{href:"/student/"+t.student.uuid+"/document/"+t.student_document.id+"/attachment/"+e.uuid+"/download?token="+t.authToken}},[n("i",{class:["file-icon","fas","fa-lg",e.file_info.icon]}),t._v(" "),n("span",{staticClass:"upload-file-list-item-size"},[t._v(t._s(e.file_info.size))]),t._v(" "+t._s(e.user_filename))])])})),0)]):t._e(),t._v(" "),n("hr"),t._v(" "),n("p",[n("i",{staticClass:"far fa-clock"}),t._v(" "),n("small",[t._v(t._s(t.trans("general.created_at"))+" "+t._s(t._f("momentDateTime")(t.student_document.created_at)))]),t._v(" "),n("span",{staticClass:"pull-right"},[n("i",{staticClass:"far fa-clock"}),t._v(" "),n("small",[t._v(t._s(t.trans("general.updated_at"))+" "+t._s(t._f("momentDateTime")(t.student_document.updated_at)))])])])]}))],2)])])])])}),[],!1,null,null,null).exports,g={props:{student:{type:Object,default:function(){return{}}},readMode:{type:Boolean,default:!1}},components:{createDocument:u,editDocument:v,showDocument:h},data:function(){return{student_documents:{total:0,data:[]},showId:null,editId:null,filter:{page_length:helper.getConfig("page_length")},addModal:!1,editModal:!1,showModal:!1}},mounted:function(){(this.readMode&&!helper.hasPermission("list-student")&&!helper.hasPermission("list-class-teacher-wise-student")||!this.readMode&&!helper.hasPermission("edit-student"))&&(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getStudentDocuments()},methods:{editAction:function(t){this.editId=t.id,this.editModal=!0},showAction:function(t){this.showId=t.id,this.showModal=!0},getStudentDocuments:function(t){var e=this,n=this.$loading.show();"number"!=typeof t&&(t=1);var a=helper.getFilterURL(this.filter);axios.get("/api/student/"+this.student.uuid+"/document?page="+t+a).then((function(t){e.student_documents=t,n.hide()})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))},confirmDelete:function(t){var e=this;return function(n){return e.deleteStudentDocument(t)}},deleteStudentDocument:function(t){var e=this,n=this.$loading.show();axios.delete("/api/student/"+this.student.uuid+"/document/"+t.id).then((function(t){toastr.success(t.message),e.getStudentDocuments(),n.hide()})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))}},filters:{momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{student:function(t){this.getStudentDocuments()}}};const b=(0,s.Z)(g,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[t.readMode?t._e():n("button",{staticClass:"btn btn-sm btn-info pull-right",on:{click:function(e){t.addModal=!0}}},[n("i",{staticClass:"fas fa-plus"}),t._v(" "+t._s(t.trans("student.add_new_document")))]),t._v(" "),t.student_documents.total?n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm"},[n("thead",[n("tr",[n("th",[t._v(t._s(t.trans("student.document_title")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.document_type")))]),t._v(" "),n("th",[t._v(t._s(t.trans("general.updated_at")))]),t._v(" "),n("th",{staticClass:"table-option"},[t._v(t._s(t.trans("general.action")))])])]),t._v(" "),n("tbody",t._l(t.student_documents.data,(function(e){return n("tr",[n("td",{domProps:{textContent:t._s(e.title)}}),t._v(" "),n("td",{domProps:{textContent:t._s(e.student_document_type.name)}}),t._v(" "),n("td",[t._v(t._s(t._f("momentDateTime")(e.updated_at)))]),t._v(" "),n("td",{staticClass:"table-option"},[n("div",{staticClass:"btn-group"},[n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.view_document"),expression:"trans('student.view_document')"}],staticClass:"btn btn-success btn-sm",on:{click:function(n){return n.preventDefault(),t.showAction(e)}}},[n("i",{staticClass:"fas fa-arrow-circle-right"})]),t._v(" "),t.readMode?t._e():n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.edit_document"),expression:"trans('student.edit_document')"}],staticClass:"btn btn-info btn-sm",on:{click:function(n){return n.preventDefault(),t.editAction(e)}}},[n("i",{staticClass:"fas fa-edit"})]),t._v(" "),t.readMode?t._e():n("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:t.confirmDelete(e)},expression:"{ok: confirmDelete(student_document)}"},{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.delete_document"),expression:"trans('student.delete_document')"}],key:e.id,staticClass:"btn btn-danger btn-sm"},[n("i",{staticClass:"fas fa-trash"})])])])])})),0)])]):t._e(),t._v(" "),t.readMode?[t.student_documents.total?t._e():n("div",{staticClass:"font-80pc"},[t._v(t._s(t.trans("general.no_result_found")))])]:[t.student_documents.total?t._e():n("module-info",{attrs:{module:"student",title:"document_module_title",description:"document_module_description",icon:"list"}},[n("div",{attrs:{slot:"btn"},slot:"btn"},[n("button",{staticClass:"btn btn-info btn-md",on:{click:function(e){t.addModal=!0}}},[n("i",{staticClass:"fas fa-plus"}),t._v(" "+t._s(t.trans("general.add_new")))])])])],t._v(" "),n("pagination-record",{attrs:{"page-length":t.filter.page_length,records:t.student_documents},on:{"update:pageLength":function(e){return t.$set(t.filter,"page_length",e)},"update:page-length":function(e){return t.$set(t.filter,"page_length",e)},updateRecords:t.getStudentDocuments},nativeOn:{change:function(e){return t.getStudentDocuments.apply(null,arguments)}}}),t._v(" "),t.addModal&&!t.readMode?n("create-document",{attrs:{student:t.student},on:{close:function(e){t.addModal=!1},completed:t.getStudentDocuments}}):t._e(),t._v(" "),t.editModal&&!t.readMode?n("edit-document",{attrs:{student:t.student,did:t.editId},on:{close:function(e){t.editModal=!1},completed:t.getStudentDocuments}}):t._e(),t._v(" "),t.showModal?n("show-document",{attrs:{student:t.student,did:t.showId},on:{close:function(e){t.showModal=!1}}}):t._e()],2)}),[],!1,null,null,null).exports},20905:(t,e,n)=>{"use strict";n.d(e,{Z:()=>u});const a={components:{},props:["student","record"],data:function(){return{recordForm:new Form({batch_id:"",date_of_entry:"",number:"",prefix:""},!1),batches:[],selected_batch:null}},mounted:function(){helper.hasPermission("edit-student")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getPreRequisite()},methods:{getPreRequisite:function(){var t=this,e=this.$loading.show();axios.get("/api/student/record/pre-requisite").then((function(n){t.batches=n.batches,t.selected_batch={id:t.record.batch_id,name:t.record.batch.course.name+" "+t.record.batch.name},t.recordForm.batch_id=t.record.batch_id,t.recordForm.date_of_entry=t.record.date_of_entry,t.recordForm.number=t.record.admission.number,t.recordForm.prefix=t.record.admission.prefix,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},complete:function(){this.$emit("completed"),this.$emit("close")},onBatchSelect:function(t){this.recordForm.batch_id=t.id,loader.hide()},onBatchRemove:function(t){this.recordForm.batch_id=""},submit:function(){var t=this,e=this.$loading.show();this.recordForm.patch("/api/student/"+this.student.uuid+"/record/"+this.record.id).then((function(n){toastr.success(n.message),t.$emit("completed"),t.$emit("close"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}}};var s=n(93379),i=n.n(s),o=n(82824),r={insert:"head",singleton:!1};i()(o.Z,r);o.Z.locals;var d=n(51900);const l=(0,d.Z)(a,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                        "+t._s(t.trans("student.edit_record"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body",staticStyle:{"min-height":"300px"}},[t._t("body",(function(){return[n("form",{on:{submit:function(e){return e.preventDefault(),t.submit.apply(null,arguments)},keydown:function(e){return t.recordForm.errors.clear(e.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.date_of_admission_promotion")))]),t._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:t.trans("student.date_of_admission_promotion")},on:{selected:function(e){return t.recordForm.errors.clear("date_of_entry")}},model:{value:t.recordForm.date_of_entry,callback:function(e){t.$set(t.recordForm,"date_of_entry",e)},expression:"recordForm.date_of_entry"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.recordForm,"prop-name":"date_of_entry"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("academic.batch")))]),t._v(" "),n("v-select",{attrs:{label:"name","group-values":"batches","group-label":"course_group","group-select":!1,name:"batch_id",id:"batch_id",options:t.batches,placeholder:t.trans("academic.select_batch")},on:{select:t.onBatchSelect,close:function(e){return t.recordForm.errors.clear("batch_id")},remove:t.onBatchRemove},model:{value:t.selected_batch,callback:function(e){t.selected_batch=e},expression:"selected_batch"}},[t.batches.length?t._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[t._v("\n                                                "+t._s(t.trans("general.no_option_found"))+"\n                                            ")])]),t._v(" "),n("show-error",{attrs:{"form-name":t.recordForm,"prop-name":"batch_id"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.admission_number")))]),t._v(" "),n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-4"},[n("input",{directives:[{name:"model",rawName:"v-model",value:t.recordForm.prefix,expression:"recordForm.prefix"}],staticClass:"form-control",attrs:{type:"text",name:"prefix",placeholder:t.trans("student.admission_number_prefix")},domProps:{value:t.recordForm.prefix},on:{input:function(e){e.target.composing||t.$set(t.recordForm,"prefix",e.target.value)}}})]),t._v(" "),n("div",{staticClass:"col-12 col-sm-8"},[n("input",{directives:[{name:"model",rawName:"v-model",value:t.recordForm.number,expression:"recordForm.number"}],staticClass:"form-control",attrs:{type:"text",name:"number",placeholder:t.trans("student.admission_number")},domProps:{value:t.recordForm.number},on:{input:function(e){e.target.composing||t.$set(t.recordForm,"number",e.target.value)}}})])]),t._v(" "),n("show-error",{attrs:{"form-name":t.recordForm,"prop-name":"number"}})],1)])]),t._v(" "),n("div",{staticClass:"card-footer text-right"},[n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t._v(t._s(t.trans("general.save")))])])])]}))],2)])])])])}),[],!1,null,null,null).exports,c={props:{student:{type:Object,default:function(){return{}}},readMode:{type:Boolean,default:!1}},components:{editRecord:l},data:function(){return{record:null,editModal:!1}},mounted:function(){},methods:{getAdmissionNumber:function(t){return helper.getAdmissionNumber(t)},editRecord:function(t){this.record=t,this.editModal=!0},complete:function(){this.$emit("completed")},hasPermission:function(t){return helper.hasPermission(t)}},computed:{},filters:{moment:function(t){return helper.formatDate(t)},momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{}};const u=(0,d.Z)(c,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return t.student.id?n("div",[n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm"},[n("thead",[n("tr",[n("th",[t._v(t._s(t.trans("student.admission_number_short")))]),t._v(" "),n("th",[t._v(t._s(t.trans("academic.batch")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.date_of_admission")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.date_of_promotion")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.promotion_remarks")))]),t._v(" "),t.readMode?t._e():n("th",{staticClass:"table-option"},[t._v(t._s(t.trans("general.action")))])])]),t._v(" "),n("tbody",t._l(t.student.student_records,(function(e){return e.date_of_exit?t._e():n("tr",[n("td",[t._v(t._s(t.getAdmissionNumber(e.admission)))]),t._v(" "),n("td",[t._v("\n                        "+t._s(e.batch.course.name+" "+e.batch.name)+"\n                    ")]),t._v(" "),n("td",[n("span",[t._v(t._s(t._f("moment")(e.admission.date_of_admission)))])]),t._v(" "),n("td",[t._v(t._s(t._f("moment")(e.date_of_entry)))]),t._v(" "),n("td",[n("span",[t._v(t._s(e.entry_remarks))])]),t._v(" "),t.readMode?t._e():n("td",{staticClass:"table-option"},[t.$first(e,t.student.student_records)?n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("general.edit"),expression:"trans('general.edit')"}],staticClass:"btn btn-warning btn-sm",on:{click:function(n){return n.preventDefault(),t.editRecord(e)}}},[n("i",{staticClass:"fas fa-edit"}),t._v(" "+t._s(t.trans("general.edit"))+"\n                        ")]):t._e()])])})),0)])]),t._v(" "),t.editModal&&!t.readMode?n("edit-record",{attrs:{student:t.student,record:t.record},on:{close:function(e){t.editModal=!1},completed:t.complete}}):t._e()],1):t._e()}),[],!1,null,null,null).exports},69762:(t,e,n)=>{"use strict";n.d(e,{Z:()=>b});const a={components:{},data:function(){return{qualificationForm:new Form({standard:"",institute_name:"",board_name:"",result:"",start_period:"",end_period:"",upload_token:"",description:""}),module_id:"",clearAttachment:!0}},props:["uuid","qid","name"],mounted:function(){this.qualificationForm.upload_token=this.$uuid.v4(),this.qid&&this.getQualification()},methods:{proceed:function(){this.qid?this.updateQualification():this.storeQualification()},storeQualification:function(){var t=this,e=this.$loading.show();this.qualificationForm.start_period=moment(this.qualificationForm.start_period).format("YYYY-MM"),this.qualificationForm.end_period=moment(this.qualificationForm.end_period).format("YYYY-MM"),this.qualificationForm.post("/api/student/"+this.uuid+"/qualification").then((function(n){toastr.success(n.message),t.clearAttachment=!t.clearAttachment,t.$emit("completed"),t.qualificationForm.upload_token=t.$uuid.v4(),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},getQualification:function(){var t=this,e=this.$loading.show();axios.get("/api/student/"+this.uuid+"/qualification/"+this.qid).then((function(n){t.qualificationForm.standard=n.student_qualification.standard,t.qualificationForm.institute_name=n.student_qualification.institute_name,t.qualificationForm.board_name=n.student_qualification.board_name,t.qualificationForm.result=n.student_qualification.result,t.qualificationForm.start_period=n.student_qualification.start_period,t.qualificationForm.end_period=n.student_qualification.end_period,t.qualificationForm.description=n.student_qualification.description,t.qualificationForm.upload_token=n.student_qualification.upload_token,t.module_id=n.student_qualification.id,t.$emit("loaded"),e.hide()})).catch((function(n){e.hide(),t.$router.push("/student/"+t.uuid)}))},updateQualification:function(){var t=this,e=this.$loading.show();this.qualificationForm.start_period=moment(this.qualificationForm.start_period).format("YYYY-MM"),this.qualificationForm.end_period=moment(this.qualificationForm.end_period).format("YYYY-MM"),this.qualificationForm.patch("/api/student/"+this.uuid+"/qualification/"+this.qid).then((function(n){toastr.success(n.message),t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}}};var s=n(51900);const i=(0,s.Z)(a,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[n("form",{on:{submit:function(e){return e.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(e){return t.qualificationForm.errors.clear(e.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.qualification_standard")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.qualificationForm.standard,expression:"qualificationForm.standard"}],staticClass:"form-control",attrs:{type:"text",name:"standard",placeholder:t.trans("student.qualification_standard")},domProps:{value:t.qualificationForm.standard},on:{input:function(e){e.target.composing||t.$set(t.qualificationForm,"standard",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.qualificationForm,"prop-name":"standard"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.institute_name")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.qualificationForm.institute_name,expression:"qualificationForm.institute_name"}],staticClass:"form-control",attrs:{type:"text",name:"institute_name",placeholder:t.trans("student.institute_name")},domProps:{value:t.qualificationForm.institute_name},on:{input:function(e){e.target.composing||t.$set(t.qualificationForm,"institute_name",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.qualificationForm,"prop-name":"institute_name"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.board_name")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.qualificationForm.board_name,expression:"qualificationForm.board_name"}],staticClass:"form-control",attrs:{type:"text",name:"board_name",placeholder:t.trans("student.board_name")},domProps:{value:t.qualificationForm.board_name},on:{input:function(e){e.target.composing||t.$set(t.qualificationForm,"board_name",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.qualificationForm,"prop-name":"board_name"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.qualification_result")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.qualificationForm.result,expression:"qualificationForm.result"}],staticClass:"form-control",attrs:{type:"text",name:"result",placeholder:t.trans("student.qualification_result")},domProps:{value:t.qualificationForm.result},on:{input:function(e){e.target.composing||t.$set(t.qualificationForm,"result",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.qualificationForm,"prop-name":"result"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.qualification_start_period")))]),t._v(" "),n("vue-monthly-picker",{attrs:{name:"start_period",placeHolder:t.trans("student.qualification_start_period"),dateFormat:"YYYY-MM "},model:{value:t.qualificationForm.start_period,callback:function(e){t.$set(t.qualificationForm,"start_period",e)},expression:"qualificationForm.start_period"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.qualificationForm,"prop-name":"start_period"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.qualification_end_period")))]),t._v(" "),n("vue-monthly-picker",{attrs:{name:"end_period",placeHolder:t.trans("student.qualification_end_period"),dateFormat:"YYYY-MM "},model:{value:t.qualificationForm.end_period,callback:function(e){t.$set(t.qualificationForm,"end_period",e)},expression:"qualificationForm.end_period"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.qualificationForm,"prop-name":"end_period"}})],1)])]),t._v(" "),n("div",{staticClass:"form-group"},[n("file-upload-input",{attrs:{"button-text":t.trans("general.upload_document"),token:t.qualificationForm.upload_token,module:"student_qualification","clear-file":t.clearAttachment,"module-id":t.module_id}})],1),t._v(" "),n("div",{staticClass:"form-group"},[n("autosize-textarea",{attrs:{rows:"2",name:"description",placeholder:t.trans("student.qualification_description")},model:{value:t.qualificationForm.description,callback:function(e){t.$set(t.qualificationForm,"description",e)},expression:"qualificationForm.description"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.qualificationForm,"prop-name":"description"}})],1),t._v(" "),n("button",{staticClass:"btn btn-info waves-effect waves-light pull-right",attrs:{type:"submit"}},[t.qid?n("span",[t._v(t._s(t.trans("general.update")))]):n("span",[t._v(t._s(t.trans("general.save")))])])]),t._v(" "),n("div",{staticClass:"clearfix"})])}),[],!1,null,null,null).exports,o={components:{qualificationForm:i},props:["student"],methods:{complete:function(){this.$emit("completed"),this.$emit("close")}}};var r=n(93379),d=n.n(r),l=n(4146),c={insert:"head",singleton:!1};d()(l.Z,c);l.Z.locals;const u=(0,s.Z)(o,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                        "+t._s(t.trans("student.add_new_qualification"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("qualification-form",{attrs:{uuid:t.student.uuid},on:{completed:t.complete}})]}))],2)])])])])}),[],!1,null,null,null).exports;const m={components:{qualificationForm:i},props:["student","qid"],methods:{complete:function(){this.$emit("completed"),this.$emit("close")}}};var _=n(19183),p={insert:"head",singleton:!1};d()(_.Z,p);_.Z.locals;const v=(0,s.Z)(m,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                        "+t._s(t.trans("student.edit_qualification"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("qualification-form",{attrs:{uuid:t.student.uuid,qid:t.qid},on:{completed:t.complete}})]}))],2)])])])])}),[],!1,null,null,null).exports;const f={components:{qualificationForm:i},props:["student","qid"],mounted:function(){this.qid&&this.getStudentQualification()},data:function(){return{student_qualification:[],attachments:[]}},methods:{getStudentQualification:function(){var t=this,e=this.$loading.show();axios.get("/api/student/"+this.student.uuid+"/qualification/"+this.qid).then((function(n){t.student_qualification=n.student_qualification,t.attachments=n.attachments,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}},computed:{authToken:function(){return helper.getAuthToken()}},filters:{momentDateTime:function(t){return helper.formatDateTime(t)}}};const h=(0,s.Z)(f,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                        "+t._s(t.trans("student.view_qualification"))+"\n                        "),n("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm custom-show-table"},[n("tbody",[n("tr",[n("td",[t._v(t._s(t.trans("student.qualification_standard")))]),t._v(" "),n("td",[t._v(t._s(t.student_qualification.standard))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.institute_name")))]),t._v(" "),n("td",[t._v(t._s(t.student_qualification.institute_name))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.board_name")))]),t._v(" "),n("td",[t._v(t._s(t.student_qualification.board_name))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.qualification_start_period")))]),t._v(" "),n("td",[t._v(t._s(t.student_qualification.start_period))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.qualification_end_period")))]),t._v(" "),n("td",[t._v(t._s(t.student_qualification.end_period))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.qualification_result")))]),t._v(" "),n("td",[t._v(t._s(t.student_qualification.result))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.qualification_description")))]),t._v(" "),n("td",[t._v(t._s(t.student_qualification.description))])])])])]),t._v(" "),t.attachments.length?n("div",[n("ul",{staticClass:"m-t-10 upload-file-list"},t._l(t.attachments,(function(e){return n("li",{staticClass:"upload-file-list-item"},[n("a",{staticClass:"no-link-color",attrs:{href:"/student/"+t.student.uuid+"/qualification/"+t.student_qualification.id+"/attachment/"+e.uuid+"/download?token="+t.authToken}},[n("i",{class:["file-icon","fas","fa-lg",e.file_info.icon]}),t._v(" "),n("span",{staticClass:"upload-file-list-item-size"},[t._v(t._s(e.file_info.size))]),t._v(" "+t._s(e.user_filename))])])})),0)]):t._e(),t._v(" "),n("hr"),t._v(" "),n("p",[n("i",{staticClass:"far fa-clock"}),t._v(" "),n("small",[t._v(t._s(t.trans("general.created_at"))+" "+t._s(t._f("momentDateTime")(t.student_qualification.created_at)))]),t._v(" "),n("span",{staticClass:"pull-right"},[n("i",{staticClass:"far fa-clock"}),t._v(" "),n("small",[t._v(t._s(t.trans("general.updated_at"))+" "+t._s(t._f("momentDateTime")(t.student_qualification.updated_at)))])])])]}))],2)])])])])}),[],!1,null,null,null).exports,g={props:{student:{type:Object,default:function(){return{}}},readMode:{type:Boolean,default:!1}},components:{createQualification:u,editQualification:v,showQualification:h},data:function(){return{student_qualifications:{total:0,data:[]},showId:null,editId:null,filter:{page_length:helper.getConfig("page_length")},addModal:!1,editModal:!1,showModal:!1}},mounted:function(){(this.readMode&&!helper.hasPermission("list-student")&&!helper.hasPermission("list-class-teacher-wise-student")||!this.readMode&&!helper.hasPermission("edit-student"))&&(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getStudentQualifications()},methods:{getStudentName:function(){return helper.getStudentName(this.student)},editAction:function(t){this.editId=t.id,this.editModal=!0},showAction:function(t){this.showId=t.id,this.showModal=!0},getStudentQualifications:function(t){var e=this,n=this.$loading.show();"number"!=typeof t&&(t=1);var a=helper.getFilterURL(this.filter);axios.get("/api/student/"+this.student.uuid+"/qualification?page="+t+a).then((function(t){e.student_qualifications=t,n.hide()})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))},confirmDelete:function(t){var e=this;return function(n){return e.deleteStudentQualification(t)}},deleteStudentQualification:function(t){var e=this,n=this.$loading.show();axios.delete("/api/student/"+this.student.uuid+"/qualification/"+t.id).then((function(t){toastr.success(t.message),e.getStudentQualifications(),n.hide()})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))}},filters:{momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{student:function(t){this.getStudentQualifications()}}};const b=(0,s.Z)(g,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[t.readMode?t._e():n("button",{staticClass:"btn btn-sm btn-info pull-right",on:{click:function(e){t.addModal=!0}}},[n("i",{staticClass:"fas fa-plus"}),t._v(" "+t._s(t.trans("student.add_new_qualification")))]),t._v(" "),t.student_qualifications.total?n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm"},[n("thead",[n("tr",[n("th",[t._v(t._s(t.trans("student.qualification_standard")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.institute_name")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.qualification_period")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.qualification_result")))]),t._v(" "),n("th",{staticClass:"table-option"},[t._v(t._s(t.trans("general.action")))])])]),t._v(" "),n("tbody",t._l(t.student_qualifications.data,(function(e){return n("tr",[n("td",{domProps:{textContent:t._s(e.standard)}}),t._v(" "),n("td",{domProps:{textContent:t._s(e.institute_name)}}),t._v(" "),n("td",[t._v(t._s(e.start_period)+" "+t._s(t.trans("general.to"))+" "+t._s(e.end_period))]),t._v(" "),n("td",{domProps:{textContent:t._s(e.result)}}),t._v(" "),n("td",{staticClass:"table-option"},[n("div",{staticClass:"btn-group"},[n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.view_qualification"),expression:"trans('student.view_qualification')"}],staticClass:"btn btn-success btn-sm",on:{click:function(n){return n.preventDefault(),t.showAction(e)}}},[n("i",{staticClass:"fas fa-arrow-circle-right"})]),t._v(" "),t.readMode?t._e():n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.edit_qualification"),expression:"trans('student.edit_qualification')"}],staticClass:"btn btn-info btn-sm",on:{click:function(n){return n.preventDefault(),t.editAction(e)}}},[n("i",{staticClass:"fas fa-edit"})]),t._v(" "),t.readMode?t._e():n("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:t.confirmDelete(e)},expression:"{ok: confirmDelete(student_qualification)}"},{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.delete_qualification"),expression:"trans('student.delete_qualification')"}],key:e.id,staticClass:"btn btn-danger btn-sm"},[n("i",{staticClass:"fas fa-trash"})])])])])})),0)])]):t._e(),t._v(" "),t.readMode?[t.student_qualifications.total?t._e():n("div",{staticClass:"font-80pc"},[t._v(t._s(t.trans("general.no_result_found")))])]:[t.student_qualifications.total?t._e():n("module-info",{attrs:{module:"student",title:"qualification_module_title",description:"qualification_module_description",icon:"list"}},[n("div",{attrs:{slot:"btn"},slot:"btn"},[n("button",{staticClass:"btn btn-info btn-md",on:{click:function(e){t.addModal=!0}}},[n("i",{staticClass:"fas fa-plus"}),t._v(" "+t._s(t.trans("general.add_new")))])])])],t._v(" "),n("pagination-record",{attrs:{"page-length":t.filter.page_length,records:t.student_qualifications},on:{"update:pageLength":function(e){return t.$set(t.filter,"page_length",e)},"update:page-length":function(e){return t.$set(t.filter,"page_length",e)},updateRecords:t.getStudentQualifications},nativeOn:{change:function(e){return t.getStudentQualifications.apply(null,arguments)}}}),t._v(" "),t.addModal&&!t.readMode?n("create-qualification",{attrs:{student:t.student},on:{close:function(e){t.addModal=!1},completed:t.getStudentQualifications}}):t._e(),t._v(" "),t.editModal&&!t.readMode?n("edit-qualification",{attrs:{student:t.student,qid:t.editId},on:{close:function(e){t.editModal=!1},completed:t.getStudentQualifications}}):t._e(),t._v(" "),t.showModal?n("show-qualification",{attrs:{student:t.student,qid:t.showId},on:{close:function(e){t.showModal=!1}}}):t._e()],2)}),[],!1,null,null,null).exports},23876:(t,e,n)=>{"use strict";n.r(e),n.d(e,{default:()=>S});const a={components:{},props:["student"],data:function(){return{custom_fields:[],custom_values:[]}},mounted:function(){helper.hasPermission("list-student")||helper.hasPermission("list-class-teacher-wise-student")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getPreRequisite()},methods:{getPreRequisite:function(){var t=this,e=this.$loading.show();axios.get("/api/student/pre-requisite?form_type=student_basic").then((function(n){t.custom_fields=n.custom_fields,t.get(t.student),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},get:function(t){this.custom_values=t.options&&t.options.hasOwnProperty("custom_values")?t.options.custom_values:[]}},watch:{student:function(t){this.get(t)}}};var s=n(51900);const i=(0,s.Z)(a,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.first_name"),value:t.student.first_name}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.middle_name"),value:t.student.middle_name}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.last_name"),value:t.student.last_name}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.gender"),value:t.student.gender,"to-uppercase-word":!0}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{type:"date",label:t.trans("student.date_of_birth"),value:t.student.date_of_birth}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.birth_place"),value:t.student.birth_place}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.unique_identification_number"),value:t.student.unique_identification_number}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.nationality"),value:t.student.nationality}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.mother_tongue"),value:t.student.mother_tongue}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("misc.caste"),value:t.student.caste_id?t.student.caste.name:""}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("misc.category"),value:t.student.category_id?t.student.category.name:""}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("misc.religion"),value:t.student.religion_id?t.student.religion.name:""}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("misc.blood_group"),value:t.student.blood_group_id?t.student.blood_group.name:""}})],1)]),t._v(" "),t.custom_fields.length?n("hr"):t._e(),t._v(" "),n("view-custom-field",{attrs:{fields:t.custom_fields,customValues:t.custom_values}})],1)}),[],!1,null,null,null).exports;const o={components:{},props:{student:{type:Object,default:function(){return{parent:{}}}}},data:function(){return{custom_fields:[],custom_values:[]}},mounted:function(){helper.hasPermission("list-student")||helper.hasPermission("list-class-teacher-wise-student")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getParents()},methods:{getParents:function(){var t=this,e=this.$loading.show();axios.get("/api/student/pre-requisite?form_type=student_parent").then((function(n){t.custom_fields=n.custom_fields,t.get(t.student),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},get:function(t){var e=t.parent;this.custom_values=e&&e.options&&e.options.hasOwnProperty("custom_values")?e.options.custom_values:[]}},watch:{student:function(t){this.get(t)}}};var r=n(93379),d=n.n(r),l=n(2817),c={insert:"head",singleton:!1};d()(l.Z,c);l.Z.locals;const u=(0,s.Z)(o,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[n("div",{staticClass:"row mb-4"},[n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("general.relation"),value:t.student.parent.first_guardian_relation,"to-uppercase-word":!0}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("general.relation"),value:t.student.parent.second_guardian_relation,"to-uppercase-word":!0}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.first_guardian_name"),value:t.student.parent.first_guardian_name}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.second_guardian_name"),value:t.student.parent.second_guardian_name}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.first_guardian_date_of_birth"),value:t.student.parent.first_guardian_date_of_birth,type:"date"}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.second_guardian_date_of_birth"),value:t.student.parent.second_guardian_date_of_birth,type:"date"}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.first_guardian_qualification"),value:t.student.parent.first_guardian_qualification}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.second_guardian_qualification"),value:t.student.parent.second_guardian_qualification}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.first_guardian_occupation"),value:t.student.parent.first_guardian_occupation}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.second_guardian_occupation"),value:t.student.parent.second_guardian_occupation}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.first_guardian_annual_income"),value:t.student.parent.first_guardian_annual_income}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.second_guardian_annual_income"),value:t.student.parent.second_guardian_annual_income}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.first_guardian_email"),value:t.student.parent.first_guardian_email}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.second_guardian_email"),value:t.student.parent.second_guardian_email}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.first_guardian_contact_number_1"),value:t.student.parent.first_guardian_contact_number_1}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.second_guardian_contact_number_1"),value:t.student.parent.second_guardian_contact_number_1}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.first_guardian_contact_number_2"),value:t.student.parent.first_guardian_contact_number_2}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.second_guardian_contact_number_2"),value:t.student.parent.second_guardian_contact_number_2}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.first_guardian_unique_identification_number"),value:t.student.parent.first_guardian_unique_identification_number}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.second_guardian_unique_identification_number"),value:t.student.parent.second_guardian_unique_identification_number}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("span",{staticClass:"align-items-center student-thumb"},[t.student.parent.first_guardian_photo?[n("img",{staticClass:"img-circle avatar",attrs:{src:"/"+t.student.parent.first_guardian_photo}})]:["father"==t.student.parent.first_guardian_relation||"female"==t.student.gender&&"spouse"==t.student.parent.first_guardian_relation?n("img",{staticClass:"img-circle avatar",attrs:{src:"/images/avatar_male.png"}}):"mother"==t.student.parent.first_guardian_relation||"male"==t.student.gender&&"spouse"==t.student.parent.first_guardian_relation?n("img",{staticClass:"img-circle avatar",attrs:{src:"/images/avatar_female.png"}}):n("img",{staticClass:"img-circle avatar",attrs:{src:"/images/avatar_male.png"}})]],2)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("span",{staticClass:"align-items-center student-thumb"},[t.student.parent.second_guardian_photo?[n("img",{staticClass:"img-circle avatar",attrs:{src:"/"+t.student.parent.second_guardian_photo}})]:["father"==t.student.parent.second_guardian_relation||"female"==t.student.gender&&"spouse"==t.student.parent.second_guardian_relation?n("img",{staticClass:"img-circle avatar",attrs:{src:"/images/avatar_male.png"}}):"mother"==t.student.parent.second_guardian_relation||"male"==t.student.gender&&"spouse"==t.student.parent.second_guardian_relation?n("img",{staticClass:"img-circle avatar",attrs:{src:"/images/avatar_female.png"}}):n("img",{staticClass:"img-circle avatar",attrs:{src:"/images/avatar_male.png"}})]],2)])]),t._v(" "),t.custom_fields.length?n("hr"):t._e(),t._v(" "),n("view-custom-field",{attrs:{fields:t.custom_fields,customValues:t.custom_values}})],1)}),[],!1,null,null,null).exports;const m={components:{},props:["student"],data:function(){return{custom_fields:[],custom_values:[]}},mounted:function(){helper.hasPermission("list-student")||helper.hasPermission("list-class-teacher-wise-student")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getPreRequisite()},methods:{getPreRequisite:function(){var t=this,e=this.$loading.show();axios.get("/api/student/pre-requisite?form_type=student_contact").then((function(n){t.custom_fields=n.custom_fields,t.get(t.student),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},get:function(t){this.custom_values=t.options&&t.options.hasOwnProperty("custom_values")?t.options.custom_values:[]}},watch:{student:function(t){this.get(t)}}};const _=(0,s.Z)(m,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.contact_number"),value:t.student.contact_number}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.email"),value:t.student.email}})],1)]),t._v(" "),n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.emergency_contact_name"),value:t.student.emergency_contact_name}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.emergency_contact_number"),value:t.student.emergency_contact_number}})],1)]),t._v(" "),n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.present_address"),value:t.student.present_address}})],1),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("view-label",{attrs:{label:t.trans("student.permanent_address"),value:t.student.same_as_present_address?t.trans("student.same_as_present_address"):t.student.permanent_address}})],1)]),t._v(" "),t.custom_fields.length?n("hr"):t._e(),t._v(" "),n("view-custom-field",{attrs:{fields:t.custom_fields,customValues:t.custom_values}})],1)}),[],!1,null,null,null).exports;var p=n(85808),v=n(35050),f=n(69762),h=n(5051),g=n(20905);const b={props:{student:{type:Object,default:function(){return{}}},readMode:{type:Boolean,default:!1}},data:function(){return{}},mounted:function(){helper.hasPermission("list-student-fee")||(helper.notAccessibleMsg(),this.$router.push("/dashboard"))},methods:{getAdmissionNumber:function(t){return helper.getAdmissionNumber(t)},hasPermission:function(t){return helper.hasPermission(t)}},computed:{},filters:{moment:function(t){return helper.formatDate(t)},momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{}};const w=(0,s.Z)(b,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return t.student.id?n("div",[n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm"},[n("thead",[n("tr",[n("th",[t._v(t._s(t.trans("student.admission_number_short")))]),t._v(" "),n("th",[t._v(t._s(t.trans("academic.batch")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.date_of_admission")))]),t._v(" "),n("th",{staticClass:"table-option"},[t._v(t._s(t.trans("general.action")))])])]),t._v(" "),n("tbody",t._l(t.student.student_records,(function(e){return e.date_of_exit?t._e():n("tr",[n("td",[t._v(t._s(t.getAdmissionNumber(e.admission)))]),t._v(" "),n("td",[t._v("\n                        "+t._s(e.batch.course.name+" "+e.batch.name)+"\n                    ")]),t._v(" "),n("td",[n("span",[t._v(t._s(t._f("moment")(e.admission.date_of_admission)))])]),t._v(" "),n("td",{staticClass:"table-option"},[n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.view_student_fee"),expression:"trans('student.view_student_fee')"}],staticClass:"btn btn-info btn-sm",on:{click:function(n){return t.$router.push("/student/"+t.student.uuid+"/fee/"+e.id)}}},[n("i",{staticClass:"fas fa-arrow-circle-right"}),t._v(" "+t._s(t.trans("finance.fee"))+"\n                        ")])])])})),0)])])]):t._e()}),[],!1,null,null,null).exports;const C={props:{student:{type:Object,default:function(){return{}}}},components:{},data:function(){return{header:[],rows:[],student_records:[],total_attendance:0,current_student_record:{}}},mounted:function(){this.student_records=this.student.student_records.filter((function(t){return t.academic_session_id===helper.getDefaultAcademicSession().id})),this.student_records.length?(this.current_student_record=this.student_records[0],this.fetch(this.current_student_record)):toastr.error(i18n.general.no_result_found)},methods:{fetch:function(t){var e=this;if(this.current_student_record.id!==t.id||!this.rows.length){var n=this.$loading.show();axios.get("/api/student/"+this.student.uuid+"/record/"+t.id+"/attendance").then((function(t){e.header=t.header,e.rows=t.rows,e.total_attendance=t.total_attendance,n.hide()})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))}}},computed:{},filters:{moment:function(t){return helper.formatDate(t)},momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{}};const y=(0,s.Z)(C,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return t.student.id?n("div",[n("div",{staticClass:"mb-3"},t._l(t.student_records,(function(e){return n("span",{key:e.id,staticClass:"label label-info lb-md mr-5 pointer",on:{click:function(n){return t.fetch(e)}}},[t._v("\n            "+t._s(e.batch.course.name+" "+e.batch.name)+"\n        ")])})),0),t._v(" "),n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm table-bordered"},[n("thead",[n("tr",t._l(t.header,(function(e){return n("th",{key:e.key},[t._v(t._s(e.label))])})),0)]),t._v(" "),n("tbody",t._l(t.rows,(function(e){return n("tr",{key:e.key},t._l(e,(function(e){return n("td",{key:e.key,staticClass:"text-center"},[e.icon?n("span",[n("i",{class:["fas",e.icon,e.class?"text-"+e.class:""]})]):n("span",[t._v(t._s(e.label))])])})),0)})),0)]),t._v(" "),n("p",{staticClass:"font-weight-bold"},[t._v(t._s(t.trans("student.total_attendance"))+": "+t._s(t.total_attendance))])])]):t._e()}),[],!1,null,null,null).exports;var x=n(8185);const k={props:{student:{type:Object,default:function(){return{parent:{user:{}},user:{}}}}},data:function(){return{enable_parent_login:!1,enable_student_login:!1,student_email:"",student_username:"",parent_email:""}},mounted:function(){this.updateData(this.student)},methods:{updateData:function(t){this.enable_student_login=!(!t.user_id||"activated"!=t.user.status),this.enable_parent_login=!(!t.parent.user_id||"activated"!=t.parent.user.status),this.student_email=t.user_id?t.user.email:"",this.student_username=t.user_id?t.user.username:"",this.parent_email=t.parent.user_id?t.parent.user.email:"",this.parent_username=t.parent.user_id?t.parent.user.username:""}},watch:{student:function(t){this.updateData(t)}}};const F=(0,s.Z)(k,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return t.student.id?n("div",[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.enable_parent_login"),value:t.enable_parent_login?t.trans("list.yes"):t.trans("list.no")}}),t._v(" "),t.enable_parent_login?[n("view-label",{attrs:{label:t.trans("auth.email"),value:t.parent_email}}),t._v(" "),n("view-label",{attrs:{label:t.trans("auth.username"),value:t.parent_username}}),t._v(" "),n("view-label",{attrs:{label:t.trans("auth.password"),value:"xxxxxxxxxx"}})]:t._e()],2),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("view-label",{attrs:{label:t.trans("student.enable_student_login"),value:t.enable_student_login?t.trans("list.yes"):t.trans("list.no")}}),t._v(" "),t.enable_student_login?[n("view-label",{attrs:{label:t.trans("auth.email"),value:t.student_email}}),t._v(" "),n("view-label",{attrs:{label:t.trans("auth.username"),value:t.student_username}}),t._v(" "),n("view-label",{attrs:{label:t.trans("auth.password"),value:"xxxxxxxxxx"}})]:t._e()],2)])]):t._e()}),[],!1,null,null,null).exports;const q={props:{student:{type:Object,default:function(){return{}}}},components:{},data:function(){return{header:[],rows:[],student_records:[],current_student_record:{}}},mounted:function(){this.rows=[],this.student_records=this.student.student_records.filter((function(t){return t.academic_session_id===helper.getDefaultAcademicSession().id})),this.student_records.length?(this.current_student_record=this.student_records[0],this.fetch(this.current_student_record)):toastr.error(i18n.general.no_result_found)},methods:{fetch:function(t){var e=this;if(this.current_student_record.id!==t.id||!this.rows.length){var n=this.$loading.show();axios.get("/api/student/"+this.student.uuid+"/record/"+t.id+"/exam").then((function(t){e.header=t.header,e.rows=t.rows,n.hide()})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))}}},computed:{},filters:{moment:function(t){return helper.formatDate(t)},momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{}};const $=(0,s.Z)(q,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return t.student.id?n("div",[n("div",{staticClass:"mb-3"},t._l(t.student_records,(function(e){return n("span",{key:e.id,staticClass:"label label-info lb-md mr-5 pointer",on:{click:function(n){return t.fetch(e)}}},[t._v("\n            "+t._s(e.batch.course.name+" "+e.batch.name)+"\n        ")])})),0),t._v(" "),t.rows.length?n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm table-bordered"},[n("thead",[n("tr",t._l(t.header,(function(e){return n("th",{key:e.key,staticClass:"text-center"},[t._v(t._s(e.label))])})),0)]),t._v(" "),n("tbody",t._l(t.rows,(function(e){return n("tr",{key:e.key},t._l(e,(function(e){return n("td",{key:e.key,staticClass:"text-center"},[e.detail?n("span",t._l(e.detail,(function(e){return n("span",{staticStyle:{display:"block"}},[e.mark?n("span",[t._v(t._s(e.assessment_detail_code)+": "+t._s(e.mark+"/"+e.assessment_detail_max_mark))]):t._e()])})),0):n("span",[e.no_exams?n("span",[t._v("-")]):n("span",[t._v(t._s(e.label))])])])})),0)})),0)])]):n("div",{staticClass:"font-80pc"},[t._v("\n        "+t._s(t.trans("general.no_result_found"))+"\n    ")])]):t._e()}),[],!1,null,null,null).exports,A={components:{basicDetail:i,parentDetail:u,contactDetail:_,documentDetail:p.Z,accountDetail:v.Z,qualificationDetail:f.Z,terminationDetail:h.Z,siblingDetail:x.Z,promotionDetail:g.Z,loginDetail:F,attendanceDetail:y,examReport:$,feeDetail:w},data:function(){return{uuid:this.$route.params.uuid,student:{},photo:"",tab:""}},mounted:function(){helper.hasPermission("list-student")||helper.hasPermission("list-class-teacher-wise-student")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getStudent(),helper.showDemoNotification(["student"])},methods:{hasPermission:function(t){return helper.hasPermission(t)},getConfig:function(t){return helper.getConfig(t)},getStudent:function(){var t=this,e=this.$loading.show();axios.get("/api/student/"+this.uuid).then((function(n){t.student=n,t.photo=t.student.student_photo,e.hide()})).catch((function(n){e.hide(),helper.showErrorMsg(n),t.$router.push("/dashboard")}))},getStudentName:function(){return helper.getStudentName(this.student)},updatePhoto:function(t){},getStatus:function(t){return t?t.date_of_exit?'<span class="badge badge-danger lb-sm">'+i18n.student.student_status_not_terminated+"</span>":'<span class="badge badge-success lb-sm">'+i18n.student.student_status_not_studying+"</span>":'<span class="badge badge-info lb-sm">'+i18n.student.student_status_not_admitted+"</span>"}},computed:{getDefaultAcademicSession:function(){return helper.getDefaultAcademicSession()},currentStudentRecords:function(){return this.student.student_records.filter((function(t){return t.academic_session_id===helper.getDefaultAcademicSession().id}))}},filters:{moment:function(t){return helper.formatDate(t)},momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{"$route.params.uuid":function(t){this.uuid=t,this.getStudent()}}};var D=n(5035),M={insert:"head",singleton:!1};d()(D.Z,M);D.Z.locals;const S=(0,s.Z)(A,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[t.student.id?n("div",{staticClass:"page-titles"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("h3",{staticClass:"text-themecolor"},[t._v(t._s(t.trans("student.student_detail"))+"\n                    "),n("span",{staticClass:"card-subtitle"},[t._v(t._s(t.getStudentName(t.student)))])])]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"action-buttons pull-right"},[n("router-link",{staticClass:"btn btn-info btn-sm",attrs:{to:"/student/card-view"}},[n("i",{staticClass:"fas fa-list"}),t._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("student.student")))])]),t._v(" "),t.hasPermission("edit-student")?n("router-link",{staticClass:"btn btn-info btn-sm",attrs:{to:"/student/"+t.student.uuid+"/edit"}},[n("i",{staticClass:"fas fa-pencil-alt"}),t._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("student.edit_student")))])]):t._e(),t._v(" "),t.student.student_records.length?n("div",{staticClass:"btn-group"},[n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("general.more_option"),expression:"trans('general.more_option')"}],staticClass:"btn btn-info btn-sm dropdown-toggle no-caret ",attrs:{type:"button",role:"menu",id:"moreOption","data-toggle":"dropdown","aria-haspopup":"true","aria-expanded":"false"}},[n("i",{staticClass:"fas fa-ellipsis-h"}),t._v(" "),n("span",{staticClass:"d-none d-sm-inline"})]),t._v(" "),n("div",{class:["dropdown-menu","ltr"==t.getConfig("direction")?"dropdown-menu-right":""],attrs:{"aria-labelledby":"moreOption"}},t._l(t.student.student_records,(function(e){return n("button",{staticClass:"dropdown-item custom-dropdown",on:{click:function(n){return t.$router.push("/student/"+t.student.uuid+"/fee/"+e.id)}}},[n("i",{staticClass:"fas fa-file"}),t._v(" "+t._s(e.batch.course.name)+" "+t._s(t.trans("finance.fee_allocation")))])})),0)]):t._e()],1)])])]):t._e(),t._v(" "),n("div",{staticClass:"container-fluid"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-8 p-0"},[n("div",{staticClass:"card"},[n("div",{staticClass:"card-body"},[t.student.id?n("div",{staticClass:"accordion",attrs:{id:"accordion"}},[n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"basic","data-toggle":"collapse","data-target":"#collapseBasic","aria-expanded":"false","aria-controls":"collapseBasic"},on:{click:function(e){t.tab="basic"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-graduation-cap fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.basic_information")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseBasic","aria-labelledby":"basic","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["basic"==t.tab?n("basic-detail",{attrs:{student:t.student}}):t._e()],1)])]),t._v(" "),n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"parent","data-toggle":"collapse","data-target":"#collapseParent","aria-expanded":"false","aria-controls":"collapseParent"},on:{click:function(e){t.tab="parent"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-users fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.parent_information")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseParent","aria-labelledby":"parent","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["parent"==t.tab?n("parent-detail",{attrs:{student:t.student}}):t._e()],1)])]),t._v(" "),n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"contact","data-toggle":"collapse","data-target":"#collapseContact","aria-expanded":"false","aria-controls":"collapseContact"},on:{click:function(e){t.tab="contact"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-address-book fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.contact_information")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseContact","aria-labelledby":"contact","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["contact"==t.tab?n("contact-detail",{attrs:{student:t.student}}):t._e()],1)])]),t._v(" "),n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"document","data-toggle":"collapse","data-target":"#collapseDocument","aria-expanded":"false","aria-controls":"collapseDocument"},on:{click:function(e){t.tab="document"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-folder fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.document_information")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseDocument","aria-labelledby":"document","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["document"==t.tab?n("document-detail",{attrs:{"read-mode":!0,student:t.student}}):t._e()],1)])]),t._v(" "),n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"qualification","data-toggle":"collapse","data-target":"#collapseQualification","aria-expanded":"false","aria-controls":"collapseQualification"},on:{click:function(e){t.tab="qualification"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-book fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.qualification_information")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseQualification","aria-labelledby":"qualification","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["qualification"==t.tab?n("qualification-detail",{attrs:{"read-mode":!0,student:t.student}}):t._e()],1)])]),t._v(" "),n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"sibling","data-toggle":"collapse","data-target":"#collapseSibling","aria-expanded":"false","aria-controls":"collapseSibling"},on:{click:function(e){t.tab="sibling"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-people-carry fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.sibling_information")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseSibling","aria-labelledby":"sibling","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["sibling"==t.tab?n("sibling-detail",{attrs:{"read-mode":!0,student:t.student}}):t._e()],1)])]),t._v(" "),n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"account","data-toggle":"collapse","data-target":"#collapseAccount","aria-expanded":"false","aria-controls":"collapseAccount"},on:{click:function(e){t.tab="account"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-university fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.account_information")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseAccount","aria-labelledby":"account","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["account"==t.tab?n("account-detail",{attrs:{"read-mode":!0,student:t.student}}):t._e()],1)])]),t._v(" "),t.student.student_records.length?n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"login","data-toggle":"collapse","data-target":"#collapseUserLogin","aria-expanded":"false","aria-controls":"collapseUserLogin"},on:{click:function(e){t.tab="login"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-sign-in-alt fa-fix-w-32"}),t._v(" "+t._s(t.trans("auth.user_login")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseUserLogin","aria-labelledby":"login","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["login"==t.tab?n("login-detail",{attrs:{student:t.student}}):t._e()],1)])]):t._e(),t._v(" "),t.student.student_records.length&&t.hasPermission("list-student-fee")?n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"fee","data-toggle":"collapse","data-target":"#collapseFee","aria-expanded":"false","aria-controls":"collapseFee"},on:{click:function(e){t.tab="fee"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-coins fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.fee_history")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseFee","aria-labelledby":"fee","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["fee"==t.tab?n("fee-detail",{attrs:{"read-mode":!0,student:t.student}}):t._e()],1)])]):t._e(),t._v(" "),t.student.student_records.length?n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"attendance","data-toggle":"collapse","data-target":"#collapseAttendance","aria-expanded":"false","aria-controls":"collapseAttendance"},on:{click:function(e){t.tab="attendance"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-tasks fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.attendance_history")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseAttendance","aria-labelledby":"attendance","data-parent":"#accordion"}},[n("div",{staticStyle:{padding:"1.5rem 1.5rem 0 2.5rem"}},["attendance"==t.tab?n("attendance-detail",{attrs:{student:t.student}}):t._e()],1)])]):t._e(),t._v(" "),t.student.student_records.length?n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"exam","data-toggle":"collapse","data-target":"#collapseExam","aria-expanded":"false","aria-controls":"collapseExam"},on:{click:function(e){t.tab="exam"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-file-alt fa-fix-w-32"}),t._v(" "+t._s(t.trans("exam.exam_report")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseExam","aria-labelledby":"exam","data-parent":"#accordion"}},[n("div",{staticStyle:{padding:"1.5rem 1.5rem 0 2.5rem"}},["exam"==t.tab?n("exam-report",{attrs:{student:t.student}}):t._e()],1)])]):t._e(),t._v(" "),t.student.student_records.length?n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"promotion","data-toggle":"collapse","data-target":"#collapsePromotion","aria-expanded":"false","aria-controls":"collapsePromotion"},on:{click:function(e){t.tab="promotion"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-chart-line fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.promotion_history")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapsePromotion","aria-labelledby":"promotion","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["promotion"==t.tab?n("promotion-detail",{attrs:{"read-mode":!0,student:t.student}}):t._e()],1)])]):t._e(),t._v(" "),t.student.student_records.length?n("div",{staticClass:"card",staticStyle:{overflow:"visible"}},[n("div",{staticClass:"card-header collapsed",attrs:{id:"termination","data-toggle":"collapse","data-target":"#collapseTermination","aria-expanded":"false","aria-controls":"collapseTermination"},on:{click:function(e){t.tab="termination"}}},[n("h5",[n("i",{staticClass:"fas fa-lg fa-sign-out-alt fa-fix-w-32"}),t._v(" "+t._s(t.trans("student.termination_history")))])]),t._v(" "),n("div",{staticClass:"collapse",attrs:{id:"collapseTermination","aria-labelledby":"termination","data-parent":"#accordion"}},[n("div",{staticClass:"card-body"},["termination"==t.tab?n("termination-detail",{attrs:{"read-mode":!0,student:t.student}}):t._e()],1)])]):t._e()]):t._e()])])]),t._v(" "),n("div",{staticClass:"col-12 col-sm-4 hidden-sm-down p-0 border-left"},[n("div",{staticClass:"card"},[n("div",{staticClass:"card-body p-r-20"},[n("div",{staticClass:"m-3 text-center"},[n("span",[t.student.student_photo?[n("img",{staticClass:"img-circle",attrs:{src:"/"+t.student.student_photo}})]:["female"==t.student.gender?n("img",{staticClass:"img-circle",attrs:{src:"/images/avatar_female_kid.png"}}):n("img",{staticClass:"img-circle",attrs:{src:"/images/avatar_male_kid.png"}})]],2)]),t._v(" "),t.student.id?n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm custom-show-table"},[n("tbody",[n("tr",[n("td",[t._v(t._s(t.trans("student.name")))]),t._v(" "),n("td",[t._v(t._s(t.getStudentName(t.student)))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.father_name")))]),t._v(" "),n("td",[t._v(t._s(t.student.parent?t.student.parent.father_name:""))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.mother_name")))]),t._v(" "),n("td",[t._v(t._s(t.student.parent?t.student.parent.mother_name:""))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.contact_number")))]),t._v(" "),n("td",[t._v(t._s(t.student.contact_number))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.gender")))]),t._v(" "),n("td",[t._v(t._s(t.trans("list."+t.student.gender)))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.date_of_birth")))]),t._v(" "),n("td",[t._v(t._s(t._f("moment")(t.student.date_of_birth)))])])])]),t._v(" "),t._l(t.currentStudentRecords,(function(e){return n("table",{staticClass:"table table-sm custom-show-table"},[n("tbody",[n("tr",[n("td",[t._v(t._s(t.trans("academic.batch")))]),t._v(" "),n("td",[n("span",{domProps:{innerHTML:t._s(t.getStatus(e))}}),t._v(" "+t._s(e.batch.course.name+" "+e.batch.name+" "+e.academic_session.name))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.date_of_admission")))]),t._v(" "),n("td",[t._v(t._s(t._f("moment")(e.admission.date_of_admission)))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.admission_number")))]),t._v(" "),n("td",[t._v(t._s(e.admission.admission_number))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.date_of_promotion")))]),t._v(" "),n("td",[t._v(t._s(t._f("moment")(e.date_of_entry)))])]),t._v(" "),e.date_of_exit?n("tr",[n("td",{staticClass:"text-danger font-weight-bold"},[t._v(t._s(t.trans("student.date_of_termination")))]),t._v(" "),n("td",{staticClass:"text-danger font-weight-bold"},[t._v(t._s(t._f("moment")(e.date_of_exit)))])]):t._e()])])})),t._v(" "),n("table",{staticClass:"table table-sm custom-show-table"},[n("tbody",[n("tr",[n("td",[t._v(t._s(t.trans("general.created_at")))]),t._v(" "),n("td",[t._v(t._s(t._f("momentDateTime")(t.student.created_at)))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("general.updated_at")))]),t._v(" "),n("td",[t._v(t._s(t._f("momentDateTime")(t.student.updated_at)))])])])])],2):t._e()])])])])])])}),[],!1,null,null,null).exports},8185:(t,e,n)=>{"use strict";n.d(e,{Z:()=>d});const a={props:{student:{type:Object,default:function(){return{}}},readMode:{type:Boolean,default:!1}},components:{},data:function(){return{students:[]}},mounted:function(){helper.hasPermission("list-student")||helper.hasPermission("list-class-teacher-wise-student")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getStudentSiblings()},methods:{getStudentSiblings:function(){var t=this,e=this.$loading.show();axios.get("/api/student/"+this.student.uuid+"/sibling").then((function(n){t.students=n.students,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},getStudentRecord:function(t){var e=t.student_records.length;return e?t.student_records[e-1]:null},getAdmissionNumber:function(t){var e=this.getStudentRecord(t);return e?helper.getAdmissionNumber(e.admission):'<span class="label label-danger">'+i18n.student.student_status_not_admitted+"</span>"},getStudentName:function(t){return helper.getStudentName(t)},getBatch:function(t){var e=this.getStudentRecord(t);return e?e.batch.course.name+" "+e.batch.name:"-"}},filters:{momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{student:function(t){this.getStudentSiblings()}}};var s=n(93379),i=n.n(s),o=n(49153),r={insert:"head",singleton:!1};i()(o.Z,r);o.Z.locals;const d=(0,n(51900).Z)(a,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[t.students.length?n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm"},[n("thead",[n("tr",[n("th",[t._v(t._s(t.trans("student.admission_number_short")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.name")))]),t._v(" "),n("th",[t._v(t._s(t.trans("academic.batch")))])])]),t._v(" "),n("tbody",t._l(t.students,(function(e){return n("tr",[n("td",{domProps:{innerHTML:t._s(t.getAdmissionNumber(e))}}),t._v(" "),n("td",{domProps:{textContent:t._s(t.getStudentName(e))}}),t._v(" "),n("td",{domProps:{textContent:t._s(t.getBatch(e))}})])})),0)])]):t._e(),t._v(" "),t.readMode?[t.students.length?t._e():n("div",{staticClass:"font-80pc"},[t._v(t._s(t.trans("general.no_result_found")))])]:[t.students.length?t._e():n("module-info",{attrs:{module:"student",title:"account_module_title",description:"account_module_description",icon:"list"}})],t._v(" "),n("div",[t._v(" ")])],2)}),[],!1,null,null,null).exports},5051:(t,e,n)=>{"use strict";n.d(e,{Z:()=>s});const a={props:{student:{type:Object,default:function(){return{}}},readMode:{type:Boolean,default:!1}},components:{},data:function(){return{terminationForm:new Form({student_record_id:"",date_of_termination:"",termination_remarks:"",termination_reason:"",upload_token:""}),termination_reasons:[],clearAttachment:!1,module_id:"",student_record:{},showModal:!1,attachments:[]}},mounted:function(){this.terminationForm.upload_token=this.$uuid.v4(),this.getPreRequisite()},methods:{getStudentName:function(t){return helper.getStudentName(t)},getPreRequisite:function(){var t=this,e=this.$loading.show();axios.get("/api/student/pre-requisite?form_type=termination").then((function(n){t.termination_reasons=n.termination_reasons,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},submit:function(){var t=this,e=this.$loading.show();this.terminationForm.post("/api/student/"+this.student.uuid+"/terminate/"+this.terminationForm.student_record_id).then((function(n){toastr.success(n.message),t.clearAttachment=!t.clearAttachment,t.terminationForm.upload_token=t.$uuid.v4(),t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},getAdmissionNumber:function(t){return helper.getAdmissionNumber(t)},showTerminationDetail:function(t){var e=this;this.student_record=t;var n=this.$loading.show();axios.get("/api/student/"+this.student.uuid+"/terminate/"+this.student_record.id+"/attachment").then((function(t){e.attachments=t.attachments,n.hide()})).catch((function(t){n.hide(),helper.showErrorMsg(t)})),this.showModal=!0}},computed:{hasTerminationRecord:function(){return this.student.student_records.some((function(t){return t.date_of_exit}))},authToken:function(){return helper.getAuthToken()}},filters:{moment:function(t){return helper.formatDate(t)},momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{}};const s=(0,n(51900).Z)(a,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return t.student.id?n("div",[t.readMode?t._e():[n("form",{on:{submit:function(e){return e.preventDefault(),t.submit.apply(null,arguments)},keydown:function(e){return t.terminationForm.errors.clear(e.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("academic.batch")))]),t._v(" "),n("select",{directives:[{name:"model",rawName:"v-model",value:t.terminationForm.student_record_id,expression:"terminationForm.student_record_id"}],staticClass:"custom-select col-12",attrs:{name:"student_record_id"},on:{change:function(e){var n=Array.prototype.filter.call(e.target.options,(function(t){return t.selected})).map((function(t){return"_value"in t?t._value:t.value}));t.$set(t.terminationForm,"student_record_id",e.target.multiple?n:n[0])}}},[n("option",{attrs:{value:"",selected:""}},[t._v(t._s(t.trans("general.select_one")))]),t._v(" "),t._l(t.student.student_records,(function(e){return e.date_of_exit?t._e():n("option",{domProps:{value:e.id}},[t._v("\n                            "+t._s(e.batch.course.name+" "+e.batch.name)+"\n                          ")])}))],2),t._v(" "),n("show-error",{attrs:{"form-name":t.terminationForm,"prop-name":"termination_reason"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.date_of_termination")))]),t._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:t.trans("student.date_of_termination")},on:{selected:function(e){return t.terminationForm.errors.clear("date_of_termination")}},model:{value:t.terminationForm.date_of_termination,callback:function(e){t.$set(t.terminationForm,"date_of_termination",e)},expression:"terminationForm.date_of_termination"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.terminationForm,"prop-name":"date_of_termination"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.termination_reason")))]),t._v(" "),n("select",{directives:[{name:"model",rawName:"v-model",value:t.terminationForm.termination_reason,expression:"terminationForm.termination_reason"}],staticClass:"custom-select col-12",attrs:{name:"termination_reason"},on:{change:function(e){var n=Array.prototype.filter.call(e.target.options,(function(t){return t.selected})).map((function(t){return"_value"in t?t._value:t.value}));t.$set(t.terminationForm,"termination_reason",e.target.multiple?n:n[0])}}},[n("option",{attrs:{value:"",selected:""}},[t._v(t._s(t.trans("general.select_one")))]),t._v(" "),t._l(t.termination_reasons,(function(e){return n("option",{domProps:{value:e.value}},[t._v("\n                            "+t._s(e.text)+"\n                          ")])}))],2),t._v(" "),n("show-error",{attrs:{"form-name":t.terminationForm,"prop-name":"termination_reason"}})],1)])]),t._v(" "),n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-12"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.termination_remarks")))]),t._v(" "),n("autosize-textarea",{attrs:{rows:"3",name:"termination_remarks",placeholder:t.trans("student.termination_remarks")},model:{value:t.terminationForm.termination_remarks,callback:function(e){t.$set(t.terminationForm,"termination_remarks",e)},expression:"terminationForm.termination_remarks"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.terminationForm,"prop-name":"termination_remarks"}})],1)]),t._v(" "),n("div",{staticClass:"col-12"},[n("label",[t._v(" ")]),t._v(" "),n("div",{staticClass:"form-group"},[n("file-upload-input",{attrs:{"button-text":t.trans("general.upload_document"),token:t.terminationForm.upload_token,module:"student_record","clear-file":t.clearAttachment,"module-id":t.module_id}})],1)])]),t._v(" "),n("div",{staticClass:"card-footer text-right"},[n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t._v(t._s(t.trans("general.save")))])])])],t._v(" "),t.hasTerminationRecord?n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm"},[n("thead",[n("tr",[n("th",[t._v(t._s(t.trans("student.admission_number_short")))]),t._v(" "),n("th",[t._v(t._s(t.trans("academic.batch")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.date_of_admission")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.date_of_promotion")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.date_of_termination")))]),t._v(" "),n("th",[t._v(t._s(t.trans("student.termination_reason")))]),t._v(" "),n("th")])]),t._v(" "),n("tbody",t._l(t.student.student_records,(function(e){return e.date_of_exit?n("tr",[n("td",[t._v(t._s(t.getAdmissionNumber(e.admission)))]),t._v(" "),n("td",[t._v(t._s(e.batch.course.name+" "+e.batch.name))]),t._v(" "),n("td",[t._v(t._s(t._f("moment")(e.date_of_entry)))]),t._v(" "),n("td",[n("span",[t._v(t._s(t._f("moment")(e.admission.date_of_admission)))])]),t._v(" "),n("td",[e.date_of_exit?n("span",[t._v(t._s(t._f("moment")(e.date_of_exit)))]):n("span",[t._v("-")])]),t._v(" "),n("td",[e.date_of_exit?n("span",[t._v(t._s(t.trans("student.termination_reason_"+e.termination_reason)))]):n("span",[t._v("-")])]),t._v(" "),n("td",[n("button",{staticClass:"btn btn-info btn-sm",on:{click:function(n){return t.showTerminationDetail(e)}}},[n("i",{staticClass:"fas fa-arrow-circle-right"})])])]):t._e()})),0)])]):n("div",{staticClass:"font-80pc"},[t._v("\n        "+t._s(t.trans("general.no_result_found"))+"\n    ")]),t._v(" "),n("div",[t._v(" ")]),t._v(" "),t.showModal?n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                            "+t._s(t.getStudentName(t.student))+"\n                            "),n("span",{staticClass:"float-right pointer",on:{click:function(e){t.showModal=!1}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("p",[t._v(t._s(t.trans("academic.batch"))+": "+t._s(t.student_record.batch.course.name+" "+t.student_record.batch.name))]),t._v(" "),n("p",[t._v(t._s(t.trans("student.admission_number_short"))+": "+t._s(t.getAdmissionNumber(t.student_record.admission)))]),t._v(" "),n("p",[t._v(t._s(t.trans("student.date_of_admission"))+": "+t._s(t._f("moment")(t.student_record.admission.date_of_admission)))]),t._v(" "),n("p",[t._v(t._s(t.trans("student.date_of_promotion"))+": "+t._s(t._f("moment")(t.student_record.date_of_entry)))]),t._v(" "),n("p",[t._v(t._s(t.trans("student.date_of_termination"))+":\n                                "),t.student_record.date_of_exit?n("span",[t._v(t._s(t._f("moment")(t.student_record.date_of_exit)))]):n("span",[t._v("-")])]),t._v(" "),n("p",[t._v(t._s(t.trans("student.termination_reason"))+":\n                                "),t.student_record.date_of_exit?n("span",[t._v(t._s(t.trans("student.termination_reason_"+t.student_record.termination_reason)))]):n("span",[t._v("-")])]),t._v(" "),n("p",[t._v(t._s(t.trans("student.termination_remarks"))+": \n                                "),t.student_record.date_of_exit?n("span",[t._v(t._s(t.student_record.exit_remarks))]):n("span",[t._v("-")])]),t._v(" "),t.attachments.length?n("div",[n("ul",{staticClass:"m-t-10 upload-file-list"},t._l(t.attachments,(function(e){return n("li",{staticClass:"upload-file-list-item"},[n("a",{staticClass:"no-link-color",attrs:{href:"/student/"+t.student.uuid+"/terminate/"+t.student_record.id+"/attachment/"+e.uuid+"/download?token="+t.authToken}},[n("i",{class:["file-icon","fas","fa-lg",e.file_info.icon]}),t._v(" "),n("span",{staticClass:"upload-file-list-item-size"},[t._v(t._s(e.file_info.size))]),t._v(" "+t._s(e.user_filename)+" ")])])})),0)]):t._e(),t._v(" "),n("p",[n("i",{staticClass:"far fa-clock"}),t._v(" "),n("small",[t._v(t._s(t.trans("general.created_at"))+" "+t._s(t._f("momentDateTime")(t.student_record.created_at)))]),t._v(" "),n("span",{staticClass:"pull-right"},[n("i",{staticClass:"far fa-clock"}),t._v(" "),n("small",[t._v(t._s(t.trans("general.updated_at"))+" "+t._s(t._f("momentDateTime")(t.student_record.updated_at)))])])]),t._v(" "),n("div",{staticClass:"clearfix"})]}))],2)])])])]):t._e()],2):t._e()}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=student.js.map?id=db16c4b9f8dcd1b7d1b9