(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[5293],{32829:(e,t,s)=>{"use strict";s.d(t,{Z:()=>a});var n=s(94015),o=s.n(n),r=s(23645),i=s.n(r)()(o());i.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/resource/notes/form.vue"],names:[],mappings:"AAoMA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="notesForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                    <div class="form-group">\n                        <label for="">{{trans(\'academic.batch\')}} </label>\n                        <v-select label="name" v-model="selected_batch" group-values="batches" group-label="course_group" :group-select="false" name="batch_id" id="batch_id" :options="batches" :placeholder="trans(\'academic.select_batch\')" @select="onBatchSelect" @close="notesForm.errors.clear(\'batch_id\')" @remove="notesForm.batch_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!batches.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="notesForm" prop-name="batch_id"></show-error>\n                    </div>\n                    <div class="form-group" v-if="notesForm.batch_id">\n                        <label for="">{{trans(\'academic.subject\')}} </label>\n                        <v-select label="name" v-model="selected_subject" name="subject_id" id="subject_id" :options="subjects" :placeholder="trans(\'resource.select_subject\')" @select="onSubjectSelect" @close="notesForm.errors.clear(\'subject_id\')" @remove="notesForm.subject_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!subjects.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="notesForm" prop-name="subject_id"></show-error>\n                    </div>\n                    <div class="form-group">\n                        <label for="">{{trans(\'resource.notes_title\')}}</label>\n                        <input class="form-control" type="text" v-model="notesForm.title" name="title" :placeholder="trans(\'resource.notes_title\')">\n                        <show-error :form-name="notesForm" prop-name="title"></show-error>\n                    </div>\n                    <div class="form-group">\n                        <file-upload-input :button-text="trans(\'general.upload_document\')" :token="notesForm.upload_token" module="notes" :clear-file="clearAttachment" :module-id="module_id"></file-upload-input>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-6">\n                    <div class="form-group">\n                        <html-editor name="description" :model.sync="notesForm.description" height="300" :isUpdate="uuid ? true : false" @clearErrors="notesForm.errors.clear(\'description\')"></html-editor>\n                        <show-error :form-name="notesForm" prop-name="description"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="card-footer text-right">\n                <router-link to="/resource/notes" class="btn btn-danger waves-effect waves-light " v-show="uuid">{{trans(\'general.cancel\')}}</router-link>\n                <button v-if="!uuid" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n                <button type="submit" class="btn btn-info waves-effect waves-light">\n                    <span v-if="uuid">{{trans(\'general.update\')}}</span>\n                    <span v-else>{{trans(\'general.save\')}}</span>\n                </button>\n            </div>\n        </form>\n    </div>\n</template>\n\n\n<script>\n\n    export default {\n        components: {},\n        data() {\n            return {\n                notesForm: new Form({\n                    batch_id: \'\',\n                    subject_id: \'\',\n                    title: \'\',\n                    description: \'\',\n                    upload_token: \'\'\n                }),\n                batches: [],\n                selected_batch: null,\n                subjects: [],\n                selected_subject: null,\n                subject_detail: [],\n                module_id: \'\',\n                clearAttachment: true\n            };\n        },\n        props: [\'uuid\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-notes\') && !helper.hasPermission(\'edit-notes\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            if(this.uuid)\n                this.get();\n            else\n                this.notesForm.upload_token = this.$uuid.v4();\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/notes/pre-requisite\')\n                    .then(response => {\n                        this.batches = response.batches;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            getSubjects(){\n                if (!this.uuid) {\n                    this.notesForm.subject_id = \'\';\n                    this.selected_subject = null;\n                }\n                let loader = this.$loading.show();\n                axios.post(\'/api/batch/\'+this.notesForm.batch_id+\'/subjects\')\n                    .then(response => {\n                        this.subjects = response.subjects;\n                        this.subject_details = response.subject_details;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            proceed(){\n                if(this.uuid)\n                    this.update();\n                else\n                    this.store();\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.notesForm.post(\'/api/notes\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.clearAttachment = !this.clearAttachment;\n                        this.notesForm.upload_token = this.$uuid.v4();\n                        this.selected_batch = null;\n                        this.selected_subject = null;\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/notes/\'+this.uuid)\n                    .then(response => {\n                        let notes = response.notes;\n                        this.notesForm.title = notes.title;\n                        this.notesForm.description = notes.description;\n                        this.notesForm.batch_id = notes.subject.batch_id;\n                        this.notesForm.subject_id = notes.subject_id;\n                        this.selected_batch = this.notesForm.batch_id ? {id: notes.subject.batch_id, name: notes.subject.batch.course.name+\' \'+notes.subject.batch.name} : null;\n                        this.selected_subject = notes.subject_id ? {id: notes.subject_id, name: notes.subject.name+\' (\'+notes.subject.code+\')\'} : null;\n                        this.notesForm.upload_token = notes.upload_token;\n                        this.module_id = notes.id;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/resource/notes\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.notesForm.patch(\'/api/notes/\'+this.uuid)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/resource/notes\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            onBatchSelect(selectedOption){\n                this.notesForm.batch_id = selectedOption.id;\n            },\n            onSubjectSelect(selectedOption){\n                this.notesForm.subject_id = selectedOption.id;\n            }\n        },\n        watch: {\n            \'notesForm.batch_id\': function(val) {\n                if (val) {\n                    this.getSubjects();\n                }\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const a=i},58316:(e,t,s)=>{"use strict";s.r(t),s.d(t,{default:()=>o});const n={components:{notesForm:s(61093).Z},data:function(){return{uuid:this.$route.params.uuid}},mounted:function(){helper.hasPermission("edit-notes")||(helper.notAccessibleMsg(),this.$router.push("/dashboard"))}};const o=(0,s(51900).Z)(n,(function(){var e=this,t=e.$createElement,s=e._self._c||t;return s("div",[s("div",{staticClass:"page-titles"},[s("div",{staticClass:"row"},[s("div",{staticClass:"col-12 col-sm-6"},[s("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("resource.edit_notes")))])]),e._v(" "),s("div",{staticClass:"col-12 col-sm-6"},[s("div",{staticClass:"action-buttons pull-right"},[s("button",{staticClass:"btn btn-info btn-sm",on:{click:function(t){return e.$router.push("/resource/notes")}}},[s("i",{staticClass:"fas fa-list"}),e._v(" "),s("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("resource.notes")))])])])])])]),e._v(" "),s("div",{staticClass:"container-fluid"},[s("div",{staticClass:"card card-form"},[s("div",{staticClass:"card-body p-t-20"},[s("notes-form",{attrs:{uuid:e.uuid}})],1)])])])}),[],!1,null,null,null).exports},61093:(e,t,s)=>{"use strict";s.d(t,{Z:()=>c});const n={components:{},data:function(){return{notesForm:new Form({batch_id:"",subject_id:"",title:"",description:"",upload_token:""}),batches:[],selected_batch:null,subjects:[],selected_subject:null,subject_detail:[],module_id:"",clearAttachment:!0}},props:["uuid"],mounted:function(){helper.hasPermission("create-notes")||helper.hasPermission("edit-notes")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.uuid?this.get():this.notesForm.upload_token=this.$uuid.v4(),this.getPreRequisite()},methods:{hasPermission:function(e){return helper.hasPermission(e)},getPreRequisite:function(){var e=this,t=this.$loading.show();axios.get("/api/notes/pre-requisite").then((function(s){e.batches=s.batches,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},getSubjects:function(){var e=this;this.uuid||(this.notesForm.subject_id="",this.selected_subject=null);var t=this.$loading.show();axios.post("/api/batch/"+this.notesForm.batch_id+"/subjects").then((function(s){e.subjects=s.subjects,e.subject_details=s.subject_details,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},proceed:function(){this.uuid?this.update():this.store()},store:function(){var e=this,t=this.$loading.show();this.notesForm.post("/api/notes").then((function(s){toastr.success(s.message),e.clearAttachment=!e.clearAttachment,e.notesForm.upload_token=e.$uuid.v4(),e.selected_batch=null,e.selected_subject=null,e.$emit("completed"),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,t=this.$loading.show();axios.get("/api/notes/"+this.uuid).then((function(s){var n=s.notes;e.notesForm.title=n.title,e.notesForm.description=n.description,e.notesForm.batch_id=n.subject.batch_id,e.notesForm.subject_id=n.subject_id,e.selected_batch=e.notesForm.batch_id?{id:n.subject.batch_id,name:n.subject.batch.course.name+" "+n.subject.batch.name}:null,e.selected_subject=n.subject_id?{id:n.subject_id,name:n.subject.name+" ("+n.subject.code+")"}:null,e.notesForm.upload_token=n.upload_token,e.module_id=n.id,t.hide()})).catch((function(s){t.hide(),helper.showErrorMsg(s),e.$router.push("/resource/notes")}))},update:function(){var e=this,t=this.$loading.show();this.notesForm.patch("/api/notes/"+this.uuid).then((function(s){toastr.success(s.message),t.hide(),e.$router.push("/resource/notes")})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},onBatchSelect:function(e){this.notesForm.batch_id=e.id},onSubjectSelect:function(e){this.notesForm.subject_id=e.id}},watch:{"notesForm.batch_id":function(e){e&&this.getSubjects()}}};var o=s(93379),r=s.n(o),i=s(32829),a={insert:"head",singleton:!1};r()(i.Z,a);i.Z.locals;const c=(0,s(51900).Z)(n,(function(){var e=this,t=e.$createElement,s=e._self._c||t;return s("div",[s("form",{on:{submit:function(t){return t.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(t){return e.notesForm.errors.clear(t.target.name)}}},[s("div",{staticClass:"row"},[s("div",{staticClass:"col-12 col-sm-6"},[s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.batch"))+" ")]),e._v(" "),s("v-select",{attrs:{label:"name","group-values":"batches","group-label":"course_group","group-select":!1,name:"batch_id",id:"batch_id",options:e.batches,placeholder:e.trans("academic.select_batch")},on:{select:e.onBatchSelect,close:function(t){return e.notesForm.errors.clear("batch_id")},remove:function(t){e.notesForm.batch_id=""}},model:{value:e.selected_batch,callback:function(t){e.selected_batch=t},expression:"selected_batch"}},[e.batches.length?e._e():s("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),s("show-error",{attrs:{"form-name":e.notesForm,"prop-name":"batch_id"}})],1),e._v(" "),e.notesForm.batch_id?s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.subject"))+" ")]),e._v(" "),s("v-select",{attrs:{label:"name",name:"subject_id",id:"subject_id",options:e.subjects,placeholder:e.trans("resource.select_subject")},on:{select:e.onSubjectSelect,close:function(t){return e.notesForm.errors.clear("subject_id")},remove:function(t){e.notesForm.subject_id=""}},model:{value:e.selected_subject,callback:function(t){e.selected_subject=t},expression:"selected_subject"}},[e.subjects.length?e._e():s("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),s("show-error",{attrs:{"form-name":e.notesForm,"prop-name":"subject_id"}})],1):e._e(),e._v(" "),s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[e._v(e._s(e.trans("resource.notes_title")))]),e._v(" "),s("input",{directives:[{name:"model",rawName:"v-model",value:e.notesForm.title,expression:"notesForm.title"}],staticClass:"form-control",attrs:{type:"text",name:"title",placeholder:e.trans("resource.notes_title")},domProps:{value:e.notesForm.title},on:{input:function(t){t.target.composing||e.$set(e.notesForm,"title",t.target.value)}}}),e._v(" "),s("show-error",{attrs:{"form-name":e.notesForm,"prop-name":"title"}})],1),e._v(" "),s("div",{staticClass:"form-group"},[s("file-upload-input",{attrs:{"button-text":e.trans("general.upload_document"),token:e.notesForm.upload_token,module:"notes","clear-file":e.clearAttachment,"module-id":e.module_id}})],1)]),e._v(" "),s("div",{staticClass:"col-12 col-sm-6"},[s("div",{staticClass:"form-group"},[s("html-editor",{attrs:{name:"description",model:e.notesForm.description,height:"300",isUpdate:!!e.uuid},on:{"update:model":function(t){return e.$set(e.notesForm,"description",t)},clearErrors:function(t){return e.notesForm.errors.clear("description")}}}),e._v(" "),s("show-error",{attrs:{"form-name":e.notesForm,"prop-name":"description"}})],1)])]),e._v(" "),s("div",{staticClass:"card-footer text-right"},[s("router-link",{directives:[{name:"show",rawName:"v-show",value:e.uuid,expression:"uuid"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/resource/notes"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),e.uuid?e._e():s("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(t){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),s("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.uuid?s("span",[e._v(e._s(e.trans("general.update")))]):s("span",[e._v(e._s(e.trans("general.save")))])])],1)])])}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=edit.js.map?id=a7d31ce186dc9ef54fb0