(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[4723],{59414:(t,e,i)=>{"use strict";i.d(e,{Z:()=>o});var a=i(94015),r=i.n(a),s=i(23645),n=i.n(s)()(r());n.push([t.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/post/article/form.vue"],names:[],mappings:"AAsMA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="articleForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                    <div class="form-group">\n                        <label for="">{{trans(\'post.article_type\')}} </label> <button type="button" class="btn btn-xs btn-info pull-right" v-if="hasPermission(\'access-configuration\')" @click="showArticleTypeModal = true">{{trans(\'general.add_new\')}}</button>\n                        <v-select label="name" v-model="selected_article_type" name="article_type_id" id="article_type_id" :options="article_types" :placeholder="trans(\'post.select_article_type\')" @select="onArticleTypeSelect" @close="articleForm.errors.clear(\'article_type_id\')" @remove="articleForm.article_type_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!article_types.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="articleForm" prop-name="article_type_id"></show-error>\n                    </div>\n                    <div class="form-group">\n                        <label for="">{{trans(\'post.article_title\')}}</label>\n                        <input class="form-control" type="text" v-model="articleForm.title" name="title" :placeholder="trans(\'post.article_title\')">\n                        <show-error :form-name="articleForm" prop-name="title"></show-error>\n                    </div>\n                    <div class="form-group">\n                        <label for="">{{trans(\'post.date_of_article\')}}</label>\n                        <datepicker v-model="articleForm.date_of_article" :bootstrapStyling="true" @selected="articleForm.errors.clear(\'date_of_article\')" :placeholder="trans(\'post.date_of_article\')"></datepicker>\n                        <show-error :form-name="articleForm" prop-name="date_of_article"></show-error>\n                    </div>\n                    <div class="form-group">\n                        <label class="custom-control custom-checkbox">\n                            <input type="checkbox" class="custom-control-input" v-model="articleForm.is_public" value="1">\n                            <span class="custom-control-label">{{trans(\'post.article_is_public\')}}</span>\n                        </label>\n                    </div>\n                    <div class="form-group">\n                        <file-upload-input :button-text="trans(\'general.upload_document\')" :token="articleForm.upload_token" module="article" :clear-file="clearAttachment" :module-id="module_id"></file-upload-input>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-6">\n                    <div class="form-group">\n                        <html-editor name="description" :model.sync="articleForm.description" height="300" :isUpdate="uuid ? true : false" @clearErrors="articleForm.errors.clear(\'description\')"></html-editor>\n                        <show-error :form-name="articleForm" prop-name="description"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="card-footer text-right">\n                <router-link to="/post/article" class="btn btn-danger waves-effect waves-light " v-show="uuid">{{trans(\'general.cancel\')}}</router-link>\n                <button v-if="!uuid" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n                <button type="submit" class="btn btn-info waves-effect waves-light">\n                    <span v-if="uuid">{{trans(\'general.update\')}}</span>\n                    <span v-else>{{trans(\'general.save\')}}</span>\n                </button>\n            </div>\n        </form>\n\n        <transition name="modal" v-if="showArticleTypeModal">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'post.add_new_article_type\')}}\n                                <span class="float-right pointer" @click="showArticleTypeModal = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <article-type-form @completed="getPreRequisite" @cancel="showArticleTypeModal = false"></article-type-form>\n                                <div class="clearfix"></div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n    </div>\n</template>\n\n\n<script>\n    import articleTypeForm from \'../../configuration/post/article-type/form\'\n\n    export default {\n        components: {articleTypeForm},\n        data() {\n            return {\n                articleForm: new Form({\n                    article_type_id: \'\',\n                    title: \'\',\n                    is_public: 0,\n                    date_of_article: \'\',\n                    description: \'\',\n                    upload_token: \'\'\n                }),\n                article_types: [],\n                selected_article_type: null,\n                module_id: \'\',\n                clearAttachment: true,\n                showArticleTypeModal: false\n            };\n        },\n        props: [\'uuid\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-article\') && !helper.hasPermission(\'edit-article\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            if(this.uuid)\n                this.get();\n            else\n                this.articleForm.upload_token = this.$uuid.v4();\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                this.showArticleTypeModal = false;\n                axios.get(\'/api/article/pre-requisite\')\n                    .then(response => {\n                        this.article_types = response.article_types;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            proceed(){\n                if(this.uuid)\n                    this.update();\n                else\n                    this.store();\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.articleForm.post(\'/api/article\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.clearAttachment = !this.clearAttachment;\n                        this.articleForm.upload_token = this.$uuid.v4();\n                        this.selected_article_type = null;\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/article/\'+this.uuid)\n                    .then(response => {\n                        this.articleForm.title = response.article.title;\n                        this.articleForm.date_of_article = response.article.date_of_article;\n                        this.articleForm.description = response.article.description;\n                        this.articleForm.article_type_id = response.article.article_type_id;\n                        this.selected_article_type = response.article.article_type_id ? {id: response.article.article_type_id, name: response.article.article_type.name} : null;\n                        this.articleForm.is_public = response.article.is_public;\n                        this.articleForm.upload_token = response.article.upload_token;\n                        this.module_id = response.article.id;\n\n                        if (! response.is_editable) {\n                            toastr.error(i18n.user.permission_denied);\n                            loader.hide();\n                            this.$router.push(\'/post/article\');\n                        }\n\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/post/article\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.articleForm.patch(\'/api/article/\'+this.uuid)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/post/article\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            onArticleTypeSelect(selectedOption){\n                this.articleForm.article_type_id = selectedOption.id;\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const o=n},19976:(t,e,i)=>{"use strict";i.d(e,{Z:()=>r});const a={data:function(){return{articleTypeForm:new Form({name:"",description:""})}},props:["id"],mounted:function(){this.id&&this.get()},methods:{proceed:function(){this.id?this.update():this.store()},store:function(){var t=this,e=this.$loading.show();this.articleTypeForm.post("/api/post/article/type").then((function(i){toastr.success(i.message),t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},get:function(){var t=this,e=this.$loading.show();axios.get("/api/post/article/type/"+this.id).then((function(i){t.articleTypeForm.name=i.name,t.articleTypeForm.description=i.description,e.hide()})).catch((function(i){e.hide(),helper.showErrorMsg(i),t.$router.push("/configuration/post/article/type")}))},update:function(){var t=this,e=this.$loading.show();this.articleTypeForm.patch("/api/post/article/type/"+this.id).then((function(i){toastr.success(i.message),e.hide(),t.$router.push("/configuration/post/article/type")})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}}};const r=(0,i(51900).Z)(a,(function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("form",{on:{submit:function(e){return e.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(e){return t.articleTypeForm.errors.clear(e.target.name)}}},[i("div",{staticClass:"row"},[i("div",{staticClass:"col-12 col-sm-6"},[i("div",{staticClass:"form-group"},[i("label",{attrs:{for:""}},[t._v(t._s(t.trans("post.article_type_name")))]),t._v(" "),i("input",{directives:[{name:"model",rawName:"v-model",value:t.articleTypeForm.name,expression:"articleTypeForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:t.trans("post.article_type_name")},domProps:{value:t.articleTypeForm.name},on:{input:function(e){e.target.composing||t.$set(t.articleTypeForm,"name",e.target.value)}}}),t._v(" "),i("show-error",{attrs:{"form-name":t.articleTypeForm,"prop-name":"name"}})],1)]),t._v(" "),i("div",{staticClass:"col-12 col-sm-6"},[i("div",{staticClass:"form-group"},[i("label",{attrs:{for:""}},[t._v(t._s(t.trans("post.article_type_description")))]),t._v(" "),i("input",{directives:[{name:"model",rawName:"v-model",value:t.articleTypeForm.description,expression:"articleTypeForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:t.trans("post.article_type_description")},domProps:{value:t.articleTypeForm.description},on:{input:function(e){e.target.composing||t.$set(t.articleTypeForm,"description",e.target.value)}}}),t._v(" "),i("show-error",{attrs:{"form-name":t.articleTypeForm,"prop-name":"description"}})],1)])]),t._v(" "),i("div",{staticClass:"card-footer text-right"},[i("router-link",{directives:[{name:"show",rawName:"v-show",value:t.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/configuration/post/article/type"}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),t.id?t._e():i("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(e){return t.$emit("cancel")}}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),i("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t.id?i("span",[t._v(t._s(t.trans("general.update")))]):i("span",[t._v(t._s(t.trans("general.save")))])])],1)])}),[],!1,null,null,null).exports},601:(t,e,i)=>{"use strict";i.d(e,{Z:()=>l});const a={components:{articleTypeForm:i(19976).Z},data:function(){return{articleForm:new Form({article_type_id:"",title:"",is_public:0,date_of_article:"",description:"",upload_token:""}),article_types:[],selected_article_type:null,module_id:"",clearAttachment:!0,showArticleTypeModal:!1}},props:["uuid"],mounted:function(){helper.hasPermission("create-article")||helper.hasPermission("edit-article")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.uuid?this.get():this.articleForm.upload_token=this.$uuid.v4(),this.getPreRequisite()},methods:{hasPermission:function(t){return helper.hasPermission(t)},getPreRequisite:function(){var t=this,e=this.$loading.show();this.showArticleTypeModal=!1,axios.get("/api/article/pre-requisite").then((function(i){t.article_types=i.article_types,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},proceed:function(){this.uuid?this.update():this.store()},store:function(){var t=this,e=this.$loading.show();this.articleForm.post("/api/article").then((function(i){toastr.success(i.message),t.clearAttachment=!t.clearAttachment,t.articleForm.upload_token=t.$uuid.v4(),t.selected_article_type=null,t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},get:function(){var t=this,e=this.$loading.show();axios.get("/api/article/"+this.uuid).then((function(i){t.articleForm.title=i.article.title,t.articleForm.date_of_article=i.article.date_of_article,t.articleForm.description=i.article.description,t.articleForm.article_type_id=i.article.article_type_id,t.selected_article_type=i.article.article_type_id?{id:i.article.article_type_id,name:i.article.article_type.name}:null,t.articleForm.is_public=i.article.is_public,t.articleForm.upload_token=i.article.upload_token,t.module_id=i.article.id,i.is_editable||(toastr.error(i18n.user.permission_denied),e.hide(),t.$router.push("/post/article")),e.hide()})).catch((function(i){e.hide(),helper.showErrorMsg(i),t.$router.push("/post/article")}))},update:function(){var t=this,e=this.$loading.show();this.articleForm.patch("/api/article/"+this.uuid).then((function(i){toastr.success(i.message),e.hide(),t.$router.push("/post/article")})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},onArticleTypeSelect:function(t){this.articleForm.article_type_id=t.id}}};var r=i(93379),s=i.n(r),n=i(59414),o={insert:"head",singleton:!1};s()(n.Z,o);n.Z.locals;const l=(0,i(51900).Z)(a,(function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",[i("form",{on:{submit:function(e){return e.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(e){return t.articleForm.errors.clear(e.target.name)}}},[i("div",{staticClass:"row"},[i("div",{staticClass:"col-12 col-sm-6"},[i("div",{staticClass:"form-group"},[i("label",{attrs:{for:""}},[t._v(t._s(t.trans("post.article_type"))+" ")]),t._v(" "),t.hasPermission("access-configuration")?i("button",{staticClass:"btn btn-xs btn-info pull-right",attrs:{type:"button"},on:{click:function(e){t.showArticleTypeModal=!0}}},[t._v(t._s(t.trans("general.add_new")))]):t._e(),t._v(" "),i("v-select",{attrs:{label:"name",name:"article_type_id",id:"article_type_id",options:t.article_types,placeholder:t.trans("post.select_article_type")},on:{select:t.onArticleTypeSelect,close:function(e){return t.articleForm.errors.clear("article_type_id")},remove:function(e){t.articleForm.article_type_id=""}},model:{value:t.selected_article_type,callback:function(e){t.selected_article_type=e},expression:"selected_article_type"}},[t.article_types.length?t._e():i("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[t._v("\n                            "+t._s(t.trans("general.no_option_found"))+"\n                        ")])]),t._v(" "),i("show-error",{attrs:{"form-name":t.articleForm,"prop-name":"article_type_id"}})],1),t._v(" "),i("div",{staticClass:"form-group"},[i("label",{attrs:{for:""}},[t._v(t._s(t.trans("post.article_title")))]),t._v(" "),i("input",{directives:[{name:"model",rawName:"v-model",value:t.articleForm.title,expression:"articleForm.title"}],staticClass:"form-control",attrs:{type:"text",name:"title",placeholder:t.trans("post.article_title")},domProps:{value:t.articleForm.title},on:{input:function(e){e.target.composing||t.$set(t.articleForm,"title",e.target.value)}}}),t._v(" "),i("show-error",{attrs:{"form-name":t.articleForm,"prop-name":"title"}})],1),t._v(" "),i("div",{staticClass:"form-group"},[i("label",{attrs:{for:""}},[t._v(t._s(t.trans("post.date_of_article")))]),t._v(" "),i("datepicker",{attrs:{bootstrapStyling:!0,placeholder:t.trans("post.date_of_article")},on:{selected:function(e){return t.articleForm.errors.clear("date_of_article")}},model:{value:t.articleForm.date_of_article,callback:function(e){t.$set(t.articleForm,"date_of_article",e)},expression:"articleForm.date_of_article"}}),t._v(" "),i("show-error",{attrs:{"form-name":t.articleForm,"prop-name":"date_of_article"}})],1),t._v(" "),i("div",{staticClass:"form-group"},[i("label",{staticClass:"custom-control custom-checkbox"},[i("input",{directives:[{name:"model",rawName:"v-model",value:t.articleForm.is_public,expression:"articleForm.is_public"}],staticClass:"custom-control-input",attrs:{type:"checkbox",value:"1"},domProps:{checked:Array.isArray(t.articleForm.is_public)?t._i(t.articleForm.is_public,"1")>-1:t.articleForm.is_public},on:{change:function(e){var i=t.articleForm.is_public,a=e.target,r=!!a.checked;if(Array.isArray(i)){var s=t._i(i,"1");a.checked?s<0&&t.$set(t.articleForm,"is_public",i.concat(["1"])):s>-1&&t.$set(t.articleForm,"is_public",i.slice(0,s).concat(i.slice(s+1)))}else t.$set(t.articleForm,"is_public",r)}}}),t._v(" "),i("span",{staticClass:"custom-control-label"},[t._v(t._s(t.trans("post.article_is_public")))])])]),t._v(" "),i("div",{staticClass:"form-group"},[i("file-upload-input",{attrs:{"button-text":t.trans("general.upload_document"),token:t.articleForm.upload_token,module:"article","clear-file":t.clearAttachment,"module-id":t.module_id}})],1)]),t._v(" "),i("div",{staticClass:"col-12 col-sm-6"},[i("div",{staticClass:"form-group"},[i("html-editor",{attrs:{name:"description",model:t.articleForm.description,height:"300",isUpdate:!!t.uuid},on:{"update:model":function(e){return t.$set(t.articleForm,"description",e)},clearErrors:function(e){return t.articleForm.errors.clear("description")}}}),t._v(" "),i("show-error",{attrs:{"form-name":t.articleForm,"prop-name":"description"}})],1)])]),t._v(" "),i("div",{staticClass:"card-footer text-right"},[i("router-link",{directives:[{name:"show",rawName:"v-show",value:t.uuid,expression:"uuid"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/post/article"}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),t.uuid?t._e():i("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(e){return t.$emit("cancel")}}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),i("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t.uuid?i("span",[t._v(t._s(t.trans("general.update")))]):i("span",[t._v(t._s(t.trans("general.save")))])])],1)]),t._v(" "),t.showArticleTypeModal?i("transition",{attrs:{name:"modal"}},[i("div",{staticClass:"modal-mask"},[i("div",{staticClass:"modal-wrapper"},[i("div",{staticClass:"modal-container modal-lg"},[i("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                            "+t._s(t.trans("post.add_new_article_type"))+"\n                            "),i("span",{staticClass:"float-right pointer",on:{click:function(e){t.showArticleTypeModal=!1}}},[t._v("x")])]}))],2),t._v(" "),i("div",{staticClass:"modal-body"},[t._t("body",(function(){return[i("article-type-form",{on:{completed:t.getPreRequisite,cancel:function(e){t.showArticleTypeModal=!1}}}),t._v(" "),i("div",{staticClass:"clearfix"})]}))],2)])])])]):t._e()],1)}),[],!1,null,null,null).exports},28120:(t,e,i)=>{"use strict";i.r(e),i.d(e,{default:()=>n});var a=i(601),r=i(31269);const s={components:{articleForm:a.Z,articleDetail:r.Z},data:function(){return{articles:{total:0,data:[]},filter:{sort_by:"date_of_article",order:"desc",keyword:"",article_type_id:[],date_of_article_start_date:"",date_of_article_end_date:"",page_length:helper.getConfig("page_length")},orderByOptions:[{value:"date_of_article",translation:i18n.post.date_of_article},{value:"title",translation:i18n.post.article_title}],article_types:[],selected_article_types:null,showFilterPanel:!1,showCreatePanel:!1,help_topic:"",showUuid:"",showModal:!1}},mounted:function(){helper.hasPermission("list-article")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getArticles(),helper.showDemoNotification(["post"])},methods:{hasPermission:function(t){return helper.hasPermission(t)},showAction:function(t){this.showUuid=t.uuid,this.showModal=!0},getEmployeeName:function(t){return helper.getEmployeeName(t)},getEmployeeDesignationOnDate:function(t,e){return helper.getEmployeeDesignationOnDate(t,e)},getArticles:function(t){var e=this,i=this.$loading.show();"number"!=typeof t&&(t=1),this.filter.date_of_article_start_date=helper.toDate(this.filter.date_of_article_start_date),this.filter.date_of_article_end_date=helper.toDate(this.filter.date_of_article_end_date);var a=helper.getFilterURL(this.filter);axios.get("/api/article?page="+t+a).then((function(t){e.articles=t.articles,e.article_types=t.filters.article_types,i.hide()})).catch((function(t){i.hide(),helper.showErrorMsg(t)}))},editArticle:function(t){this.$router.push("/post/article/"+t.uuid+"/edit")},confirmDelete:function(t){var e=this;return function(i){return e.deleteArticle(t)}},deleteArticle:function(t){var e=this,i=this.$loading.show();axios.delete("/api/article/"+t.uuid).then((function(t){toastr.success(t.message),e.getArticles(),i.hide()})).catch((function(t){i.hide(),helper.showErrorMsg(t)}))},getConfig:function(t){return helper.getConfig(t)},print:function(){var t=this.$loading.show();axios.post("/api/article/print",{filter:this.filter}).then((function(e){var i=window.open("/print");t.hide(),i.document.write(e)})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},pdf:function(){var t=this,e=this.$loading.show();axios.post("/api/article/pdf",{filter:this.filter}).then((function(i){e.hide(),window.open("/download/report/"+i+"?token="+t.authToken)})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},onArticleTypeSelect:function(t){this.filter.article_type_id.push(t.id)},onArticleTypeRemove:function(t){this.filter.article_type_id.splice(this.filter.article_type_id.indexOf(t.id),1)}},filters:{moment:function(t){return helper.formatDate(t)},momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{"filter.sort_by":function(t){this.getArticles()},"filter.order":function(t){this.getArticles()},"filter.page_length":function(t){this.getArticles()}},computed:{authToken:function(){return helper.getAuthToken()}}};const n=(0,i(51900).Z)(s,(function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("div",[i("div",{staticClass:"page-titles"},[i("div",{staticClass:"row"},[i("div",{staticClass:"col-12 col-sm-6"},[i("h3",{staticClass:"text-themecolor"},[t._v(t._s(t.trans("post.article"))+" \n                    "),t.articles.total?i("span",{staticClass:"card-subtitle d-none d-sm-inline"},[t._v(t._s(t.trans("general.total_result_found",{count:t.articles.total,from:t.articles.from,to:t.articles.to})))]):i("span",{staticClass:"card-subtitle d-none d-sm-inline"},[t._v(t._s(t.trans("general.no_result_found")))])])]),t._v(" "),i("div",{staticClass:"col-12 col-sm-6"},[i("div",{staticClass:"action-buttons pull-right"},[t.articles.total&&!t.showCreatePanel&&t.hasPermission("create-article")?i("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("general.add_new"),expression:"trans('general.add_new')"}],staticClass:"btn btn-info btn-sm",on:{click:function(e){t.showCreatePanel=!t.showCreatePanel}}},[i("i",{staticClass:"fas fa-plus"}),t._v(" "),i("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("post.add_new_article")))])]):t._e(),t._v(" "),t.showFilterPanel?t._e():i("button",{staticClass:"btn btn-info btn-sm",on:{click:function(e){t.showFilterPanel=!t.showFilterPanel}}},[i("i",{staticClass:"fas fa-filter"}),t._v(" "),i("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("general.filter")))])]),t._v(" "),i("sort-by",{attrs:{"order-by-options":t.orderByOptions,"sort-by":t.filter.sort_by,order:t.filter.order},on:{updateSortBy:function(e){t.filter.sort_by=e},updateOrder:function(e){t.filter.order=e}}}),t._v(" "),i("div",{staticClass:"btn-group"},[i("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("general.more_option"),expression:"trans('general.more_option')"}],staticClass:"btn btn-info btn-sm dropdown-toggle no-caret ",attrs:{type:"button",role:"menu",id:"moreOption","data-toggle":"dropdown","aria-haspopup":"true","aria-expanded":"false"}},[i("i",{staticClass:"fas fa-ellipsis-h"}),t._v(" "),i("span",{staticClass:"d-none d-sm-inline"})]),t._v(" "),i("div",{class:["dropdown-menu","ltr"==t.getConfig("direction")?"dropdown-menu-right":""],attrs:{"aria-labelledby":"moreOption"}},[i("button",{staticClass:"dropdown-item custom-dropdown",on:{click:t.print}},[i("i",{staticClass:"fas fa-print"}),t._v(" "+t._s(t.trans("general.print")))]),t._v(" "),i("button",{staticClass:"dropdown-item custom-dropdown",on:{click:t.pdf}},[i("i",{staticClass:"fas fa-file-pdf"}),t._v(" "+t._s(t.trans("general.generate_pdf")))])])]),t._v(" "),i("help-button",{on:{clicked:function(e){t.help_topic="post.article"}}})],1)])])]),t._v(" "),i("div",{staticClass:"container-fluid"},[i("transition",{attrs:{name:"fade"}},[t.showFilterPanel?i("div",{staticClass:"card card-form"},[i("div",{staticClass:"card-body"},[i("h4",{staticClass:"card-title"},[t._v(t._s(t.trans("general.filter")))]),t._v(" "),i("div",{staticClass:"row"},[i("div",{staticClass:"col-12 col-sm-3"},[i("div",{staticClass:"form-group"},[i("label",{attrs:{for:""}},[t._v(t._s(t.trans("post.article_type")))]),t._v(" "),i("v-select",{attrs:{label:"name","track-by":"id",name:"article_type_id",id:"article_type_id",options:t.article_types,placeholder:t.trans("post.select_article_type"),multiple:!0,"close-on-select":!1,"clear-on-select":!1,"hide-selected":!0,selected:t.selected_article_types},on:{select:t.onArticleTypeSelect,remove:t.onArticleTypeRemove},model:{value:t.selected_article_types,callback:function(e){t.selected_article_types=e},expression:"selected_article_types"}},[t.article_types.length?t._e():i("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[t._v("\n                                        "+t._s(t.trans("general.no_option_found"))+"\n                                    ")])])],1)]),t._v(" "),i("div",{staticClass:"col-12 col-sm-3"},[i("div",{staticClass:"form-group"},[i("label",{attrs:{for:""}},[t._v(t._s(t.trans("post.article_keyword")))]),t._v(" "),i("input",{directives:[{name:"model",rawName:"v-model",value:t.filter.keyword,expression:"filter.keyword"}],staticClass:"form-control",attrs:{name:"keyword"},domProps:{value:t.filter.keyword},on:{input:function(e){e.target.composing||t.$set(t.filter,"keyword",e.target.value)}}})])]),t._v(" "),i("div",{staticClass:"col-12 col-sm-6"},[i("date-range-picker",{attrs:{"start-date":t.filter.date_of_article_start_date,"end-date":t.filter.date_of_article_end_date,label:t.trans("post.date_of_article_between")},on:{"update:startDate":function(e){return t.$set(t.filter,"date_of_article_start_date",e)},"update:start-date":function(e){return t.$set(t.filter,"date_of_article_start_date",e)},"update:endDate":function(e){return t.$set(t.filter,"date_of_article_end_date",e)},"update:end-date":function(e){return t.$set(t.filter,"date_of_article_end_date",e)}}})],1)]),t._v(" "),i("div",{staticClass:"card-footer text-right"},[i("button",{staticClass:"btn btn-danger",attrs:{type:"button"},on:{click:function(e){t.showFilterPanel=!1}}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),i("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"button"},on:{click:t.getArticles}},[t._v(t._s(t.trans("general.filter")))])])])]):t._e()]),t._v(" "),t.hasPermission("create-article")?i("transition",{attrs:{name:"fade"}},[t.showCreatePanel?i("div",{staticClass:"card card-form"},[i("div",{staticClass:"card-body"},[i("h4",{staticClass:"card-title"},[t._v(t._s(t.trans("post.add_new_article")))]),t._v(" "),i("article-form",{on:{completed:t.getArticles,cancel:function(e){t.showCreatePanel=!t.showCreatePanel}}})],1)]):t._e()]):t._e(),t._v(" "),i("div",{staticClass:"card"},[i("div",{staticClass:"card-body"},[t.articles.total?i("div",{staticClass:"table-responsive"},[i("table",{staticClass:"table table-sm"},[i("thead",[i("tr",[i("th",[t._v(t._s(t.trans("post.article_type")))]),t._v(" "),i("th",[t._v(t._s(t.trans("post.article_title")))]),t._v(" "),i("th",[t._v(t._s(t.trans("post.date_of_article")))]),t._v(" "),i("th",[t._v(t._s(t.trans("post.article_is_public")))]),t._v(" "),i("th",[t._v(t._s(t.trans("post.article_posted_by")))]),t._v(" "),i("th",[t._v(t._s(t.trans("general.created_at")))]),t._v(" "),i("th",{staticClass:"table-option"},[t._v(t._s(t.trans("general.action")))])])]),t._v(" "),i("tbody",t._l(t.articles.data,(function(e){return i("tr",[i("td",{domProps:{textContent:t._s(e.article_type.name)}}),t._v(" "),i("td",{domProps:{textContent:t._s(e.title)}}),t._v(" "),i("td",[t._v(t._s(t._f("moment")(e.date_of_article)))]),t._v(" "),i("td",[e.is_public?i("span",[i("i",{staticClass:"fas fa-check"})]):i("span",[i("i",{staticClass:"fas fa-times"})])]),t._v(" "),i("td",[t._v(t._s(t.getEmployeeName(e.user.employee))+" "),i("br"),t._v(" "+t._s(t.getEmployeeDesignationOnDate(e.user.employee,e.date_of_article)))]),t._v(" "),i("td",[t._v(t._s(t._f("momentDateTime")(e.created_at)))]),t._v(" "),i("td",{staticClass:"table-option"},[i("div",{staticClass:"btn-group"},[i("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("post.view_article"),expression:"trans('post.view_article')"}],staticClass:"btn btn-success btn-sm",on:{click:function(i){return i.preventDefault(),t.showAction(e)}}},[i("i",{staticClass:"fas fa-arrow-circle-right"})]),t._v(" "),t.hasPermission("edit-article")?i("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("post.edit_article"),expression:"trans('post.edit_article')"}],staticClass:"btn btn-info btn-sm",on:{click:function(i){return i.preventDefault(),t.editArticle(e)}}},[i("i",{staticClass:"fas fa-edit"})]):t._e(),t._v(" "),t.hasPermission("delete-article")?i("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:t.confirmDelete(e)},expression:"{ok: confirmDelete(article)}"},{name:"tooltip",rawName:"v-tooltip",value:t.trans("post.delete_article"),expression:"trans('post.delete_article')"}],key:e.id,staticClass:"btn btn-danger btn-sm"},[i("i",{staticClass:"fas fa-trash"})]):t._e()])])])})),0)])]):t._e(),t._v(" "),t.articles.total?t._e():i("module-info",{attrs:{module:"post",title:"article_module_title",description:"article_module_description",icon:"list"}},[i("div",{attrs:{slot:"btn"},slot:"btn"},[!t.showCreatePanel&&t.hasPermission("create-article")?i("button",{staticClass:"btn btn-info btn-md",on:{click:function(e){t.showCreatePanel=!t.showCreatePanel}}},[i("i",{staticClass:"fas fa-plus"}),t._v(" "+t._s(t.trans("general.add_new")))]):t._e()])]),t._v(" "),i("pagination-record",{attrs:{"page-length":t.filter.page_length,records:t.articles},on:{"update:pageLength":function(e){return t.$set(t.filter,"page_length",e)},"update:page-length":function(e){return t.$set(t.filter,"page_length",e)},updateRecords:t.getArticles}})],1)])],1),t._v(" "),t.showModal?i("article-detail",{attrs:{uuid:t.showUuid},on:{close:function(e){t.showModal=!1}}}):t._e(),t._v(" "),i("right-panel",{attrs:{topic:t.help_topic}})],1)}),[],!1,null,null,null).exports},31269:(t,e,i)=>{"use strict";i.d(e,{Z:()=>r});const a={components:{},props:["uuid","url"],mounted:function(){this.uuid&&this.get()},data:function(){return{article:[],attachments:[]}},methods:{get:function(){var t=this,e=this.$loading.show(),i=this.url?"/api"+this.url:"/api/article/"+this.uuid;axios.get(i).then((function(i){t.article=i.article,t.attachments=i.attachments,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},getEmployeeName:function(t){return helper.getEmployeeName(t)},getEmployeeDesignation:function(t,e){return helper.getEmployeeDesignation(t,e)}},computed:{authToken:function(){return helper.getAuthToken()}},filters:{momentDateTime:function(t){return helper.formatDateTime(t)},moment:function(t){return helper.formatDate(t)}}};const r=(0,i(51900).Z)(a,(function(){var t=this,e=t.$createElement,i=t._self._c||e;return i("transition",{attrs:{name:"modal"}},[i("div",{staticClass:"modal-mask"},[i("div",{staticClass:"modal-wrapper"},[i("div",{staticClass:"modal-container modal-lg"},[t.article.id?i("div",{staticClass:"modal-header"},[t._t("header",(function(){return[i("span",[t._v(t._s(t.article.title)+" "),t.article.is_public?i("span",{staticClass:"label label-success"},[t._v(t._s(t.trans("post.article_public")))]):t._e()]),t._v(" "),i("span",{staticClass:"float-right pointer",on:{click:function(e){return t.$emit("close")}}},[t._v("x")])]}))],2):t._e(),t._v(" "),t.article.id?i("div",{staticClass:"modal-body"},[t._t("body",(function(){return[i("h6",{staticClass:"card-title"},[t._v("\n                            "+t._s(t.trans("post.date_of_article"))+": "+t._s(t._f("moment")(t.article.date_of_article))+" \n                            "),t.article.user?i("p",{staticClass:"pull-right"},[i("strong",[t._v(t._s(t.trans("post.article_posted_by"))+":")]),t._v(" "+t._s(t.getEmployeeName(t.article.user.employee))+" "+t._s(t.getEmployeeDesignation(t.article.user.employee,t.article.date_of_article))+"\n                            ")]):t._e()]),t._v(" "),i("div",{staticClass:"m-t-20 html-view",domProps:{innerHTML:t._s(t.article.description)}}),t._v(" "),t.attachments.length?i("div",[i("ul",{staticClass:"m-t-10 upload-file-list"},t._l(t.attachments,(function(e){return i("li",{staticClass:"upload-file-list-item"},[i("a",{staticClass:"no-link-color",attrs:{href:"/post/article/"+t.article.uuid+"/attachment/"+e.uuid+"/download?token="+t.authToken}},[i("i",{class:["file-icon","fas","fa-lg",e.file_info.icon]}),t._v(" "),i("span",{staticClass:"upload-file-list-item-size"},[t._v(t._s(e.file_info.size))]),t._v(" "+t._s(e.user_filename))])])})),0)]):t._e(),t._v(" "),i("hr"),t._v(" "),i("p",[i("i",{staticClass:"far fa-clock"}),t._v(" "),i("small",[t._v(t._s(t.trans("general.created_at"))+" "+t._s(t._f("momentDateTime")(t.article.created_at)))]),t._v(" "),i("span",{staticClass:"pull-right"},[i("i",{staticClass:"far fa-clock"}),t._v(" "),i("small",[t._v(t._s(t.trans("general.updated_at"))+" "+t._s(t._f("momentDateTime")(t.article.updated_at)))])])])]}))],2):t._e()])])])])}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=index.js.map?id=213c2fa8b11805e1578c