(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[6792],{42585:(e,s,a)=>{"use strict";a.d(s,{Z:()=>i});var t=a(94015),n=a.n(t),r=a(23645),o=a.n(r)()(n());o.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/exam/schedule/form.vue"],names:[],mappings:"AAsZA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="scheduleForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'exam.exam\')}} </label> <button type="button" class="btn btn-xs btn-info pull-right" v-if="hasPermission(\'create-exam\')" @click="showExamModal = true">{{trans(\'general.add_new\')}}</button>\n                        <v-select label="name" v-model="selected_exam" name="exam_id" id="exam_id" :options="exams" :placeholder="trans(\'exam.select_exam\')" @select="onExamSelect" @close="scheduleForm.errors.clear(\'exam_id\')" @remove="scheduleForm.exam_id = \'\'" :disabled="id ? true : false">\n                            <div class="multiselect__option" slot="afterList" v-if="!exams.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="scheduleForm" prop-name="exam_id"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'academic.batch\')}} </label>\n                        <v-select label="name" v-model="selected_batch" group-values="batches" group-label="course_group" :group-select="false" name="batch_id" id="batch_id" :options="batches" :placeholder="trans(\'academic.select_batch\')" @select="onBatchSelect" @close="scheduleForm.errors.clear(\'batch_id\')" @remove="scheduleForm.batch_id = \'\'" :disabled="id ? true : false">\n                            <div class="multiselect__option" slot="afterList" v-if="!batches.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="scheduleForm" prop-name="batch_id"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'exam.grade\')}} </label>\n                        <v-select label="name" v-model="selected_exam_grade" name="exam_grade_id" id="exam_grade_id" :options="exam_grades" :placeholder="trans(\'exam.select_grade\')" @select="onExamGradeSelect" @close="scheduleForm.errors.clear(\'exam_grade_id\')" @remove="scheduleForm.exam_grade_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!exam_grades.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="scheduleForm" prop-name="exam_grade_id"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'exam.assessment\')}} </label>\n                        <v-select label="name" v-model="selected_exam_assessment" name="exam_assessment_id" id="exam_assessment_id" :options="exam_assessments" :placeholder="trans(\'exam.select_assessment\')" @select="onExamAssessmentSelect" @close="scheduleForm.errors.clear(\'exam_assessment_id\')" @remove="scheduleForm.exam_assessment_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!exam_assessments.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="scheduleForm" prop-name="exam_assessment_id"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'exam.overall_pass_percentage\')}}</label>\n                        <input class="form-control" type="text" v-model="scheduleForm.overall_pass_percentage" name="overall_pass_percentage" :placeholder="trans(\'exam.overall_pass_percentage\')">\n                        <show-error :form-name="scheduleForm" prop-name="overall_pass_percentage"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <switches class="m-l-20" v-model="scheduleForm.show_result" theme="bootstrap" color="success"></switches> {{trans(\'exam.show_result\')}}\n                    </div>\n                </div>\n            </div>\n            <div class="row m-b-10" v-if="scheduleForm.records.length && exam_assessment">\n                <div class="col-12 col-sm-3">\n\n                </div>\n                <div class="col-12 col-sm-3">\n\n                </div>\n                <div class="col-12 col-sm-3" v-for="detail in exam_assessment.details">\n                    {{detail.name}} {{trans(\'exam.observation_detail_max_mark\')}}\n                </div>\n            </div>\n\n            <div class="row" v-for="(record,index) in scheduleForm.records">\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        {{record.subject_name}}\n                        <div class="form-group">\n                            <label class="custom-control custom-checkbox">\n                                <input type="checkbox" class="custom-control-input" value="1" v-model="record.has_no_exam">\n                                <span class="custom-control-label">{{trans(\'academic.subject_has_no_exam\')}}</span>\n                            </label>\n                        </div>\n                    </div>\n                </div>\n                <template v-if="! record.has_no_exam">\n                    <div class="col-12 col-sm-3">\n                        <div class="form-group">\n                            <datepicker v-model="record.date" :bootstrapStyling="true" @selected="scheduleForm.errors.clear(getScheduleDateName(index))" :placeholder="trans(\'exam.schedule_date\')"></datepicker>\n                            <show-error :form-name="scheduleForm" :prop-name="getScheduleDateName(index)"></show-error>\n                        </div>\n                    </div>\n                    <div class="col-12 col-sm-3" v-for="(detail,idx) in record.assessment_details">\n                        <div class="row">\n                            <div class="col-12 col-sm-3">\n                                <div class="form-group">\n                                    <label class="custom-control custom-checkbox">\n                                        <input type="checkbox" class="custom-control-input" value="1" v-model="detail.is_applicable">\n                                        <span class="custom-control-label">{{trans(\'assessment.is_applicable\')}}</span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class="col-12 col-sm-9" v-if="detail.is_applicable">\n                                <div class="form-group">\n                                    <input class="form-control" type="text" v-model="detail.max_mark" :name="getDetailMaxMark(index, idx)" :placeholder="trans(\'exam.assessment_detail_max_mark\')">\n                                    <show-error :form-name="scheduleForm" :prop-name="getDetailMaxMark(index, idx)"></show-error>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </template>\n            </div>\n            <div class="card-footer text-right">\n                <router-link to="/exam/schedule" class="btn btn-danger waves-effect waves-light ">{{trans(\'general.cancel\')}}</router-link>\n                <button type="submit" class="btn btn-info waves-effect waves-light">\n                    <span v-if="id">{{trans(\'general.update\')}}</span>\n                    <span v-else>{{trans(\'general.save\')}}</span>\n                </button>\n            </div>\n        </form>\n\n        <transition name="modal" v-if="showExamModal">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'exam.add_new_exam\')}}\n                                <span class="float-right pointer" @click="showExamModal = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <exam-form @completed="getPreRequisite" @cancel="showExamModal = false"></exam-form>\n                                <div class="clearfix"></div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n    </div>\n</template>\n\n\n<script>\n    import examForm from \'../form\'\n\n    export default {\n        components: {examForm},\n        data() {\n            return {\n                scheduleForm: new Form({\n                    batch_id: \'\',\n                    exam_id: \'\',\n                    exam_grade_id: \'\',\n                    exam_assessment_id: \'\',\n                    description: \'\',\n                    overall_pass_percentage: \'\',\n                    show_result: 0,\n                    records: []\n                }),\n                all_batches: [],\n                batches: [],\n                selected_batch: null,\n                exams: [],\n                selected_exam: null,\n                exam_grades: [],\n                selected_exam_grade: null,\n                exam_assessments: [],\n                selected_exam_assessment: null,\n                exam_assessments: [],\n                batch_with_subjects: [],\n                exam_assessment_with_details: [],\n                exam_assessment: {},\n                showExamModal: false\n            };\n        },\n        props: [\'id\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-exam-schedule\') && !helper.hasPermission(\'edit-exam-schedule\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getScheduleDateName(index){\n                return index+\'_schedule_date\';\n            },\n            getDetailMaxMark(index, idx){\n                return index+\'_\'+idx+\'_max_mark\';\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/exam/schedule/pre-requisite\')\n                    .then(response => {\n                        this.all_batches = response.batches;\n                        this.exams = response.exams;\n                        this.exam_grades = response.exam_grades;\n                        this.exam_assessments = response.exam_assessments;\n                        this.batch_with_subjects = response.batch_with_subjects;\n                        this.exam_assessment_with_details = response.exam_assessment_with_details;\n\n                        if(this.id)\n                            this.get();\n\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            getSubjects(){\n                let loader = this.$loading.show();\n\n                let batch = this.batch_with_subjects.find(o => o.id == this.scheduleForm.batch_id);\n\n                if (typeof batch == \'undefined\') {\n                    loader.hide();\n                    return;\n                }\n\n                this.scheduleForm.records = [];\n\n                batch.subjects.forEach(subject => {\n                    this.scheduleForm.records.push({\n                        subject_id: subject.id,\n                        subject_name: subject.name+\' (\'+subject.code+\')\',\n                        has_no_exam: subject.has_no_exam,\n                        date: \'\',\n                        assessment_details: []\n                    })\n                });\n                this.selected_exam_assessment = null;\n                this.scheduleForm.exam_assessment_id = \'\';\n                \n                loader.hide();\n            },\n            proceed(){\n                if(this.id)\n                    this.update();\n                else\n                    this.store();\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.scheduleForm.post(\'/api/exam/schedule\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.selected_batch = null;\n                        this.selected_exam = null;\n                        this.selected_exam_grade = null;\n                        this.selected_exam_assessment = null;\n                        this.scheduleForm.records = [];\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/exam/schedule/\'+this.id)\n                    .then(response => {\n                        this.selected_exam = response.selected_exam;\n                        response = response.exam_schedule;\n\n                        this.scheduleForm.overall_pass_percentage = response.options.overall_pass_percentage;\n                        this.scheduleForm.show_result = response.options.show_result;\n\n                        if (this.selected_exam && this.selected_exam.course_group_id)\n                            this.batches = this.all_batches.filter(o => o.course_group === this.selected_exam.course_group_name);\n                        else\n                            this.batches = this.all_batches;\n\n                        this.scheduleForm.batch_id = response.batch_id;\n                        this.selected_batch = this.scheduleForm.batch_id ? {id: response.batch_id, name: response.batch.course.name+\' \'+response.batch.name} : null;\n\n                        this.scheduleForm.exam_id = response.exam_id;\n\n                        this.scheduleForm.exam_grade_id = response.exam_grade_id;\n                        this.selected_exam_grade = this.scheduleForm.exam_grade_id ? {id: response.exam_grade_id, name: response.grade.name} : null;\n\n                        this.scheduleForm.exam_assessment_id = response.exam_assessment_id;\n                        this.selected_exam_assessment = this.scheduleForm.exam_assessment_id ? {id: response.exam_assessment_id, name: response.assessment.name} : null;\n                        this.exam_assessment = this.scheduleForm.exam_assessment_id ? response.assessment : {};\n\n                        let batch = this.batch_with_subjects.find(o => o.id == this.scheduleForm.batch_id);\n                        this.scheduleForm.records = [];\n\n                        let record = {};\n                        batch.subjects.forEach(subject => {\n                            record = response.records.find(o => o.subject_id == subject.id);\n\n                            if (typeof record == \'undefined\') {\n                                record = {\n                                    options: {has_no_exam: 0},\n                                    date: \'\'\n                                }\n                            }\n\n                            let assessment_details = [];\n                            if (record.options.assessment_details && Array.isArray(record.options.assessment_details)) {\n                                record.options.assessment_details.forEach(detail => {\n                                    assessment_details.push({\n                                        id: detail.id,\n                                        is_applicable: detail.is_applicable,\n                                        max_mark: detail.max_mark,\n                                        pass_percentage: detail.pass_percentage\n                                    })\n                                })\n                            } else {\n                                response.assessment.details.forEach(detail => {\n                                    assessment_details.push({\n                                        id: detail.id,\n                                        is_applicable: true,\n                                        max_mark: detail.max_mark,\n                                        pass_percentage: detail.pass_percentage\n                                    })\n                                })\n                            }\n\n                            this.scheduleForm.records.push({\n                                subject_id: subject.id,\n                                subject_name: subject.name+\' (\'+subject.code+\')\',\n                                has_no_exam: record.date ? 0 : 1,\n                                date: record.date,\n                                assessment_details: assessment_details\n                            });\n                        });\n                        \n                        this.module_id = response.id;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        // this.$router.push(\'/exam/schedule\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.scheduleForm.patch(\'/api/exam/schedule/\'+this.id)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/exam/schedule\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            onBatchSelect(selectedOption){\n                this.scheduleForm.batch_id = selectedOption.id;\n            },\n            onExamSelect(selectedOption){\n                this.scheduleForm.batch_id = \'\';\n                this.selected_batch = null;\n                this.scheduleForm.records = [];\n                if (selectedOption.course_group_id)\n                    this.batches = this.all_batches.filter(o => o.course_group === selectedOption.course_group_name);\n                else\n                    this.batches = this.all_batches;\n                this.scheduleForm.exam_id = selectedOption.id;\n            },\n            onExamGradeSelect(selectedOption){\n                this.scheduleForm.exam_grade_id = selectedOption.id;\n            },\n            onExamAssessmentSelect(selectedOption){\n                this.scheduleForm.exam_assessment_id = selectedOption.id;\n                this.exam_assessment = this.exam_assessment_with_details.find(o => o.id == selectedOption.id);\n                this.scheduleForm.records.forEach(record => {\n                    record.assessment_details = [];\n                    this.exam_assessment.details.forEach(detail => {\n                        record.assessment_details.push({\n                            id: detail.id,\n                            is_applicable: true,\n                            max_mark: detail.max_mark,\n                            pass_percentage: detail.pass_percentage\n                        });\n                    });\n                })\n            },\n            hideExamForm(){\n                $(\'.add-exam-form\').modal(\'hide\');\n            }\n        },\n        watch: {\n            \'scheduleForm.batch_id\': function(val) {\n                if (!this.id)\n                    this.getSubjects();\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const i=o},34819:(e,s,a)=>{"use strict";a.d(s,{Z:()=>n});const t={components:{},data:function(){return{examForm:new Form({name:"",exam_term_id:"",description:""}),exam_terms:[],selected_exam_term:null}},props:["id"],mounted:function(){helper.hasPermission("create-exam")||helper.hasPermission("edit-exam")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getPreRequisite()},methods:{proceed:function(){this.id?this.update():this.store()},getPreRequisite:function(){var e=this,s=this.$loading.show();axios.get("/api/exam/pre-requisite").then((function(a){e.exam_terms=a.exam_terms,e.id&&e.get(),s.hide()})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},store:function(){var e=this,s=this.$loading.show();this.examForm.post("/api/exam").then((function(a){toastr.success(a.message),e.selected_exam_term=null,e.$emit("completed"),s.hide()})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,s=this.$loading.show();axios.get("/api/exam/"+this.id).then((function(a){e.examForm.name=a.name,e.examForm.exam_term_id=a.exam_term_id,e.selected_exam_term=a.exam_term_id?{id:a.exam_term_id,name:a.term.name+" ("+a.term.course_group.name+")"}:null,e.examForm.description=a.description,s.hide()})).catch((function(a){s.hide(),helper.showErrorMsg(a),e.$router.push("/exam")}))},update:function(){var e=this,s=this.$loading.show();this.examForm.patch("/api/exam/"+this.id).then((function(a){toastr.success(a.message),s.hide(),e.$router.push("/exam")})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},getConfig:function(e){return helper.getConfig(e)},onExamTermSelect:function(e){this.examForm.exam_term_id=e.id}}};const n=(0,a(51900).Z)(t,(function(){var e=this,s=e.$createElement,a=e._self._c||s;return a("form",{on:{submit:function(s){return s.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(s){return e.examForm.errors.clear(s.target.name)}}},[a("div",{staticClass:"row"},[a("div",{staticClass:"col-12 col-sm-4"},[a("div",{staticClass:"form-group"},[a("label",{attrs:{for:""}},[e._v(e._s(e.trans("exam.term"))+" ")]),e._v(" "),a("v-select",{attrs:{label:"name",name:"exam_term_id",id:"exam_term_id",options:e.exam_terms,placeholder:e.trans("exam.select_term")},on:{select:e.onExamTermSelect,close:function(s){return e.examForm.errors.clear("exam_term_id")},remove:function(s){e.examForm.exam_term_id=""}},model:{value:e.selected_exam_term,callback:function(s){e.selected_exam_term=s},expression:"selected_exam_term"}},[e.exam_terms.length?e._e():a("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                        "+e._s(e.trans("general.no_option_found"))+"\n                    ")])]),e._v(" "),a("show-error",{attrs:{"form-name":e.examForm,"prop-name":"exam_term_id"}})],1)]),e._v(" "),a("div",{staticClass:"col-12 col-sm-4"},[a("div",{staticClass:"form-group"},[a("label",{attrs:{for:""}},[e._v(e._s(e.trans("exam.exam_name")))]),e._v(" "),a("input",{directives:[{name:"model",rawName:"v-model",value:e.examForm.name,expression:"examForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:e.trans("exam.exam_name")},domProps:{value:e.examForm.name},on:{input:function(s){s.target.composing||e.$set(e.examForm,"name",s.target.value)}}}),e._v(" "),a("show-error",{attrs:{"form-name":e.examForm,"prop-name":"name"}})],1)]),e._v(" "),a("div",{staticClass:"col-12 col-sm-4"},[a("div",{staticClass:"form-group"},[a("label",{attrs:{for:""}},[e._v(e._s(e.trans("exam.exam_description")))]),e._v(" "),a("input",{directives:[{name:"model",rawName:"v-model",value:e.examForm.description,expression:"examForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:e.trans("exam.exam_description")},domProps:{value:e.examForm.description},on:{input:function(s){s.target.composing||e.$set(e.examForm,"description",s.target.value)}}}),e._v(" "),a("show-error",{attrs:{"form-name":e.examForm,"prop-name":"description"}})],1)])]),e._v(" "),a("div",{staticClass:"card-footer text-right"},[a("router-link",{directives:[{name:"show",rawName:"v-show",value:e.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/exam"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),e.id?e._e():a("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(s){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),a("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.id?a("span",[e._v(e._s(e.trans("general.update")))]):a("span",[e._v(e._s(e.trans("general.save")))])])],1)])}),[],!1,null,null,null).exports},89070:(e,s,a)=>{"use strict";a.r(s),a.d(s,{default:()=>n});const t={components:{examScheduleForm:a(33606).Z},data:function(){return{}},mounted:function(){helper.hasPermission("create-exam-schedule")||(helper.notAccessibleMsg(),this.$router.push("/dashboard"))},methods:{},computed:{},filters:{},watch:{}};const n=(0,a(51900).Z)(t,(function(){var e=this,s=e.$createElement,a=e._self._c||s;return a("div",[a("div",{staticClass:"page-titles"},[a("div",{staticClass:"row"},[a("div",{staticClass:"col-12 col-sm-6"},[a("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("exam.add_new_schedule")))])]),e._v(" "),a("div",{staticClass:"col-12 col-sm-6"},[a("div",{staticClass:"action-buttons pull-right"},[a("button",{staticClass:"btn btn-info btn-sm",on:{click:function(s){return e.$router.push("/exam")}}},[a("i",{staticClass:"fas fa-list"}),e._v(" "),a("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("exam.exam")))])]),e._v(" "),a("button",{staticClass:"btn btn-info btn-sm",on:{click:function(s){return e.$router.push("/exam/schedule")}}},[a("i",{staticClass:"fas fa-list"}),e._v(" "),a("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("exam.schedule")))])])])])])]),e._v(" "),a("div",{staticClass:"container-fluid"},[a("div",{staticClass:"card card-form"},[a("div",{staticClass:"card-body p-t-20"},[a("exam-schedule-form")],1)])])])}),[],!1,null,null,null).exports},33606:(e,s,a)=>{"use strict";a.d(s,{Z:()=>c});function t(e,s,a){return s in e?Object.defineProperty(e,s,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[s]=a,e}const n={components:{examForm:a(34819).Z},data:function(){var e;return t(e={scheduleForm:new Form({batch_id:"",exam_id:"",exam_grade_id:"",exam_assessment_id:"",description:"",overall_pass_percentage:"",show_result:0,records:[]}),all_batches:[],batches:[],selected_batch:null,exams:[],selected_exam:null,exam_grades:[],selected_exam_grade:null,exam_assessments:[],selected_exam_assessment:null},"exam_assessments",[]),t(e,"batch_with_subjects",[]),t(e,"exam_assessment_with_details",[]),t(e,"exam_assessment",{}),t(e,"showExamModal",!1),e},props:["id"],mounted:function(){helper.hasPermission("create-exam-schedule")||helper.hasPermission("edit-exam-schedule")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getPreRequisite()},methods:{hasPermission:function(e){return helper.hasPermission(e)},getScheduleDateName:function(e){return e+"_schedule_date"},getDetailMaxMark:function(e,s){return e+"_"+s+"_max_mark"},getPreRequisite:function(){var e=this,s=this.$loading.show();axios.get("/api/exam/schedule/pre-requisite").then((function(a){e.all_batches=a.batches,e.exams=a.exams,e.exam_grades=a.exam_grades,e.exam_assessments=a.exam_assessments,e.batch_with_subjects=a.batch_with_subjects,e.exam_assessment_with_details=a.exam_assessment_with_details,e.id&&e.get(),s.hide()})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},getSubjects:function(){var e=this,s=this.$loading.show(),a=this.batch_with_subjects.find((function(s){return s.id==e.scheduleForm.batch_id}));void 0!==a?(this.scheduleForm.records=[],a.subjects.forEach((function(s){e.scheduleForm.records.push({subject_id:s.id,subject_name:s.name+" ("+s.code+")",has_no_exam:s.has_no_exam,date:"",assessment_details:[]})})),this.selected_exam_assessment=null,this.scheduleForm.exam_assessment_id="",s.hide()):s.hide()},proceed:function(){this.id?this.update():this.store()},store:function(){var e=this,s=this.$loading.show();this.scheduleForm.post("/api/exam/schedule").then((function(a){toastr.success(a.message),e.selected_batch=null,e.selected_exam=null,e.selected_exam_grade=null,e.selected_exam_assessment=null,e.scheduleForm.records=[],e.$emit("completed"),s.hide()})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,s=this.$loading.show();axios.get("/api/exam/schedule/"+this.id).then((function(a){e.selected_exam=a.selected_exam,a=a.exam_schedule,e.scheduleForm.overall_pass_percentage=a.options.overall_pass_percentage,e.scheduleForm.show_result=a.options.show_result,e.selected_exam&&e.selected_exam.course_group_id?e.batches=e.all_batches.filter((function(s){return s.course_group===e.selected_exam.course_group_name})):e.batches=e.all_batches,e.scheduleForm.batch_id=a.batch_id,e.selected_batch=e.scheduleForm.batch_id?{id:a.batch_id,name:a.batch.course.name+" "+a.batch.name}:null,e.scheduleForm.exam_id=a.exam_id,e.scheduleForm.exam_grade_id=a.exam_grade_id,e.selected_exam_grade=e.scheduleForm.exam_grade_id?{id:a.exam_grade_id,name:a.grade.name}:null,e.scheduleForm.exam_assessment_id=a.exam_assessment_id,e.selected_exam_assessment=e.scheduleForm.exam_assessment_id?{id:a.exam_assessment_id,name:a.assessment.name}:null,e.exam_assessment=e.scheduleForm.exam_assessment_id?a.assessment:{};var t=e.batch_with_subjects.find((function(s){return s.id==e.scheduleForm.batch_id}));e.scheduleForm.records=[];var n={};t.subjects.forEach((function(s){void 0===(n=a.records.find((function(e){return e.subject_id==s.id})))&&(n={options:{has_no_exam:0},date:""});var t=[];n.options.assessment_details&&Array.isArray(n.options.assessment_details)?n.options.assessment_details.forEach((function(e){t.push({id:e.id,is_applicable:e.is_applicable,max_mark:e.max_mark,pass_percentage:e.pass_percentage})})):a.assessment.details.forEach((function(e){t.push({id:e.id,is_applicable:!0,max_mark:e.max_mark,pass_percentage:e.pass_percentage})})),e.scheduleForm.records.push({subject_id:s.id,subject_name:s.name+" ("+s.code+")",has_no_exam:n.date?0:1,date:n.date,assessment_details:t})})),e.module_id=a.id,s.hide()})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},update:function(){var e=this,s=this.$loading.show();this.scheduleForm.patch("/api/exam/schedule/"+this.id).then((function(a){toastr.success(a.message),s.hide(),e.$router.push("/exam/schedule")})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},onBatchSelect:function(e){this.scheduleForm.batch_id=e.id},onExamSelect:function(e){this.scheduleForm.batch_id="",this.selected_batch=null,this.scheduleForm.records=[],e.course_group_id?this.batches=this.all_batches.filter((function(s){return s.course_group===e.course_group_name})):this.batches=this.all_batches,this.scheduleForm.exam_id=e.id},onExamGradeSelect:function(e){this.scheduleForm.exam_grade_id=e.id},onExamAssessmentSelect:function(e){var s=this;this.scheduleForm.exam_assessment_id=e.id,this.exam_assessment=this.exam_assessment_with_details.find((function(s){return s.id==e.id})),this.scheduleForm.records.forEach((function(e){e.assessment_details=[],s.exam_assessment.details.forEach((function(s){e.assessment_details.push({id:s.id,is_applicable:!0,max_mark:s.max_mark,pass_percentage:s.pass_percentage})}))}))},hideExamForm:function(){$(".add-exam-form").modal("hide")}},watch:{"scheduleForm.batch_id":function(e){this.id||this.getSubjects()}}};var r=a(93379),o=a.n(r),i=a(42585),l={insert:"head",singleton:!1};o()(i.Z,l);i.Z.locals;const c=(0,a(51900).Z)(n,(function(){var e=this,s=e.$createElement,a=e._self._c||s;return a("div",[a("form",{on:{submit:function(s){return s.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(s){return e.scheduleForm.errors.clear(s.target.name)}}},[a("div",{staticClass:"row"},[a("div",{staticClass:"col-12 col-sm-3"},[a("div",{staticClass:"form-group"},[a("label",{attrs:{for:""}},[e._v(e._s(e.trans("exam.exam"))+" ")]),e._v(" "),e.hasPermission("create-exam")?a("button",{staticClass:"btn btn-xs btn-info pull-right",attrs:{type:"button"},on:{click:function(s){e.showExamModal=!0}}},[e._v(e._s(e.trans("general.add_new")))]):e._e(),e._v(" "),a("v-select",{attrs:{label:"name",name:"exam_id",id:"exam_id",options:e.exams,placeholder:e.trans("exam.select_exam"),disabled:!!e.id},on:{select:e.onExamSelect,close:function(s){return e.scheduleForm.errors.clear("exam_id")},remove:function(s){e.scheduleForm.exam_id=""}},model:{value:e.selected_exam,callback:function(s){e.selected_exam=s},expression:"selected_exam"}},[e.exams.length?e._e():a("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),a("show-error",{attrs:{"form-name":e.scheduleForm,"prop-name":"exam_id"}})],1)]),e._v(" "),a("div",{staticClass:"col-12 col-sm-3"},[a("div",{staticClass:"form-group"},[a("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.batch"))+" ")]),e._v(" "),a("v-select",{attrs:{label:"name","group-values":"batches","group-label":"course_group","group-select":!1,name:"batch_id",id:"batch_id",options:e.batches,placeholder:e.trans("academic.select_batch"),disabled:!!e.id},on:{select:e.onBatchSelect,close:function(s){return e.scheduleForm.errors.clear("batch_id")},remove:function(s){e.scheduleForm.batch_id=""}},model:{value:e.selected_batch,callback:function(s){e.selected_batch=s},expression:"selected_batch"}},[e.batches.length?e._e():a("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),a("show-error",{attrs:{"form-name":e.scheduleForm,"prop-name":"batch_id"}})],1)]),e._v(" "),a("div",{staticClass:"col-12 col-sm-3"},[a("div",{staticClass:"form-group"},[a("label",{attrs:{for:""}},[e._v(e._s(e.trans("exam.grade"))+" ")]),e._v(" "),a("v-select",{attrs:{label:"name",name:"exam_grade_id",id:"exam_grade_id",options:e.exam_grades,placeholder:e.trans("exam.select_grade")},on:{select:e.onExamGradeSelect,close:function(s){return e.scheduleForm.errors.clear("exam_grade_id")},remove:function(s){e.scheduleForm.exam_grade_id=""}},model:{value:e.selected_exam_grade,callback:function(s){e.selected_exam_grade=s},expression:"selected_exam_grade"}},[e.exam_grades.length?e._e():a("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),a("show-error",{attrs:{"form-name":e.scheduleForm,"prop-name":"exam_grade_id"}})],1)]),e._v(" "),a("div",{staticClass:"col-12 col-sm-3"},[a("div",{staticClass:"form-group"},[a("label",{attrs:{for:""}},[e._v(e._s(e.trans("exam.assessment"))+" ")]),e._v(" "),a("v-select",{attrs:{label:"name",name:"exam_assessment_id",id:"exam_assessment_id",options:e.exam_assessments,placeholder:e.trans("exam.select_assessment")},on:{select:e.onExamAssessmentSelect,close:function(s){return e.scheduleForm.errors.clear("exam_assessment_id")},remove:function(s){e.scheduleForm.exam_assessment_id=""}},model:{value:e.selected_exam_assessment,callback:function(s){e.selected_exam_assessment=s},expression:"selected_exam_assessment"}},[e.exam_assessments.length?e._e():a("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),a("show-error",{attrs:{"form-name":e.scheduleForm,"prop-name":"exam_assessment_id"}})],1)]),e._v(" "),a("div",{staticClass:"col-12 col-sm-3"},[a("div",{staticClass:"form-group"},[a("label",{attrs:{for:""}},[e._v(e._s(e.trans("exam.overall_pass_percentage")))]),e._v(" "),a("input",{directives:[{name:"model",rawName:"v-model",value:e.scheduleForm.overall_pass_percentage,expression:"scheduleForm.overall_pass_percentage"}],staticClass:"form-control",attrs:{type:"text",name:"overall_pass_percentage",placeholder:e.trans("exam.overall_pass_percentage")},domProps:{value:e.scheduleForm.overall_pass_percentage},on:{input:function(s){s.target.composing||e.$set(e.scheduleForm,"overall_pass_percentage",s.target.value)}}}),e._v(" "),a("show-error",{attrs:{"form-name":e.scheduleForm,"prop-name":"overall_pass_percentage"}})],1)]),e._v(" "),a("div",{staticClass:"col-12 col-sm-3"},[a("div",{staticClass:"form-group"},[a("switches",{staticClass:"m-l-20",attrs:{theme:"bootstrap",color:"success"},model:{value:e.scheduleForm.show_result,callback:function(s){e.$set(e.scheduleForm,"show_result",s)},expression:"scheduleForm.show_result"}}),e._v(" "+e._s(e.trans("exam.show_result"))+"\n                ")],1)])]),e._v(" "),e.scheduleForm.records.length&&e.exam_assessment?a("div",{staticClass:"row m-b-10"},[a("div",{staticClass:"col-12 col-sm-3"}),e._v(" "),a("div",{staticClass:"col-12 col-sm-3"}),e._v(" "),e._l(e.exam_assessment.details,(function(s){return a("div",{staticClass:"col-12 col-sm-3"},[e._v("\n                "+e._s(s.name)+" "+e._s(e.trans("exam.observation_detail_max_mark"))+"\n            ")])}))],2):e._e(),e._v(" "),e._l(e.scheduleForm.records,(function(s,t){return a("div",{staticClass:"row"},[a("div",{staticClass:"col-12 col-sm-3"},[a("div",{staticClass:"form-group"},[e._v("\n                    "+e._s(s.subject_name)+"\n                    "),a("div",{staticClass:"form-group"},[a("label",{staticClass:"custom-control custom-checkbox"},[a("input",{directives:[{name:"model",rawName:"v-model",value:s.has_no_exam,expression:"record.has_no_exam"}],staticClass:"custom-control-input",attrs:{type:"checkbox",value:"1"},domProps:{checked:Array.isArray(s.has_no_exam)?e._i(s.has_no_exam,"1")>-1:s.has_no_exam},on:{change:function(a){var t=s.has_no_exam,n=a.target,r=!!n.checked;if(Array.isArray(t)){var o=e._i(t,"1");n.checked?o<0&&e.$set(s,"has_no_exam",t.concat(["1"])):o>-1&&e.$set(s,"has_no_exam",t.slice(0,o).concat(t.slice(o+1)))}else e.$set(s,"has_no_exam",r)}}}),e._v(" "),a("span",{staticClass:"custom-control-label"},[e._v(e._s(e.trans("academic.subject_has_no_exam")))])])])])]),e._v(" "),s.has_no_exam?e._e():[a("div",{staticClass:"col-12 col-sm-3"},[a("div",{staticClass:"form-group"},[a("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("exam.schedule_date")},on:{selected:function(s){e.scheduleForm.errors.clear(e.getScheduleDateName(t))}},model:{value:s.date,callback:function(a){e.$set(s,"date",a)},expression:"record.date"}}),e._v(" "),a("show-error",{attrs:{"form-name":e.scheduleForm,"prop-name":e.getScheduleDateName(t)}})],1)]),e._v(" "),e._l(s.assessment_details,(function(s,n){return a("div",{staticClass:"col-12 col-sm-3"},[a("div",{staticClass:"row"},[a("div",{staticClass:"col-12 col-sm-3"},[a("div",{staticClass:"form-group"},[a("label",{staticClass:"custom-control custom-checkbox"},[a("input",{directives:[{name:"model",rawName:"v-model",value:s.is_applicable,expression:"detail.is_applicable"}],staticClass:"custom-control-input",attrs:{type:"checkbox",value:"1"},domProps:{checked:Array.isArray(s.is_applicable)?e._i(s.is_applicable,"1")>-1:s.is_applicable},on:{change:function(a){var t=s.is_applicable,n=a.target,r=!!n.checked;if(Array.isArray(t)){var o=e._i(t,"1");n.checked?o<0&&e.$set(s,"is_applicable",t.concat(["1"])):o>-1&&e.$set(s,"is_applicable",t.slice(0,o).concat(t.slice(o+1)))}else e.$set(s,"is_applicable",r)}}}),e._v(" "),a("span",{staticClass:"custom-control-label"},[e._v(e._s(e.trans("assessment.is_applicable")))])])])]),e._v(" "),s.is_applicable?a("div",{staticClass:"col-12 col-sm-9"},[a("div",{staticClass:"form-group"},[a("input",{directives:[{name:"model",rawName:"v-model",value:s.max_mark,expression:"detail.max_mark"}],staticClass:"form-control",attrs:{type:"text",name:e.getDetailMaxMark(t,n),placeholder:e.trans("exam.assessment_detail_max_mark")},domProps:{value:s.max_mark},on:{input:function(a){a.target.composing||e.$set(s,"max_mark",a.target.value)}}}),e._v(" "),a("show-error",{attrs:{"form-name":e.scheduleForm,"prop-name":e.getDetailMaxMark(t,n)}})],1)]):e._e()])])}))]],2)})),e._v(" "),a("div",{staticClass:"card-footer text-right"},[a("router-link",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/exam/schedule"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),a("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.id?a("span",[e._v(e._s(e.trans("general.update")))]):a("span",[e._v(e._s(e.trans("general.save")))])])],1)],2),e._v(" "),e.showExamModal?a("transition",{attrs:{name:"modal"}},[a("div",{staticClass:"modal-mask"},[a("div",{staticClass:"modal-wrapper"},[a("div",{staticClass:"modal-container modal-lg"},[a("div",{staticClass:"modal-header"},[e._t("header",(function(){return[e._v("\n                            "+e._s(e.trans("exam.add_new_exam"))+"\n                            "),a("span",{staticClass:"float-right pointer",on:{click:function(s){e.showExamModal=!1}}},[e._v("x")])]}))],2),e._v(" "),a("div",{staticClass:"modal-body"},[e._t("body",(function(){return[a("exam-form",{on:{completed:e.getPreRequisite,cancel:function(s){e.showExamModal=!1}}}),e._v(" "),a("div",{staticClass:"clearfix"})]}))],2)])])])]):e._e()],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=create.js.map?id=8502922aae880908761d