<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class PasswordReset extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    protected $user;
    protected $token;

    public function __construct($user, $token)
    {
        $this->user = $user;
        $this->token = $token;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * To send Password Reset mail after request
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $url = url('/password/reset');

        return (new MailMessage)
                    ->subject('Password Reset | '.config('app.name'))
                    ->greeting('Hello '.$this->user->name)
                    ->line('We have recevied password reset request from you!')
                    ->line('Your password reset code is ' . $this->token)
                    ->action('Reset Password', $url)
                    ->line('This password reset code is valid for '. config('config.reset_password_token_lifetime'). ' minutes.')
                    ->line('If you haven\'t requested for password reset, please ignore this email.')
                    ->line('Thank you!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
